/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NativeObjRegistry<T> {
    private static final int INITIAL_ID = 1;
    private final String name;
    private final boolean debug;
    private final BiMap<Long, T> nativeObjToIdMap = HashBiMap.create();
    private final Map<Long, DebugInfo> idToDebugInfoMap;
    private long nextId = 1L;

    public NativeObjRegistry(Class<T> theClass) {
        this(theClass, false);
    }

    public NativeObjRegistry(Class<T> theClass, boolean debug) {
        this(theClass.getSimpleName(), debug);
    }

    public NativeObjRegistry(String name) {
        this(name, false);
    }

    public NativeObjRegistry(String name, boolean debug) {
        this.name = name;
        this.debug = debug;
        this.idToDebugInfoMap = debug ? new HashMap() : null;
    }

    @Deprecated
    public synchronized long getNativeObjectId(T o) {
        Preconditions.checkNotNull(o);
        Long nativeId = (Long)this.nativeObjToIdMap.inverse().get(o);
        if (nativeId == null) {
            nativeId = this.nextId;
            if (this.debug) {
                System.out.printf("NativeObjRegistry %s: register %d -> %s%n", this.name, nativeId, o);
            }
            this.nativeObjToIdMap.put((Object)nativeId, o);
            ++this.nextId;
        }
        return nativeId;
    }

    public synchronized long register(T o) {
        Preconditions.checkNotNull(o);
        Long nativeId = (Long)this.nativeObjToIdMap.inverse().get(o);
        if (nativeId != null) {
            DebugInfo debugInfo;
            if (this.debug && (debugInfo = this.idToDebugInfoMap.get(nativeId)) != null) {
                System.out.printf("NativeObjRegistry %s: register %d -> %s already registered:%n", this.name, nativeId, o);
                debugInfo.registrationTrace.printStackTrace(System.out);
            }
            throw new IllegalStateException("Object was previously registered with id " + nativeId);
        }
        nativeId = this.nextId;
        if (this.debug) {
            System.out.printf("NativeObjRegistry %s: register %d -> %s%n", this.name, nativeId, o);
            this.idToDebugInfoMap.put(nativeId, new DebugInfo(new Trace(o)));
        }
        this.nativeObjToIdMap.put((Object)nativeId, o);
        ++this.nextId;
        return nativeId;
    }

    public synchronized T unregister(long nativeId) {
        Object o = this.nativeObjToIdMap.remove((Object)nativeId);
        if (this.debug) {
            System.out.printf("NativeObjRegistry %s: unregister %d -> %s%n", this.name, nativeId, o);
            new RuntimeException("unregister debug").printStackTrace(System.out);
        }
        if (o == null) {
            if (this.debug) {
                DebugInfo debugInfo = this.idToDebugInfoMap.get(nativeId);
                debugInfo.unregistrationTraces.add(new Trace(o));
                if (debugInfo.unregistrationTraces.size() > 1) {
                    System.out.format("NativeObjRegistry %s: Too many unregistrations:%n", this.name);
                    for (Trace unregistration : debugInfo.unregistrationTraces) {
                        unregistration.printStackTrace(System.out);
                    }
                }
            }
            throw new IllegalStateException(nativeId + " has already been removed (or was never registered)");
        }
        return (T)o;
    }

    @Deprecated
    public synchronized void unregister(T removed) {
        this.nativeObjToIdMap.inverse().remove(removed);
    }

    public synchronized T getNativeObject(long nativeId) {
        Object object = this.nativeObjToIdMap.get((Object)nativeId);
        if (object != null) {
            return (T)object;
        }
        throw new NullPointerException(String.format("Could not find object with nativeId: %d. Currently registered ids: %s", nativeId, this.nativeObjToIdMap.keySet()));
    }

    public synchronized T peekNativeObject(long nativeId) {
        return (T)this.nativeObjToIdMap.get((Object)nativeId);
    }

    public synchronized void clear() {
        this.nextId = 1L;
        this.nativeObjToIdMap.clear();
    }

    private static class Trace
    extends Throwable {
        private int apiLevel;
        private boolean useLegacyResources;

        private Trace(Object o) {
            try {
                Class<?> runtimeEnvClass = o.getClass().getClassLoader().loadClass("org.robolectric.RuntimeEnvironment");
                this.apiLevel = (Integer)runtimeEnvClass.getMethod("getApiLevel", new Class[0]).invoke(null, new Object[0]);
                this.useLegacyResources = (Boolean)runtimeEnvClass.getMethod("useLegacyResources", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Trace(int apiLevel, boolean legacyResources) {
        }
    }

    private static class DebugInfo {
        final Trace registrationTrace;
        final List<Trace> unregistrationTraces = new ArrayList<Trace>();

        public DebugInfo(Trace trace) {
            this.registrationTrace = trace;
        }
    }
}

