/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.robolectric.res.ResourceIdGenerator;

class ResourceRemapper {
    private BiMap<String, Integer> resIds = HashBiMap.create();
    private ResourceIdGenerator resourceIdGenerator = new ResourceIdGenerator(127);

    ResourceRemapper(Class<?> primaryRClass) {
        if (primaryRClass != null) {
            this.remapRClass(true, primaryRClass);
        }
    }

    void remapRClass(Class<?> rClass) {
        this.remapRClass(false, rClass);
    }

    private void remapRClass(boolean isPrimary, Class<?> rClass) {
        String resourceType;
        HashMap<Integer, String> localAttributeIds = new HashMap<Integer, String>();
        for (Class<?> aClass : rClass.getClasses()) {
            if (!aClass.getSimpleName().equals("attr")) continue;
            for (Field field : aClass.getFields()) {
                try {
                    localAttributeIds.put(field.getInt(null), field.getName());
                }
                catch (IllegalAccessException e) {
                    String string = String.valueOf(field.getName());
                    throw new RuntimeException(string.length() != 0 ? "Could not read attr value for ".concat(string) : new String("Could not read attr value for "), e);
                }
            }
        }
        for (Class<?> innerClass : rClass.getClasses()) {
            resourceType = innerClass.getSimpleName();
            if (resourceType.startsWith("styleable")) continue;
            for (Field field : innerClass.getFields()) {
                try {
                    int remappedValue;
                    if (!isPrimary && Modifier.isFinal(field.getModifiers())) {
                        String string = String.valueOf(rClass);
                        throw new IllegalArgumentException(new StringBuilder(85 + String.valueOf(string).length()).append(string).append(" contains final fields, these will be inlined by the compiler and cannot be remapped.").toString());
                    }
                    String string = field.getName();
                    String resourceName = new StringBuilder(1 + String.valueOf(resourceType).length() + String.valueOf(string).length()).append(resourceType).append("/").append(string).toString();
                    Integer value = (Integer)this.resIds.get((Object)resourceName);
                    if (value != null) {
                        field.setAccessible(true);
                        field.setInt(null, value);
                        this.resourceIdGenerator.record(field.getInt(null), resourceType, field.getName());
                        continue;
                    }
                    if (this.resIds.containsValue((Object)field.getInt(null))) {
                        remappedValue = this.resourceIdGenerator.generate(resourceType, field.getName());
                        field.setInt(null, remappedValue);
                        this.resIds.put((Object)resourceName, (Object)remappedValue);
                        continue;
                    }
                    if (isPrimary) {
                        this.resourceIdGenerator.record(field.getInt(null), resourceType, field.getName());
                        this.resIds.put((Object)resourceName, (Object)field.getInt(null));
                        continue;
                    }
                    remappedValue = this.resourceIdGenerator.generate(resourceType, field.getName());
                    field.setInt(null, remappedValue);
                    this.resIds.put((Object)resourceName, (Object)remappedValue);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        for (Class<?> innerClass : rClass.getClasses()) {
            resourceType = innerClass.getSimpleName();
            if (!resourceType.startsWith("styleable")) continue;
            for (Field field : innerClass.getFields()) {
                if (!field.getType().equals(int[].class)) continue;
                try {
                    int[] styleableArray = (int[])field.get(null);
                    for (int k = 0; k < styleableArray.length; ++k) {
                        String string = String.valueOf((String)localAttributeIds.get(styleableArray[k]));
                        Integer value = (Integer)this.resIds.get((Object)(string.length() != 0 ? "attr/".concat(string) : new String("attr/")));
                        if (value == null) continue;
                        styleableArray[k] = value;
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

