/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.robolectric.res.Fs;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.AssetDir;
import org.robolectric.res.android.AssetPath;
import org.robolectric.res.android.FileMap;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResTable;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.SortedVector;
import org.robolectric.res.android.String8;
import org.robolectric.res.android.Util;
import org.robolectric.res.android.ZipFileRO;
import org.robolectric.util.PerfStatsCollector;

public class CppAssetManager {
    private static final boolean kIsDebug = false;
    private final Object mLock = new Object();
    private static final ZipSet mZipSet = new ZipSet();
    private final List<asset_path> mAssetPaths = new ArrayList<asset_path>();
    private String mLocale;
    private ResTable mResources;
    private ResTable_config mConfig = new ResTable_config();
    static final String kAssetsRoot = "assets";
    static final String kAppZipName = null;
    static final String kSystemAssets = "android.jar";
    static final String kExcludeExtension = ".EXCLUDE";
    static final Asset kExcludedAsset = Asset.EXCLUDED_ASSET;
    static volatile int gCount = 0;

    String8 idmapPathForPackagePath(String8 pkgPath) {
        return pkgPath;
    }

    public static int getGlobalCount() {
        return gCount;
    }

    public boolean addAssetPath(String8 path, Ref<Integer> cookie, boolean appAsLib) {
        return this.addAssetPath(path, cookie, appAsLib, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAssetPath(String8 path, @Nullable Ref<Integer> cookie, boolean appAsLib, boolean isSystemAsset) {
        Object object = this.mLock;
        synchronized (object) {
            asset_path ap = new asset_path();
            String8 realPath = path;
            if (kAppZipName != null) {
                realPath.appendPath(kAppZipName);
            }
            ap.type = this.getFileType(realPath.string());
            if (ap.type == FileType.kFileTypeRegular) {
                ap.path = realPath;
            } else {
                ap.path = path;
                ap.type = this.getFileType(path.string());
                if (ap.type != FileType.kFileTypeDirectory && ap.type != FileType.kFileTypeRegular) {
                    Util.ALOGW("Asset path %s is neither a directory nor file (type=%s).", path.toString(), ap.type.name());
                    return false;
                }
            }
            for (int i = 0; i < this.mAssetPaths.size(); ++i) {
                if (!this.mAssetPaths.get((int)i).path.equals(ap.path)) continue;
                if (cookie != null) {
                    cookie.set(i + 1);
                }
                return true;
            }
            Util.ALOGV("In %s Asset %s path: %s", this, ap.type.name(), ap.path.toString());
            ap.isSystemAsset = isSystemAsset;
            this.mAssetPaths.add(ap);
            if (cookie != null) {
                cookie.set(this.mAssetPaths.size());
            }
            if (this.mResources != null) {
                this.appendPathToResTable(ap, appAsLib);
            }
            return true;
        }
    }

    public boolean addDefaultAssets(Path systemAssetsPath) {
        return this.addDefaultAssets(Fs.externalize(systemAssetsPath));
    }

    public boolean addDefaultAssets(String systemAssetsPath) {
        String8 path = new String8(systemAssetsPath);
        return this.addAssetPath(path, null, false, true);
    }

    void setLocaleLocked(String locale) {
        this.mLocale = locale;
        this.updateResourceParamsLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(ResTable_config config, String locale) {
        Object object = this.mLock;
        synchronized (object) {
            this.mConfig = config;
            if (Util.isTruthy(locale)) {
                this.setLocaleLocked(locale);
            } else if (config.language[0] != 0) {
                String spec = config.getBcp47Locale(false);
                this.setLocaleLocked(spec);
            } else {
                this.updateResourceParamsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void getConfiguration(Ref<ResTable_config> outConfig) {
        Object object = this.mLock;
        synchronized (object) {
            outConfig.set(this.mConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Asset open(String fileName, Asset.AccessMode mode) {
        Object object = this.mLock;
        synchronized (object) {
            Util.LOG_FATAL_IF(this.mAssetPaths.isEmpty(), "No assets added to AssetManager", new Object[0]);
            String8 assetName = new String8(kAssetsRoot);
            assetName.appendPath(fileName);
            int i = this.mAssetPaths.size();
            while (i > 0) {
                Util.ALOGV("Looking for asset '%s' in '%s'\n", assetName.string(), this.mAssetPaths.get((int)(--i)).path.string());
                Asset pAsset = CppAssetManager.openNonAssetInPathLocked(assetName.string(), mode, this.mAssetPaths.get(i));
                if (pAsset == null) continue;
                return Objects.equals(pAsset, kExcludedAsset) ? null : pAsset;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Asset openNonAsset(String fileName, Asset.AccessMode mode, Ref<Integer> outCookie) {
        Object object = this.mLock;
        synchronized (object) {
            Util.LOG_FATAL_IF(this.mAssetPaths.isEmpty(), "No assets added to AssetManager", new Object[0]);
            int i = this.mAssetPaths.size();
            while (i > 0) {
                Util.ALOGV("Looking for non-asset '%s' in '%s'\n", fileName, this.mAssetPaths.get((int)(--i)).path.string());
                Asset pAsset = CppAssetManager.openNonAssetInPathLocked(fileName, mode, this.mAssetPaths.get(i));
                if (pAsset == null) continue;
                if (outCookie != null) {
                    outCookie.set(i + 1);
                }
                return pAsset != kExcludedAsset ? pAsset : null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Asset openNonAsset(int cookie, String fileName, Asset.AccessMode mode) {
        int which = cookie - 1;
        Object object = this.mLock;
        synchronized (object) {
            Util.LOG_FATAL_IF(this.mAssetPaths.isEmpty(), "No assets added to AssetManager", new Object[0]);
            if (which < this.mAssetPaths.size()) {
                Util.ALOGV("Looking for non-asset '%s' in '%s'\n", fileName, this.mAssetPaths.get((int)which).path.string());
                Asset pAsset = CppAssetManager.openNonAssetInPathLocked(fileName, mode, this.mAssetPaths.get(which));
                if (pAsset != null) {
                    return pAsset != kExcludedAsset ? pAsset : null;
                }
            }
            return null;
        }
    }

    FileType getFileType(String fileName) {
        File assetFile = new File(fileName);
        if (!assetFile.exists()) {
            return FileType.kFileTypeNonexistent;
        }
        if (assetFile.isFile()) {
            return FileType.kFileTypeRegular;
        }
        if (assetFile.isDirectory()) {
            return FileType.kFileTypeDirectory;
        }
        return FileType.kFileTypeNonexistent;
    }

    boolean appendPathToResTable(asset_path ap, boolean appAsLib) {
        String string = ap.isSystemAsset ? "framework" : "app";
        return (Boolean)PerfStatsCollector.getInstance().measure(new StringBuilder(22 + String.valueOf(string).length()).append("load binary ").append(string).append(" resources").toString(), () -> this.appendPathToResTable_measured(ap, appAsLib));
    }

    boolean appendPathToResTable_measured(asset_path ap, boolean appAsLib) {
        if (ap.isSystemOverlay) {
            return true;
        }
        Asset ass = null;
        ResTable sharedRes = null;
        boolean shared = true;
        boolean onlyEmptyResources = true;
        Asset idmap = this.openIdmapLocked(ap);
        int nextEntryIdx = this.mResources.getTableCount();
        Util.ALOGV("Looking for resource asset in '%s'\n", ap.path.string());
        if (ap.type != FileType.kFileTypeDirectory) {
            if (nextEntryIdx == 0 && (sharedRes = mZipSet.getZipResourceTable(ap.path)) != null) {
                nextEntryIdx = sharedRes.getTableCount();
            }
            if (sharedRes == null) {
                ass = mZipSet.getZipResourceTableAsset(ap.path);
                if (ass == null) {
                    Util.ALOGV("loading resource table %s\n", ap.path.string());
                    ass = CppAssetManager.openNonAssetInPathLocked("resources.arsc", Asset.AccessMode.ACCESS_BUFFER, ap);
                    if (ass != null && ass != kExcludedAsset) {
                        ass = mZipSet.setZipResourceTableAsset(ap.path, ass);
                    }
                }
                if (nextEntryIdx == 0 && ass != null) {
                    Util.ALOGV("Creating shared resources for %s", ap.path.string());
                    sharedRes = new ResTable();
                    sharedRes.add(ass, idmap, nextEntryIdx + 1, false, false, false);
                    sharedRes = mZipSet.setZipResourceTable(ap.path, sharedRes);
                }
            }
        } else {
            Util.ALOGV("loading resource table %s\n", ap.path.string());
            ass = CppAssetManager.openNonAssetInPathLocked("resources.arsc", Asset.AccessMode.ACCESS_BUFFER, ap);
            shared = false;
        }
        if ((ass != null || sharedRes != null) && ass != kExcludedAsset) {
            Util.ALOGV("Installing resource asset %s in to table %s\n", ass, this.mResources);
            if (sharedRes != null) {
                Util.ALOGV("Copying existing resources for %s", ap.path.string());
                this.mResources.add(sharedRes, ap.isSystemAsset);
            } else {
                Util.ALOGV("Parsing resources for %s", ap.path.string());
                this.mResources.add(ass, idmap, nextEntryIdx + 1, !shared, appAsLib, ap.isSystemAsset);
            }
            onlyEmptyResources = false;
        } else {
            Util.ALOGV("Installing empty resources in to table %s\n", this.mResources);
            this.mResources.addEmpty(nextEntryIdx + 1);
        }
        return onlyEmptyResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ResTable getResTable(boolean required) {
        ResTable rt = this.mResources;
        if (Util.isTruthy(rt)) {
            return rt;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResources != null) {
                return this.mResources;
            }
            if (required) {
                Util.LOG_FATAL_IF(this.mAssetPaths.isEmpty(), "No assets added to AssetManager", new Object[0]);
            }
            PerfStatsCollector.getInstance().measure("load binary resources", () -> {
                this.mResources = new ResTable();
                this.updateResourceParamsLocked();
                boolean onlyEmptyResources = true;
                int N = this.mAssetPaths.size();
                for (int i = 0; i < N; ++i) {
                    boolean empty = this.appendPathToResTable(this.mAssetPaths.get(i), false);
                    onlyEmptyResources = onlyEmptyResources && empty;
                }
                if (required && onlyEmptyResources) {
                    Util.ALOGW("Unable to find resources file resources.arsc", new Object[0]);
                    this.mResources = null;
                }
            });
            return this.mResources;
        }
    }

    void updateResourceParamsLocked() {
        Util.ATRACE_CALL();
        ResTable res = this.mResources;
        if (!Util.isTruthy(res)) {
            return;
        }
        if (Util.isTruthy(this.mLocale)) {
            this.mConfig.setBcp47Locale(this.mLocale);
        } else {
            this.mConfig.clearLocale();
        }
        res.setParameters(this.mConfig);
    }

    Asset openIdmapLocked(asset_path ap) {
        Asset ass = null;
        if (ap.idmap.length() != 0) {
            ass = CppAssetManager.openAssetFromFileLocked(ap.idmap, Asset.AccessMode.ACCESS_BUFFER);
            if (Util.isTruthy(ass)) {
                Util.ALOGV("loading idmap %s\n", ap.idmap.string());
            } else {
                Util.ALOGW("failed to load idmap %s\n", ap.idmap.string());
            }
        }
        return ass;
    }

    public final ResTable getResources() {
        return this.getResources(true);
    }

    final ResTable getResources(boolean required) {
        ResTable rt = this.getResTable(required);
        return rt;
    }

    static Asset openNonAssetInPathLocked(String fileName, Asset.AccessMode mode, asset_path ap) {
        Asset pAsset = null;
        if (ap.type == FileType.kFileTypeDirectory) {
            String8 path = new String8(ap.path);
            path.appendPath(fileName);
            pAsset = CppAssetManager.openAssetFromFileLocked(path, mode);
            if (pAsset == null) {
                path.append(".gz");
                pAsset = CppAssetManager.openAssetFromFileLocked(path, mode);
            }
            if (pAsset != null) {
                pAsset.setAssetSource(path);
            }
        } else {
            ZipFileRO.ZipEntryRO entry;
            String8 path = new String8(fileName);
            ZipFileRO pZip = CppAssetManager.getZipFileLocked(ap);
            if (pZip != null && (entry = pZip.findEntryByName(path.string())) != null) {
                pAsset = CppAssetManager.openAssetFromZipLocked(pZip, entry, mode, path);
                pZip.releaseEntry(entry);
            }
            if (pAsset != null) {
                pAsset.setAssetSource(CppAssetManager.createZipSourceNameLocked(ap.path, new String8(), new String8(fileName)));
            }
        }
        return pAsset;
    }

    static String8 createZipSourceNameLocked(String8 zipFileName, String8 dirName, String8 fileName) {
        String8 sourceName = new String8("zip:");
        sourceName.append(zipFileName.string());
        sourceName.append(":");
        if (dirName.length() > 0) {
            sourceName.appendPath(dirName.string());
        }
        sourceName.appendPath(fileName.string());
        return sourceName;
    }

    static String8 createPathNameLocked(asset_path ap, String rootDir) {
        String8 path = new String8(ap.path);
        if (rootDir != null) {
            path.appendPath(rootDir);
        }
        return path;
    }

    static ZipFileRO getZipFileLocked(asset_path ap) {
        Util.ALOGV("getZipFileLocked() in %s\n", CppAssetManager.class);
        return mZipSet.getZip(ap.path.string());
    }

    static Asset openAssetFromFileLocked(String8 pathName, Asset.AccessMode mode) {
        Asset pAsset = null;
        pAsset = pathName.getPathExtension().toLowerCase().equals(".gz") ? Asset.createFromCompressedFile(pathName.string(), mode) : Asset.createFromFile(pathName.string(), mode);
        return pAsset;
    }

    static Asset openAssetFromZipLocked(ZipFileRO pZipFile, ZipFileRO.ZipEntryRO entry, Asset.AccessMode mode, String8 entryName) {
        Ref<Long> uncompressedLen;
        Asset pAsset = null;
        Ref<Short> method = new Ref<Short>((short)0);
        if (!pZipFile.getEntryInfo(entry, method, uncompressedLen = new Ref<Long>(0L), null, null, null, null)) {
            Util.ALOGW("getEntryInfo failed\n", new Object[0]);
            return null;
        }
        FileMap dataMap = pZipFile.createEntryFileMap(entry);
        if (method.get() == 0) {
            pAsset = Asset.createFromUncompressedMap(dataMap, mode);
            Util.ALOGV("Opened uncompressed entry %s in zip %s mode %s: %s", new Object[]{entryName.string(), pZipFile.mFileName, mode, pAsset});
        } else {
            pAsset = Asset.createFromCompressedMap(dataMap, Asset.toIntExact(uncompressedLen.get()), mode);
            Util.ALOGV("Opened compressed entry %s in zip %s mode %s: %s", new Object[]{entryName.string(), pZipFile.mFileName, mode, pAsset});
        }
        if (pAsset == null) {
            Util.ALOGW("create from segment failed\n", new Object[0]);
        }
        return pAsset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetDir openDir(String dirName) {
        Object object = this.mLock;
        synchronized (object) {
            AssetDir pDir = null;
            Util.LOG_FATAL_IF(this.mAssetPaths.isEmpty(), "No assets added to AssetManager", new Object[0]);
            Preconditions.checkNotNull((Object)dirName);
            pDir = new AssetDir();
            Ref<SortedVector<AssetDir.FileInfo>> pMergedInfo = new Ref<SortedVector<AssetDir.FileInfo>>(new SortedVector());
            int i = this.mAssetPaths.size();
            while (i > 0) {
                asset_path ap = this.mAssetPaths.get(--i);
                if (ap.type == FileType.kFileTypeRegular) {
                    Util.ALOGV("Adding directory %s from zip %s", dirName, ap.path.string());
                    this.scanAndMergeZipLocked(pMergedInfo, ap, kAssetsRoot, dirName);
                    continue;
                }
                Util.ALOGV("Adding directory %s from dir %s", dirName, ap.path.string());
                this.scanAndMergeDirLocked(pMergedInfo, ap, kAssetsRoot, dirName);
            }
            pDir.setFileList(pMergedInfo.get());
            return pDir;
        }
    }

    boolean scanAndMergeDirLocked(Ref<SortedVector<AssetDir.FileInfo>> pMergedInfoRef, asset_path ap, String rootDir, String dirName) {
        SortedVector<AssetDir.FileInfo> pContents;
        SortedVector<AssetDir.FileInfo> pMergedInfo = pMergedInfoRef.get();
        assert (pMergedInfo != null);
        String8 path = CppAssetManager.createPathNameLocked(ap, rootDir);
        if (dirName.charAt(0) != '\u0000') {
            path.appendPath(dirName);
        }
        if ((pContents = this.scanDirLocked(path)) == null) {
            return false;
        }
        int count = pContents.size();
        int exclExtLen = kExcludeExtension.length();
        for (int i = 0; i < count; ++i) {
            String name = pContents.itemAt(i).getFileName().string();
            int nameLen = name.length();
            if (!name.endsWith(kExcludeExtension)) continue;
            String8 match = new String8(name, nameLen - exclExtLen);
            int matchIdx = AssetDir.FileInfo.findEntry(pMergedInfo, match);
            if (matchIdx > 0) {
                Util.ALOGV("Excluding '%s' [%s]\n", pMergedInfo.itemAt(matchIdx).getFileName().string(), pMergedInfo.itemAt(matchIdx).getSourceName().string());
                pMergedInfo.removeAt(matchIdx);
            }
            Util.ALOGD("HEY: size=%d removing %d\n", pContents.size(), i);
            pContents.removeAt(i);
            --i;
            --count;
        }
        this.mergeInfoLocked(pMergedInfoRef, pContents);
        return true;
    }

    SortedVector<AssetDir.FileInfo> scanDirLocked(String8 path) {
        String8 pathCopy = new String8(path);
        SortedVector<AssetDir.FileInfo> pContents = null;
        Util.ALOGV("Scanning dir '%s'\n", path.string());
        File dir = new File(path.string());
        if (!dir.exists()) {
            return null;
        }
        pContents = new SortedVector<AssetDir.FileInfo>();
        for (File entry : dir.listFiles()) {
            if (entry == null) break;
            FileType fileType = this.getFileType(pathCopy.appendPath(entry.getName()).string());
            if (fileType != FileType.kFileTypeRegular && fileType != FileType.kFileTypeDirectory) continue;
            AssetDir.FileInfo info = new AssetDir.FileInfo();
            info.set(new String8(entry.getName()), fileType);
            if (info.getFileName().getPathExtension().equalsIgnoreCase(".gz")) {
                info.setFileName(info.getFileName().getBasePath());
            }
            info.setSourceName(pathCopy.appendPath(info.getFileName().string()));
            pContents.add(info);
        }
        return pContents;
    }

    boolean scanAndMergeZipLocked(Ref<SortedVector<AssetDir.FileInfo>> pMergedInfo, asset_path ap, String rootDir, String baseDirName) {
        ZipFileRO.ZipEntryRO entry;
        ArrayList<String8> dirs = new ArrayList<String8>();
        SortedVector<AssetDir.FileInfo> contents = new SortedVector<AssetDir.FileInfo>();
        String8 dirName = new String8();
        ZipFileRO pZip = mZipSet.getZip(ap.path.string());
        if (pZip == null) {
            Util.ALOGW("Failure opening zip %s\n", ap.path.string());
            return false;
        }
        String8 zipName = ZipSet.getPathName(ap.path.string());
        if (rootDir != null) {
            dirName = new String8(rootDir);
        }
        dirName.appendPath(baseDirName);
        int dirNameLen = dirName.length();
        Ref<Object> iterationCookie = new Ref<Object>(null);
        if (!pZip.startIteration(iterationCookie, dirName.string(), null)) {
            Util.ALOGW("ZipFileRO.startIteration returned false", new Object[0]);
            return false;
        }
        while ((entry = pZip.nextEntry(iterationCookie.get())) != null) {
            int j;
            int nextSlashIndex;
            Ref<Object> nameBuf = new Ref<Object>(null);
            if (pZip.getEntryFileName(entry, nameBuf) != 0) {
                Util.ALOGE("ARGH: name too long?\n", new Object[0]);
                continue;
            }
            String string = dirName.string();
            if (!((String)nameBuf.get()).startsWith(new StringBuilder(1 + String.valueOf(string).length()).append(string).append('/').toString()) || dirNameLen != 0 && ((String)nameBuf.get()).charAt(dirNameLen) != '/') continue;
            int cp = 0;
            cp += dirNameLen;
            if (dirNameLen != 0) {
                ++cp;
            }
            if ((nextSlashIndex = ((String)nameBuf.get()).indexOf(47, cp)) == -1) {
                String8 fileName = new String8(nameBuf.get()).getPathLeaf();
                if (fileName.string().isEmpty()) continue;
                AssetDir.FileInfo info = new AssetDir.FileInfo();
                info.set(fileName, FileType.kFileTypeRegular);
                info.setSourceName(CppAssetManager.createZipSourceNameLocked(zipName, dirName, info.getFileName()));
                contents.add(info);
                continue;
            }
            String8 subdirName = new String8(((String)nameBuf.get()).substring(cp, nextSlashIndex));
            int N = dirs.size();
            for (j = 0; j < N && !subdirName.equals(dirs.get(j)); ++j) {
            }
            if (j != N) continue;
            dirs.add(subdirName);
        }
        pZip.endIteration(iterationCookie);
        for (int i = 0; i < dirs.size(); ++i) {
            AssetDir.FileInfo info = new AssetDir.FileInfo();
            info.set((String8)dirs.get(i), FileType.kFileTypeDirectory);
            info.setSourceName(CppAssetManager.createZipSourceNameLocked(zipName, dirName, info.getFileName()));
            contents.add(info);
        }
        this.mergeInfoLocked(pMergedInfo, contents);
        return true;
    }

    void mergeInfoLocked(Ref<SortedVector<AssetDir.FileInfo>> pMergedInfoRef, SortedVector<AssetDir.FileInfo> pContents) {
        SortedVector<AssetDir.FileInfo> pMergedInfo = pMergedInfoRef.get();
        SortedVector<AssetDir.FileInfo> pNewSorted = new SortedVector<AssetDir.FileInfo>();
        int mergeMax = pMergedInfo.size();
        int contMax = pContents.size();
        int contIdx = 0;
        int mergeIdx = 0;
        while (mergeIdx < mergeMax || contIdx < contMax) {
            if (mergeIdx == mergeMax) {
                pNewSorted.add(pContents.itemAt(contIdx));
                ++contIdx;
                continue;
            }
            if (contIdx == contMax) {
                pNewSorted.add(pMergedInfo.itemAt(mergeIdx));
                ++mergeIdx;
                continue;
            }
            if (pMergedInfo.itemAt(mergeIdx) == pContents.itemAt(contIdx)) {
                pNewSorted.add(pContents.itemAt(contIdx));
                ++mergeIdx;
                ++contIdx;
                continue;
            }
            if (pMergedInfo.itemAt(mergeIdx).isLessThan(pContents.itemAt(contIdx))) {
                pNewSorted.add(pMergedInfo.itemAt(mergeIdx));
                ++mergeIdx;
                continue;
            }
            assert (pContents.itemAt(contIdx).isLessThan(pMergedInfo.itemAt(mergeIdx)));
            pNewSorted.add(pContents.itemAt(contIdx));
            ++contIdx;
        }
        pMergedInfoRef.set(pNewSorted);
    }

    private static long getFileModDate(String path) {
        try {
            return Files.getLastModifiedTime(Paths.get(path, new String[0]), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssetPath> getAssetPaths() {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<AssetPath> assetPaths = new ArrayList<AssetPath>(this.mAssetPaths.size());
            for (asset_path asset_path2 : this.mAssetPaths) {
                Path path;
                switch (asset_path2.type) {
                    case kFileTypeDirectory: {
                        path = Fs.fromUrl(asset_path2.path.string());
                        break;
                    }
                    case kFileTypeRegular: {
                        path = Fs.fromUrl(asset_path2.path.string());
                        break;
                    }
                    default: {
                        String string = String.valueOf((Object)asset_path2.type);
                        String string2 = asset_path2.path.string();
                        throw new IllegalStateException(new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unsupported type ").append(string).append(" for + ").append(string2).toString());
                    }
                }
                assetPaths.add(new AssetPath(path, asset_path2.isSystemAsset));
            }
            return assetPaths;
        }
    }

    static class ZipSet {
        final List<String> mZipPath = new ArrayList<String>();
        final List<SharedZip> mZipFile = new ArrayList<SharedZip>();

        ZipSet() {
        }

        protected void finalize() {
            int N = this.mZipFile.size();
            for (int i = 0; i < N; ++i) {
                this.closeZip(i);
            }
        }

        void closeZip(int idx) {
            this.mZipFile.set(idx, null);
        }

        synchronized ZipFileRO getZip(String path) {
            int idx = this.getIndex(path);
            SharedZip zip = this.mZipFile.get(idx);
            if (zip == null) {
                zip = SharedZip.get(new String8(path));
                this.mZipFile.set(idx, zip);
            }
            return zip.getZip();
        }

        synchronized Asset getZipResourceTableAsset(String8 path) {
            int idx = this.getIndex(path.string());
            SharedZip zip = this.mZipFile.get(idx);
            if (zip == null) {
                zip = SharedZip.get(path);
                this.mZipFile.set(idx, zip);
            }
            return zip.getResourceTableAsset();
        }

        synchronized Asset setZipResourceTableAsset(String8 path, Asset asset) {
            int idx = this.getIndex(path.string());
            SharedZip zip = this.mZipFile.get(idx);
            return zip.setResourceTableAsset(asset);
        }

        synchronized ResTable getZipResourceTable(String8 path) {
            int idx = this.getIndex(path.string());
            SharedZip zip = this.mZipFile.get(idx);
            if (zip == null) {
                zip = SharedZip.get(path);
                this.mZipFile.set(idx, zip);
            }
            return zip.getResourceTable();
        }

        synchronized ResTable setZipResourceTable(String8 path, ResTable res) {
            int idx = this.getIndex(path.string());
            SharedZip zip = this.mZipFile.get(idx);
            return zip.setResourceTable(res);
        }

        static String8 getPathName(String zipPath) {
            return new String8(zipPath);
        }

        int getIndex(String zip) {
            int N = this.mZipPath.size();
            for (int i = 0; i < N; ++i) {
                if (!Objects.equals(this.mZipPath.get(i), zip)) continue;
                return i;
            }
            this.mZipPath.add(zip);
            this.mZipFile.add(null);
            return this.mZipPath.size() - 1;
        }
    }

    static class SharedZip {
        final String mPath;
        final ZipFileRO mZipFile;
        final long mModWhen;
        Asset mResourceTableAsset;
        ResTable mResourceTable;
        List<asset_path> mOverlays;
        static final Object gLock = new Object();
        static final Map<String8, WeakReference<SharedZip>> gOpen = new HashMap<String8, WeakReference<SharedZip>>();

        public SharedZip(String path, long modWhen) {
            this.mPath = path;
            this.mModWhen = modWhen;
            this.mResourceTableAsset = null;
            this.mResourceTable = null;
            Util.ALOGV("+++ opening zip '%s'\n", this.mPath);
            this.mZipFile = ZipFileRO.open(this.mPath);
            if (this.mZipFile == null) {
                Util.ALOGD("failed to open Zip archive '%s'\n", this.mPath);
            }
        }

        static SharedZip get(String8 path) {
            return SharedZip.get(path, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SharedZip get(String8 path, boolean createIfNotPresent) {
            Object object = gLock;
            synchronized (object) {
                SharedZip zip;
                long modWhen = CppAssetManager.getFileModDate(path.string());
                WeakReference<SharedZip> ref = gOpen.get(path);
                SharedZip sharedZip = zip = ref == null ? null : (SharedZip)ref.get();
                if (zip != null && zip.mModWhen == modWhen) {
                    return zip;
                }
                if (zip == null && !createIfNotPresent) {
                    return null;
                }
                zip = new SharedZip(path.string(), modWhen);
                gOpen.put(path, new WeakReference<SharedZip>(zip));
                return zip;
            }
        }

        ZipFileRO getZip() {
            return this.mZipFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Asset getResourceTableAsset() {
            Object object = gLock;
            synchronized (object) {
                Util.ALOGV("Getting from SharedZip %s resource asset %s\n", this, this.mResourceTableAsset);
                return this.mResourceTableAsset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Asset setResourceTableAsset(Asset asset) {
            Object object = gLock;
            synchronized (object) {
                if (this.mResourceTableAsset == null) {
                    asset.getBuffer(true);
                    this.mResourceTableAsset = asset;
                    return asset;
                }
            }
            return this.mResourceTableAsset;
        }

        ResTable getResourceTable() {
            Util.ALOGV("Getting from SharedZip %s resource table %s\n", this, this.mResourceTable);
            return this.mResourceTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResTable setResourceTable(ResTable res) {
            Object object = gLock;
            synchronized (object) {
                if (this.mResourceTable == null) {
                    this.mResourceTable = res;
                    return res;
                }
            }
            return this.mResourceTable;
        }

        public String toString() {
            String id = Integer.toString(System.identityHashCode(this), 16);
            String string = this.mPath;
            return new StringBuilder(26 + String.valueOf(string).length() + String.valueOf(id).length()).append("SharedZip{mPath='").append(string).append("', id=0x").append(id).append("}").toString();
        }
    }

    private static class asset_path {
        String8 path;
        FileType type;
        String8 idmap;
        boolean isSystemOverlay;
        boolean isSystemAsset;

        public asset_path() {
            this(new String8(), FileType.kFileTypeRegular, new String8(""), false, false);
        }

        public asset_path(String8 path, FileType fileType, String8 idmap, boolean isSystemOverlay, boolean isSystemAsset) {
            this.path = path;
            this.type = fileType;
            this.idmap = idmap;
            this.isSystemOverlay = isSystemOverlay;
            this.isSystemAsset = isSystemAsset;
        }

        public String toString() {
            String string = String.valueOf(this.path);
            String string2 = String.valueOf((Object)this.type);
            String string3 = String.valueOf(this.idmap);
            boolean bl = this.isSystemOverlay;
            boolean bl2 = this.isSystemAsset;
            return new StringBuilder(78 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("asset_path{path=").append(string).append(", type=").append(string2).append(", idmap='").append(string3).append('\'').append(", isSystemOverlay=").append(bl).append(", isSystemAsset=").append(bl2).append('}').toString();
        }
    }

    static enum FileType {
        kFileTypeUnknown,
        kFileTypeNonexistent,
        kFileTypeRegular,
        kFileTypeDirectory,
        kFileTypeCharDev,
        kFileTypeBlockDev,
        kFileTypeFifo,
        kFileTypeSymlink,
        kFileTypeSocket;

    }
}

