/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.robolectric.res.DocumentLoader;
import org.robolectric.res.DrawableResourceLoader;
import org.robolectric.res.FileTypedResource;
import org.robolectric.res.Fs;
import org.robolectric.res.NodeHandler;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.RawResourceLoader;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.StaxArrayLoader;
import org.robolectric.res.StaxAttrLoader;
import org.robolectric.res.StaxDocumentLoader;
import org.robolectric.res.StaxPluralsLoader;
import org.robolectric.res.StaxStyleLoader;
import org.robolectric.res.StaxValueLoader;
import org.robolectric.res.XmlContext;
import org.robolectric.util.Logger;
import org.robolectric.util.PerfStatsCollector;

public class ResourceTableFactory {
    public PackageResourceTable newFrameworkResourceTable(ResourcePath resourcePath) {
        return (PackageResourceTable)PerfStatsCollector.getInstance().measure("load legacy framework resources", () -> {
            PackageResourceTable resourceTable = new PackageResourceTable("android");
            if (resourcePath.getRClass() != null) {
                this.addRClassValues(resourceTable, resourcePath.getRClass());
                this.addMissingStyleableAttributes(resourceTable, resourcePath.getRClass());
            }
            if (resourcePath.getInternalRClass() != null) {
                this.addRClassValues(resourceTable, resourcePath.getInternalRClass());
                this.addMissingStyleableAttributes(resourceTable, resourcePath.getInternalRClass());
            }
            this.parseResourceFiles(resourcePath, resourceTable);
            return resourceTable;
        });
    }

    public PackageResourceTable newResourceTable(String packageName, ResourcePath ... resourcePaths) {
        return (PackageResourceTable)PerfStatsCollector.getInstance().measure("load legacy app resources", () -> {
            PackageResourceTable resourceTable = new PackageResourceTable(packageName);
            for (ResourcePath resourcePath : resourcePaths) {
                if (resourcePath.getRClass() == null) continue;
                this.addRClassValues(resourceTable, resourcePath.getRClass());
            }
            for (ResourcePath resourcePath : resourcePaths) {
                this.parseResourceFiles(resourcePath, resourceTable);
            }
            return resourceTable;
        });
    }

    private void addRClassValues(PackageResourceTable resourceTable, Class<?> rClass) {
        for (Class<?> innerClass : rClass.getClasses()) {
            String resourceType = innerClass.getSimpleName();
            if (resourceType.equals("styleable")) continue;
            for (Field field : innerClass.getDeclaredFields()) {
                int id;
                if (!field.getType().equals(Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
                try {
                    id = field.getInt(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                String resourceName = field.getName();
                if (id == 0) {
                    Logger.debug((String)("Ignoring staged resource " + resourceName), (Object[])new Object[0]);
                    continue;
                }
                resourceTable.addResource(id, resourceType, resourceName);
            }
        }
    }

    private void addMissingStyleableAttributes(PackageResourceTable resourceTable, Class<?> rClass) {
        for (Class<?> innerClass : rClass.getClasses()) {
            if (!innerClass.getSimpleName().equals("styleable")) continue;
            String styleableName = null;
            int[] styleableArray = null;
            for (Field field : innerClass.getDeclaredFields()) {
                if (field.getType().equals(int[].class) && Modifier.isStatic(field.getModifiers())) {
                    styleableName = field.getName();
                    try {
                        styleableArray = (int[])field.get(null);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!field.getType().equals(Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
                String attributeName = field.getName().substring(styleableName.length() + 1);
                try {
                    int styleableIndex = field.getInt(null);
                    int attributeResId = styleableArray[styleableIndex];
                    resourceTable.addResource(attributeResId, "attr", attributeName);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void parseResourceFiles(ResourcePath resourcePath, PackageResourceTable resourceTable) {
        if (!resourcePath.hasResources()) {
            Logger.debug((String)"No resources for %s", (Object[])new Object[]{resourceTable.getPackageName()});
            return;
        }
        Logger.debug((String)"Loading resources for %s from %s...", (Object[])new Object[]{resourceTable.getPackageName(), resourcePath.getResourceBase()});
        try {
            new StaxDocumentLoader(resourceTable.getPackageName(), resourcePath.getResourceBase(), new NodeHandler().addHandler("resources", new NodeHandler().addHandler("bool", new StaxValueLoader(resourceTable, "bool", ResType.BOOLEAN)).addHandler("item[@type='bool']", new StaxValueLoader(resourceTable, "bool", ResType.BOOLEAN)).addHandler("color", new StaxValueLoader(resourceTable, "color", ResType.COLOR)).addHandler("item[@type='color']", new StaxValueLoader(resourceTable, "color", ResType.COLOR)).addHandler("drawable", new StaxValueLoader(resourceTable, "drawable", ResType.DRAWABLE)).addHandler("item[@type='drawable']", new StaxValueLoader(resourceTable, "drawable", ResType.DRAWABLE)).addHandler("item[@type='mipmap']", new StaxValueLoader(resourceTable, "mipmap", ResType.DRAWABLE)).addHandler("dimen", new StaxValueLoader(resourceTable, "dimen", ResType.DIMEN)).addHandler("item[@type='dimen']", new StaxValueLoader(resourceTable, "dimen", ResType.DIMEN)).addHandler("integer", new StaxValueLoader(resourceTable, "integer", ResType.INTEGER)).addHandler("item[@type='integer']", new StaxValueLoader(resourceTable, "integer", ResType.INTEGER)).addHandler("integer-array", new StaxArrayLoader(resourceTable, "array", ResType.INTEGER_ARRAY, ResType.INTEGER)).addHandler("fraction", new StaxValueLoader(resourceTable, "fraction", ResType.FRACTION)).addHandler("item[@type='fraction']", new StaxValueLoader(resourceTable, "fraction", ResType.FRACTION)).addHandler("item[@type='layout']", new StaxValueLoader(resourceTable, "layout", ResType.LAYOUT)).addHandler("plurals", new StaxPluralsLoader(resourceTable, "plurals", ResType.CHAR_SEQUENCE)).addHandler("string", new StaxValueLoader(resourceTable, "string", ResType.CHAR_SEQUENCE)).addHandler("item[@type='string']", new StaxValueLoader(resourceTable, "string", ResType.CHAR_SEQUENCE)).addHandler("string-array", new StaxArrayLoader(resourceTable, "array", ResType.CHAR_SEQUENCE_ARRAY, ResType.CHAR_SEQUENCE)).addHandler("array", new StaxArrayLoader(resourceTable, "array", ResType.TYPED_ARRAY, null)).addHandler("id", new StaxValueLoader(resourceTable, "id", ResType.CHAR_SEQUENCE)).addHandler("item[@type='id']", new StaxValueLoader(resourceTable, "id", ResType.CHAR_SEQUENCE)).addHandler("attr", new StaxAttrLoader(resourceTable, "attr", ResType.ATTR_DATA)).addHandler("declare-styleable", new NodeHandler().addHandler("attr", new StaxAttrLoader(resourceTable, "attr", ResType.ATTR_DATA))).addHandler("style", new StaxStyleLoader(resourceTable, "style", ResType.STYLE)))).load("values");
            this.loadOpaque(resourcePath, resourceTable, "layout", ResType.LAYOUT);
            this.loadOpaque(resourcePath, resourceTable, "menu", ResType.LAYOUT);
            this.loadOpaque(resourcePath, resourceTable, "drawable", ResType.DRAWABLE);
            this.loadOpaque(resourcePath, resourceTable, "mipmap", ResType.DRAWABLE);
            this.loadOpaque(resourcePath, resourceTable, "anim", ResType.LAYOUT);
            this.loadOpaque(resourcePath, resourceTable, "animator", ResType.LAYOUT);
            this.loadOpaque(resourcePath, resourceTable, "color", ResType.COLOR_STATE_LIST);
            this.loadOpaque(resourcePath, resourceTable, "xml", ResType.LAYOUT);
            this.loadOpaque(resourcePath, resourceTable, "transition", ResType.LAYOUT);
            this.loadOpaque(resourcePath, resourceTable, "interpolator", ResType.LAYOUT);
            new DrawableResourceLoader(resourceTable).findDrawableResources(resourcePath);
            new RawResourceLoader(resourcePath).loadTo(resourceTable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadOpaque(ResourcePath resourcePath, final PackageResourceTable resourceTable, final String type, final ResType resType) throws IOException {
        new DocumentLoader(this, resourceTable.getPackageName(), resourcePath.getResourceBase()){

            @Override
            protected void loadResourceXmlFile(XmlContext xmlContext) {
                resourceTable.addResource(type, Fs.baseNameFor(xmlContext.getXmlFile()), new FileTypedResource(xmlContext.getXmlFile(), resType, xmlContext));
            }
        }.load(type);
    }
}

