/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.res.android.Chunk;
import org.robolectric.res.android.Idmap;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResStringPool;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.ResourceUtils;
import org.robolectric.res.android.StringPiece;
import org.robolectric.res.android.Util;

public class LoadedArsc {
    final ResStringPool global_string_pool_ = new ResStringPool();
    final List<LoadedPackage> packages_ = new ArrayList<LoadedPackage>();
    boolean system_ = false;
    static final int kAppPackageId = 127;

    public ResStringPool GetStringPool() {
        return this.global_string_pool_;
    }

    List<LoadedPackage> GetPackages() {
        return this.packages_;
    }

    boolean IsSystem() {
        return this.system_;
    }

    static boolean VerifyResTableType(ResourceTypes.ResTable_type header) {
        if (header.id == 0) {
            Util.logError("RES_TABLE_TYPE_TYPE has invalid ID 0.");
            return false;
        }
        int entry_count = Util.dtohl(header.entryCount);
        if (entry_count > 65535) {
            Util.logError("RES_TABLE_TYPE_TYPE has too many entries (" + entry_count + ").");
            return false;
        }
        short offsets_offset = Util.dtohs(header.header.headerSize);
        int entries_offset = Util.dtohl(header.entriesStart);
        int offsets_length = 4 * entry_count;
        if (offsets_offset > entries_offset || entries_offset - offsets_offset < offsets_length) {
            Util.logError("RES_TABLE_TYPE_TYPE entry offsets overlap actual entry data.");
            return false;
        }
        if (entries_offset > Util.dtohl(header.header.size)) {
            Util.logError("RES_TABLE_TYPE_TYPE entry offsets extend beyond chunk.");
            return false;
        }
        if (Util.isTruthy(entries_offset & 3)) {
            Util.logError("RES_TABLE_TYPE_TYPE entries start at unaligned address.");
            return false;
        }
        return true;
    }

    static boolean VerifyResTableEntry(ResourceTypes.ResTable_type type, int entry_offset) {
        if (Util.isTruthy(entry_offset & 3)) {
            Util.logError("Entry at offset " + entry_offset + " is not 4-byte aligned.");
            return false;
        }
        if (entry_offset > Integer.MAX_VALUE - Util.dtohl(type.entriesStart)) {
            Util.logError("Entry at offset " + entry_offset + " is too large.");
            return false;
        }
        int chunk_size = Util.dtohl(type.header.size);
        if ((entry_offset += Util.dtohl(type.entriesStart)) > chunk_size - 8) {
            Util.logError("Entry at offset " + entry_offset + " is too large. No room for ResTable_entry.");
            return false;
        }
        ResourceTypes.ResTable_entry entry = new ResourceTypes.ResTable_entry(type.myBuf(), type.myOffset() + entry_offset);
        short entry_size = Util.dtohs(entry.size);
        if (entry_size < 8) {
            Util.logError("ResTable_entry size " + entry_size + " at offset " + entry_offset + " is too small.");
            return false;
        }
        if (entry_size > chunk_size || entry_offset > chunk_size - entry_size) {
            Util.logError("ResTable_entry size " + entry_size + " at offset " + entry_offset + " is too large.");
            return false;
        }
        if (entry_size < 16) {
            if (entry_offset + entry_size > chunk_size - 8) {
                Util.logError("No room for Res_value after ResTable_entry at offset " + entry_offset + " for type " + type.id + ".");
                return false;
            }
            ResourceTypes.Res_value value = new ResourceTypes.Res_value(entry.myBuf(), entry.myOffset() + 8);
            short value_size = Util.dtohs(value.size);
            if (value_size < 8) {
                Util.logError("Res_value at offset " + entry_offset + " is too small.");
                return false;
            }
            if (value_size > chunk_size || entry_offset + entry_size > chunk_size - value_size) {
                Util.logError("Res_value size " + value_size + " at offset " + entry_offset + " is too large.");
                return false;
            }
        } else {
            ResourceTypes.ResTable_map_entry map = new ResourceTypes.ResTable_map_entry(entry.myBuf(), entry.myOffset());
            int map_entry_count = Util.dtohl(map.count);
            int map_entries_start = entry_offset + entry_size;
            if (Util.isTruthy(map_entries_start & 3)) {
                Util.logError("Map entries at offset " + entry_offset + " start at unaligned offset.");
                return false;
            }
            if (map_entry_count > (chunk_size - map_entries_start) / 12) {
                Util.logError("Too many map entries in ResTable_map_entry at offset " + entry_offset + ".");
                return false;
            }
        }
        return true;
    }

    LoadedPackage GetPackageById(int package_id) {
        for (LoadedPackage loaded_package : this.packages_) {
            if (loaded_package.GetPackageId() != package_id) continue;
            return loaded_package;
        }
        return null;
    }

    boolean LoadTable(Chunk chunk, Idmap.LoadedIdmap loaded_idmap, boolean load_as_shared_library) {
        ResourceTypes.ResTable_header header = chunk.asResTable_header();
        if (header == null) {
            Util.logError("RES_TABLE_TYPE too small.");
            return false;
        }
        int package_count = Util.dtohl(header.packageCount);
        int packages_seen = 0;
        Chunk.Iterator iter = new Chunk.Iterator(chunk.data_ptr(), chunk.data_size());
        block4: while (iter.HasNext()) {
            Chunk child_chunk = iter.Next();
            switch (child_chunk.type()) {
                case 1: {
                    if (this.global_string_pool_.getError() == -2147483642) {
                        ResourceTypes.ResStringPool_header resStringPool_header = child_chunk.asResStringPool_header();
                        int err = this.global_string_pool_.setTo(resStringPool_header.myBuf(), resStringPool_header.myOffset(), child_chunk.size(), false);
                        if (err == 0) continue block4;
                        Util.logError("RES_STRING_POOL_TYPE corrupt.");
                        return false;
                    }
                    Util.logWarning("Multiple RES_STRING_POOL_TYPEs found in RES_TABLE_TYPE.");
                    break;
                }
                case 512: {
                    if (packages_seen + 1 > package_count) {
                        Util.logError("More package chunks were found than the " + package_count + " declared in the header.");
                        return false;
                    }
                    ++packages_seen;
                    LoadedPackage loaded_package = LoadedPackage.Load(child_chunk, loaded_idmap, this.system_, load_as_shared_library);
                    if (!Util.isTruthy(loaded_package)) {
                        return false;
                    }
                    this.packages_.add(loaded_package);
                    break;
                }
                default: {
                    Util.logWarning(String.format("Unknown chunk type '%02x'.", chunk.type()));
                }
            }
        }
        if (iter.HadError()) {
            Util.logError(iter.GetLastError());
            if (iter.HadFatalError()) {
                return false;
            }
        }
        return true;
    }

    static LoadedArsc Load(StringPiece data, Idmap.LoadedIdmap loaded_idmap, boolean system, boolean load_as_shared_library) {
        LoadedArsc loaded_arsc = new LoadedArsc();
        loaded_arsc.system_ = system;
        Chunk.Iterator iter = new Chunk.Iterator(data, data.size());
        block3: while (iter.HasNext()) {
            Chunk chunk = iter.Next();
            switch (chunk.type()) {
                case 2: {
                    if (loaded_arsc.LoadTable(chunk, loaded_idmap, load_as_shared_library)) continue block3;
                    return LoadedArsc.emptyBraces();
                }
            }
            Util.logWarning(String.format("Unknown chunk type '%02x'.", chunk.type()));
        }
        if (iter.HadError()) {
            Util.logError(iter.GetLastError());
            if (iter.HadFatalError()) {
                return LoadedArsc.emptyBraces();
            }
        }
        return loaded_arsc;
    }

    static LoadedArsc CreateEmpty() {
        return new LoadedArsc();
    }

    private static LoadedArsc emptyBraces() {
        return new LoadedArsc();
    }

    static class LoadedPackage {
        ResStringPool type_string_pool_ = new ResStringPool();
        ResStringPool key_string_pool_ = new ResStringPool();
        String package_name_;
        int package_id_ = -1;
        int type_id_offset_ = 0;
        boolean dynamic_ = false;
        boolean system_ = false;
        boolean overlay_ = false;
        final Map<Integer, TypeSpec> type_specs_ = new HashMap<Integer, TypeSpec>();
        final List<DynamicPackageEntry> dynamic_package_map_ = new ArrayList<DynamicPackageEntry>();

        LoadedPackage() {
        }

        ResourceTypes.ResTable_entry GetEntry(ResourceTypes.ResTable_type type_chunk, short entry_index) {
            int entry_offset = LoadedPackage.GetEntryOffset(type_chunk, entry_index);
            if (entry_offset == -1) {
                return null;
            }
            return LoadedPackage.GetEntryFromOffset(type_chunk, entry_offset);
        }

        static int GetEntryOffset(ResourceTypes.ResTable_type type_chunk, int entry_index) {
            int entry_count = Util.dtohl(type_chunk.entryCount);
            short offsets_offset = Util.dtohs(type_chunk.header.headerSize);
            if (Util.isTruthy(type_chunk.flags & 1)) {
                ResourceTypes.ResTable_sparseTypeEntry result = null;
                for (int i = 0; i < entry_count; ++i) {
                    ResourceTypes.ResTable_sparseTypeEntry entry = new ResourceTypes.ResTable_sparseTypeEntry(type_chunk.myBuf(), type_chunk.myOffset() + offsets_offset);
                    if (entry.idxOrOffset < entry_index) continue;
                    result = entry;
                    break;
                }
                if (result == null || Util.dtohs(result.idxOrOffset) != entry_index) {
                    return -1;
                }
                return Util.dtohs(result.idxOrOffset) * 4;
            }
            if (entry_index >= entry_count) {
                return -1;
            }
            return Util.dtohl(type_chunk.entryOffset(entry_index));
        }

        static ResourceTypes.ResTable_entry GetEntryFromOffset(ResourceTypes.ResTable_type type_chunk, int offset) {
            if (Util.UNLIKELY(!LoadedArsc.VerifyResTableEntry(type_chunk, offset))) {
                return null;
            }
            return new ResourceTypes.ResTable_entry(type_chunk.myBuf(), type_chunk.myOffset() + offset + Util.dtohl(type_chunk.entriesStart));
        }

        void CollectConfigurations(boolean exclude_mipmap, Set<ResTable_config> out_configs) {
            String kMipMap = "mipmap";
            int type_count = this.type_specs_.size();
            for (int i = 0; i < type_count; ++i) {
                String type_name;
                Ref<Integer> type_name_len;
                int type_idx;
                String type_name16;
                TypeSpec type_spec = this.type_specs_.get(i);
                if (type_spec != null && exclude_mipmap && ((type_name16 = this.type_string_pool_.stringAt(type_idx = type_spec.type_spec.id - 1, type_name_len = new Ref<Integer>(0))) != null && kMipMap.equals(type_name16) || (type_name = this.type_string_pool_.string8At(type_idx, type_name_len)) != null && "mipmap".equals(type_name))) continue;
                for (ResourceTypes.ResTable_type iter : type_spec.types) {
                    ResTable_config config = ResTable_config.fromDtoH(iter.config);
                    out_configs.add(config);
                }
            }
        }

        void CollectLocales(boolean canonicalize, Set<String> out_locales) {
            int type_count = this.type_specs_.size();
            for (int i = 0; i < type_count; ++i) {
                TypeSpec type_spec = this.type_specs_.get(i);
                if (type_spec == null) continue;
                for (ResourceTypes.ResTable_type iter : type_spec.types) {
                    String temp_locale;
                    ResTable_config configuration = ResTable_config.fromDtoH(iter.config);
                    if (configuration.locale() == 0) continue;
                    String locale = temp_locale = configuration.getBcp47Locale(canonicalize);
                    out_locales.add(locale);
                }
            }
        }

        int FindEntryByName(String type_name, String entry_name) {
            int type_idx = this.type_string_pool_.indexOfString(type_name);
            if (type_idx < 0) {
                return 0;
            }
            int key_idx = this.key_string_pool_.indexOfString(entry_name);
            if (key_idx < 0) {
                return 0;
            }
            TypeSpec type_spec = this.type_specs_.get(type_idx);
            if (type_spec == null) {
                return 0;
            }
            ResourceTypes.ResTable_type[] resTable_typeArray = type_spec.types;
            int n = resTable_typeArray.length;
            for (int i = 0; i < n; ++i) {
                ResourceTypes.ResTable_type iter;
                ResourceTypes.ResTable_type type = iter = resTable_typeArray[i];
                int entry_count = type.entryCount;
                for (int entry_idx = 0; entry_idx < entry_count; ++entry_idx) {
                    int offset = Util.dtohl(type.entryOffset(entry_idx));
                    if (offset == -1) continue;
                    ResourceTypes.ResTable_entry entry = new ResourceTypes.ResTable_entry(type.myBuf(), type.myOffset() + Util.dtohl(type.entriesStart) + offset);
                    if (Util.dtohl(entry.key.index) != key_idx) continue;
                    return ResourceUtils.make_resid((byte)0, (byte)(type_idx + this.type_id_offset_ + 1), (short)entry_idx);
                }
            }
            return 0;
        }

        static LoadedPackage Load(Chunk chunk, Idmap.LoadedIdmap loaded_idmap, boolean system, boolean load_as_shared_library) {
            LoadedPackage loaded_package = new LoadedPackage();
            int kMinPackageSize = ResourceTypes.ResTable_package.SIZEOF - 4;
            ResourceTypes.ResTable_package header = chunk.asResTable_package(kMinPackageSize);
            if (header == null) {
                Util.logError("RES_TABLE_PACKAGE_TYPE too small.");
                return LoadedPackage.emptyBraces();
            }
            loaded_package.system_ = system;
            loaded_package.package_id_ = Util.dtohl(header.id);
            if (loaded_package.package_id_ == 0 || loaded_package.package_id_ == 127 && load_as_shared_library) {
                loaded_package.dynamic_ = true;
            }
            if (loaded_idmap != null) {
                loaded_package.package_id_ = loaded_idmap.TargetPackageId();
                loaded_package.overlay_ = true;
            }
            if (header.header.headerSize >= ResourceTypes.ResTable_package.SIZEOF) {
                int type_id_offset = Util.dtohl(header.typeIdOffset);
                if (type_id_offset > 255) {
                    Util.logError("RES_TABLE_PACKAGE_TYPE type ID offset too large.");
                    return LoadedPackage.emptyBraces();
                }
                loaded_package.type_id_offset_ = type_id_offset;
            }
            loaded_package.package_name_ = Util.ReadUtf16StringFromDevice(header.name, header.name.length);
            HashMap<Integer, TypeSpecPtrBuilder> type_builder_map = new HashMap<Integer, TypeSpecPtrBuilder>();
            Chunk.Iterator iter = new Chunk.Iterator(chunk.data_ptr(), chunk.data_size());
            block6: while (iter.HasNext()) {
                Chunk child_chunk = iter.Next();
                switch (child_chunk.type()) {
                    case 1: {
                        int pool_address = child_chunk.myOffset();
                        int header_address = header.myOffset();
                        if (pool_address == header_address + Util.dtohl(header.typeStrings)) {
                            int err = loaded_package.type_string_pool_.setTo(child_chunk.myBuf(), child_chunk.myOffset(), child_chunk.size(), false);
                            if (err == 0) continue block6;
                            Util.logError("RES_STRING_POOL_TYPE for types corrupt.");
                            return LoadedPackage.emptyBraces();
                        }
                        if (pool_address == header_address + Util.dtohl(header.keyStrings)) {
                            int err = loaded_package.key_string_pool_.setTo(child_chunk.myBuf(), child_chunk.myOffset(), child_chunk.size(), false);
                            if (err == 0) continue block6;
                            Util.logError("RES_STRING_POOL_TYPE for keys corrupt.");
                            return LoadedPackage.emptyBraces();
                        }
                        Util.logWarning("Too many RES_STRING_POOL_TYPEs found in RES_TABLE_PACKAGE_TYPE.");
                        break;
                    }
                    case 514: {
                        TypeSpecPtrBuilder builder_ptr;
                        ResourceTypes.ResTable_typeSpec type_spec = new ResourceTypes.ResTable_typeSpec(child_chunk.myBuf(), child_chunk.myOffset());
                        if (type_spec == null) {
                            Util.logError("RES_TABLE_TYPE_SPEC_TYPE too small.");
                            return LoadedPackage.emptyBraces();
                        }
                        if (type_spec.id == 0) {
                            Util.logError("RES_TABLE_TYPE_SPEC_TYPE has invalid ID 0.");
                            return LoadedPackage.emptyBraces();
                        }
                        if (loaded_package.type_id_offset_ + type_spec.id > 255) {
                            Util.logError("RES_TABLE_TYPE_SPEC_TYPE has out of range ID.");
                            return LoadedPackage.emptyBraces();
                        }
                        int entry_count = Util.dtohl(type_spec.entryCount);
                        if (entry_count > 65535) {
                            Util.logError("RES_TABLE_TYPE_SPEC_TYPE has too many entries (" + entry_count + ").");
                            return LoadedPackage.emptyBraces();
                        }
                        if (entry_count * 4 > chunk.data_size()) {
                            Util.logError("RES_TABLE_TYPE_SPEC_TYPE too small to hold entries.");
                            return LoadedPackage.emptyBraces();
                        }
                        ResourceTypes.IdmapEntry_header idmap_entry_header = null;
                        if (loaded_idmap != null) {
                            idmap_entry_header = loaded_idmap.GetEntryMapForType(type_spec.id);
                        }
                        if ((builder_ptr = (TypeSpecPtrBuilder)type_builder_map.get(type_spec.id - 1)) == null) {
                            builder_ptr = new TypeSpecPtrBuilder(type_spec, idmap_entry_header);
                            type_builder_map.put(type_spec.id - 1, builder_ptr);
                            break;
                        }
                        Util.logWarning(String.format("RES_TABLE_TYPE_SPEC_TYPE already defined for ID %02x", type_spec.id));
                        break;
                    }
                    case 513: {
                        ResourceTypes.ResTable_type type = child_chunk.asResTable_type(ResourceTypes.kResTableTypeMinSize);
                        if (type == null) {
                            Util.logError("RES_TABLE_TYPE_TYPE too small.");
                            return LoadedPackage.emptyBraces();
                        }
                        if (!LoadedArsc.VerifyResTableType(type)) {
                            return LoadedPackage.emptyBraces();
                        }
                        TypeSpecPtrBuilder builder_ptr = (TypeSpecPtrBuilder)type_builder_map.get(type.id - 1);
                        if (builder_ptr != null) {
                            builder_ptr.AddType(type);
                            break;
                        }
                        Util.logError(String.format("RES_TABLE_TYPE_TYPE with ID %02x found without preceding RES_TABLE_TYPE_SPEC_TYPE.", type.id));
                        return LoadedPackage.emptyBraces();
                    }
                    case 515: {
                        ResourceTypes.ResTable_lib_entry entry_begin;
                        ResourceTypes.ResTable_lib_header lib = child_chunk.asResTable_lib_header();
                        if (lib == null) {
                            Util.logError("RES_TABLE_LIBRARY_TYPE too small.");
                            return LoadedPackage.emptyBraces();
                        }
                        if (child_chunk.data_size() / 260 < Util.dtohl(lib.count)) {
                            Util.logError("RES_TABLE_LIBRARY_TYPE too small to hold entries.");
                            return LoadedPackage.emptyBraces();
                        }
                        ResourceTypes.ResTable_lib_entry entry_iter = entry_begin = child_chunk.asResTable_lib_entry();
                        while (entry_iter.myOffset() != entry_begin.myOffset() + Util.dtohl(lib.count)) {
                            String package_name = Util.ReadUtf16StringFromDevice(entry_iter.packageName, entry_iter.packageName.length);
                            if (Util.dtohl(entry_iter.packageId) >= 255) {
                                Util.logError(String.format("Package ID %02x in RES_TABLE_LIBRARY_TYPE too large for package '%s'.", Util.dtohl(entry_iter.packageId), package_name));
                                return LoadedPackage.emptyBraces();
                            }
                            loaded_package.dynamic_package_map_.add(new DynamicPackageEntry(package_name, Util.dtohl(entry_iter.packageId)));
                            entry_iter = new ResourceTypes.ResTable_lib_entry(entry_iter.myBuf(), entry_iter.myOffset() + 260);
                        }
                        continue block6;
                    }
                    default: {
                        Util.logWarning(String.format("Unknown chunk type '%02x'.", chunk.type()));
                    }
                }
            }
            if (iter.HadError()) {
                Util.logError(iter.GetLastError());
                if (iter.HadFatalError()) {
                    return LoadedPackage.emptyBraces();
                }
            }
            for (Map.Entry entry : type_builder_map.entrySet()) {
                byte type_idx = ((Integer)entry.getKey()).byteValue();
                TypeSpec type_spec_ptr = ((TypeSpecPtrBuilder)entry.getValue()).Build();
                if (type_spec_ptr == null) {
                    Util.logError("Too many type configurations, overflow detected.");
                    return LoadedPackage.emptyBraces();
                }
                if (loaded_idmap != null && type_spec_ptr.idmap_entries == null) continue;
                if (type_spec_ptr.idmap_entries != null) {
                    type_idx = (byte)(Util.dtohs(type_spec_ptr.idmap_entries.target_type_id) - 1);
                }
                loaded_package.type_specs_.put(Integer.valueOf(type_idx), type_spec_ptr);
            }
            return loaded_package;
        }

        ResStringPool GetTypeStringPool() {
            return this.type_string_pool_;
        }

        ResStringPool GetKeyStringPool() {
            return this.key_string_pool_;
        }

        String GetPackageName() {
            return this.package_name_;
        }

        int GetPackageId() {
            return this.package_id_;
        }

        boolean IsDynamic() {
            return this.dynamic_;
        }

        boolean IsSystem() {
            return this.system_;
        }

        boolean IsOverlay() {
            return this.overlay_;
        }

        List<DynamicPackageEntry> GetDynamicPackageMap() {
            return this.dynamic_package_map_;
        }

        TypeSpec GetTypeSpecByTypeIndex(int type_index) {
            return this.type_specs_.get(type_index - this.type_id_offset_);
        }

        void ForEachTypeSpec(TypeSpecFunc f) {
            for (Integer i : this.type_specs_.keySet()) {
                TypeSpec ptr = this.type_specs_.get(i);
                if (ptr == null) continue;
                byte type_id = ptr.type_spec.id;
                if (ptr.idmap_entries != null) {
                    type_id = (byte)ptr.idmap_entries.target_type_id;
                }
                f.apply(ptr, (byte)(type_id - 1));
            }
        }

        private static LoadedPackage emptyBraces() {
            return new LoadedPackage();
        }

        static interface TypeSpecFunc {
            public void apply(TypeSpec var1, byte var2);
        }
    }

    static class TypeSpecPtrBuilder {
        ResourceTypes.ResTable_typeSpec header_;
        ResourceTypes.IdmapEntry_header idmap_header_;
        final List<ResourceTypes.ResTable_type> types_ = new ArrayList<ResourceTypes.ResTable_type>();

        TypeSpecPtrBuilder(ResourceTypes.ResTable_typeSpec header, ResourceTypes.IdmapEntry_header idmap_header) {
            this.header_ = header;
            this.idmap_header_ = idmap_header;
        }

        void AddType(ResourceTypes.ResTable_type type) {
            this.types_.add(type);
        }

        TypeSpec Build() {
            if ((Integer.MAX_VALUE - TypeSpec.SIZEOF) / 4 < this.types_.size()) {
                return null;
            }
            TypeSpec type_spec = new TypeSpec();
            type_spec.types = new ResourceTypes.ResTable_type[this.types_.size()];
            type_spec.type_spec = this.header_;
            type_spec.idmap_entries = this.idmap_header_;
            type_spec.type_count = this.types_.size();
            for (int i = 0; i < type_spec.types.length; ++i) {
                type_spec.types[i] = this.types_.get(i);
            }
            return type_spec;
        }
    }

    static class TypeSpec {
        public static final int SIZEOF = ResourceTypes.ResTable_typeSpec.SIZEOF + 8;
        ResourceTypes.ResTable_typeSpec type_spec;
        ResourceTypes.IdmapEntry_header idmap_entries;
        int type_count;
        ResourceTypes.ResTable_type[] types;

        TypeSpec() {
        }

        int GetFlagsForEntryIndex(int entry_index) {
            if (entry_index >= Util.dtohl(this.type_spec.entryCount)) {
                return 0;
            }
            int[] flags = this.type_spec.getSpecFlags();
            return flags[entry_index];
        }
    }

    static class DynamicPackageEntry {
        String package_name;
        int package_id = 0;

        DynamicPackageEntry(String package_name, int package_id) {
            this.package_name = package_name;
            this.package_id = package_id;
        }
    }
}

