/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.manifest;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.manifest.RoboNotFoundException;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;
import org.robolectric.res.android.ResTable_config;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class MetaData {
    private final Map<String, Object> valueMap = new LinkedHashMap<String, Object>();
    private final Map<String, VALUE_TYPE> typeMap = new LinkedHashMap<String, VALUE_TYPE>();
    private boolean initialised;

    public MetaData(List<Node> nodes) {
        for (Node metaNode : nodes) {
            NamedNodeMap attributes = metaNode.getAttributes();
            Node nameAttr = attributes.getNamedItem("android:name");
            Node valueAttr = attributes.getNamedItem("android:value");
            Node resourceAttr = attributes.getNamedItem("android:resource");
            if (valueAttr != null) {
                this.valueMap.put(nameAttr.getNodeValue(), valueAttr.getNodeValue());
                this.typeMap.put(nameAttr.getNodeValue(), VALUE_TYPE.VALUE);
                continue;
            }
            if (resourceAttr == null) continue;
            this.valueMap.put(nameAttr.getNodeValue(), resourceAttr.getNodeValue());
            this.typeMap.put(nameAttr.getNodeValue(), VALUE_TYPE.RESOURCE);
        }
    }

    public void init(ResourceTable resourceTable, String packageName) throws RoboNotFoundException {
        if (!this.initialised) {
            for (Map.Entry<String, VALUE_TYPE> entry : this.typeMap.entrySet()) {
                String value = this.valueMap.get(entry.getKey()).toString();
                if (value.startsWith("@")) {
                    ResName resName = ResName.qualifyResName(value.substring(1), packageName, null);
                    block0 : switch (entry.getValue()) {
                        case RESOURCE: {
                            this.valueMap.put(entry.getKey(), resourceTable.getResourceId(resName));
                            break;
                        }
                        case VALUE: {
                            TypedResource typedRes = resourceTable.getValue(resName, new ResTable_config());
                            if (typedRes == null) {
                                throw new RoboNotFoundException(resName.getFullyQualifiedName());
                            }
                            switch (typedRes.getResType()) {
                                case BOOLEAN: 
                                case COLOR: 
                                case INTEGER: 
                                case FLOAT: {
                                    this.valueMap.put(entry.getKey(), this.parseValue(typedRes.getData().toString()));
                                    break block0;
                                }
                            }
                            this.valueMap.put(entry.getKey(), typedRes.getData());
                        }
                    }
                    continue;
                }
                if (entry.getValue() != VALUE_TYPE.VALUE) continue;
                this.valueMap.put(entry.getKey(), this.parseValue(value));
            }
            this.initialised = true;
        }
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    private Object parseValue(String value) {
        if (value == null) {
            return null;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        if (value.startsWith("#")) {
            try {
                return MetaData.getColor(value);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value.contains(".")) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static int getColor(String value) {
        if (value != null) {
            if (!value.startsWith("#")) {
                throw new NumberFormatException(String.format("Color value '%s' must start with #", value));
            }
            if ((value = value.substring(1)).length() > 8) {
                throw new NumberFormatException(String.format("Color value '%s' is too long. Format is either#AARRGGBB, #RRGGBB, #RGB, or #ARGB", value));
            }
            if (value.length() == 3) {
                char[] color = new char[8];
                color[1] = 70;
                color[0] = 70;
                color[2] = color[3] = value.charAt(0);
                color[4] = color[5] = value.charAt(1);
                color[6] = color[7] = value.charAt(2);
                value = new String(color);
            } else if (value.length() == 4) {
                char[] color = new char[8];
                color[0] = color[1] = value.charAt(0);
                color[2] = color[3] = value.charAt(1);
                color[4] = color[5] = value.charAt(2);
                color[6] = color[7] = value.charAt(3);
                value = new String(color);
            } else if (value.length() == 6) {
                value = "FF" + value;
            }
            return (int)Long.parseLong(value, 16);
        }
        throw new NumberFormatException();
    }

    private static enum VALUE_TYPE {
        RESOURCE,
        VALUE;

    }
}

