/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.ByteBucketArray;
import org.robolectric.res.android.DataType;
import org.robolectric.res.android.DynamicRefTable;
import org.robolectric.res.android.IdmapEntries;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResStringPool;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.StringPoolRef;
import org.robolectric.res.android.Util;

public class ResTable {
    private static final int IDMAP_MAGIC = 1347241033;
    private static final int IDMAP_CURRENT_VERSION = 1;
    static final int APP_PACKAGE_ID = 127;
    static final int SYS_PACKAGE_ID = 1;
    static final boolean kDebugStringPoolNoisy = false;
    static final boolean kDebugXMLNoisy = false;
    static final boolean kDebugTableNoisy = false;
    static final boolean kDebugTableGetEntry = false;
    static final boolean kDebugTableSuperNoisy = false;
    static final boolean kDebugLoadTableNoisy = false;
    static final boolean kDebugLoadTableSuperNoisy = false;
    static final boolean kDebugTableTheme = false;
    static final boolean kDebugResXMLTree = false;
    static final boolean kDebugLibNoisy = false;
    private static final Object NULL = null;
    public static final bag_set SENTINEL_BAG_SET = new bag_set(1);
    final Semaphore mLock = new Semaphore(1);
    final Object mFilteredConfigLock = new Object();
    int mError;
    ResTable_config mParams;
    final List<Header> mHeaders = new ArrayList<Header>();
    final Map<Integer, PackageGroup> mPackageGroups = new HashMap<Integer, PackageGroup>();
    final byte[] mPackageMap = new byte[256];
    byte mNextPackageId;
    private static final Map<String, Integer> sInternalNameToIdMap = new HashMap<String, Integer>();

    static boolean Res_CHECKID(int resid) {
        return (resid & 0xFFFF0000) != 0;
    }

    static int Res_GETPACKAGE(int id) {
        return (id >> 24) - 1;
    }

    public static int Res_GETTYPE(int id) {
        return (id >> 16 & 0xFF) - 1;
    }

    static int Res_GETENTRY(int id) {
        return id & 0xFFFF;
    }

    static int Res_MAKEARRAY(int entry) {
        return 0x2000000 | entry & 0xFFFF;
    }

    static boolean Res_INTERNALID(int resid) {
        return (resid & 0xFFFF0000) != 0 && (resid & 0xFF0000) == 0;
    }

    int getResourcePackageIndex(int resID) {
        return ResTable.Res_GETPACKAGE(resID) + 1;
    }

    int getResourcePackageIndexFromPackage(byte packageID) {
        return this.mPackageMap[packageID] - 1;
    }

    int add(Asset asset, Asset idmapAsset, int cookie, boolean copyData, boolean appAsLib, boolean isSystemAsset) {
        byte[] data = asset.getBuffer(true);
        if (data == NULL) {
            Util.ALOGW("Unable to get buffer of resource asset file", new Object[0]);
            return Integer.MIN_VALUE;
        }
        int idmapSize = 0;
        Object idmapData = NULL;
        if (idmapAsset != NULL) {
            idmapData = idmapAsset.getBuffer(true);
            if (idmapData == NULL) {
                Util.ALOGW("Unable to get buffer of idmap asset file", new Object[0]);
                return Integer.MIN_VALUE;
            }
            idmapSize = (int)idmapAsset.getLength();
        }
        return this.addInternal(data, (int)asset.getLength(), idmapData, idmapSize, appAsLib, cookie, copyData, isSystemAsset);
    }

    int add(ResTable src, boolean isSystemAsset) {
        this.mError = src.mError;
        for (int i = 0; i < src.mHeaders.size(); ++i) {
            this.mHeaders.add(src.mHeaders.get(i));
        }
        for (PackageGroup srcPg : src.mPackageGroups.values()) {
            PackageGroup pg = new PackageGroup(this, srcPg.name, srcPg.id, false, isSystemAsset || srcPg.isSystemAsset, srcPg.isDynamic);
            for (int j = 0; j < srcPg.packages.size(); ++j) {
                pg.packages.add(srcPg.packages.get(j));
            }
            for (Integer typeId : srcPg.types.keySet()) {
                List typeList = ResTable.computeIfAbsent(pg.types, typeId, key -> new ArrayList());
                typeList.addAll((Collection)srcPg.types.get(typeId));
            }
            pg.dynamicRefTable.addMappings(srcPg.dynamicRefTable);
            pg.largestTypeId = UnsignedBytes.max((byte[])new byte[]{pg.largestTypeId, srcPg.largestTypeId});
            this.mPackageGroups.put(pg.id, pg);
        }
        System.arraycopy(src.mPackageMap, 0, this.mPackageMap, 0, this.mPackageMap.length);
        return this.mError;
    }

    int addEmpty(int cookie) {
        ResourceTypes.ResTable_header resHeader;
        Header header = new Header(this);
        header.index = this.mHeaders.size();
        header.cookie = cookie;
        header.values.setToEmpty();
        header.ownedData = new byte[ResourceTypes.ResTable_header.SIZEOF];
        ByteBuffer buf = ByteBuffer.wrap(header.ownedData).order(ByteOrder.LITTLE_ENDIAN);
        ResourceTypes.ResChunk_header.write(buf, (short)2, () -> {}, () -> {});
        header.header = resHeader = new ResourceTypes.ResTable_header(buf, 0);
        this.mHeaders.add(header);
        this.mError = 0;
        return 0;
    }

    int addInternal(byte[] data, int dataSize, Object idmapData, int idmapDataSize, boolean appAsLib, int cookie, boolean copyData, boolean isSystemAsset) {
        boolean notDeviceEndian;
        if (!Util.isTruthy(data)) {
            return 0;
        }
        if (dataSize < ResourceTypes.ResTable_header.SIZEOF) {
            Util.ALOGE("Invalid data. Size(%d) is smaller than a ResTable_header(%d).", dataSize, ResourceTypes.ResTable_header.SIZEOF);
            return Integer.MIN_VALUE;
        }
        Header header = new Header(this);
        header.index = this.mHeaders.size();
        header.cookie = cookie;
        if (idmapData != NULL) {
            header.resourceIDMap = new int[idmapDataSize / 4];
            if (header.resourceIDMap == NULL) {
                this.mError = -2147483644;
                return -2147483644;
            }
        }
        this.mHeaders.add(header);
        boolean bl = notDeviceEndian = Util.htods((short)240) != 240;
        if (copyData || notDeviceEndian) {
            header.ownedData = data;
            if (header.ownedData == NULL) {
                this.mError = -2147483644;
                return -2147483644;
            }
            data = header.ownedData;
        }
        ByteBuffer buf = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        header.header = new ResourceTypes.ResTable_header(buf, 0);
        header.size = Util.dtohl(header.header.header.size);
        if (Util.dtohs(header.header.header.headerSize) > header.size || header.size > dataSize) {
            Util.ALOGW("Bad resource table: header size 0x%x or total size 0x%x is larger than data size 0x%x\n", Util.dtohs(header.header.header.headerSize), header.size, dataSize);
            this.mError = -2147483646;
            return -2147483646;
        }
        if (((Util.dtohs(header.header.header.headerSize) | header.size) & 3) != 0) {
            Util.ALOGW("Bad resource table: header size 0x%x or total size 0x%x is not on an integer boundary\n", Util.dtohs(header.header.header.headerSize), header.size);
            this.mError = -2147483646;
            return -2147483646;
        }
        header.dataEnd = header.size;
        int curPackage = 0;
        ResourceTypes.ResChunk_header chunk = new ResourceTypes.ResChunk_header(buf, Util.dtohs(header.header.header.headerSize));
        while (chunk != null && chunk.myOffset() <= header.dataEnd - ResourceTypes.ResChunk_header.SIZEOF && chunk.myOffset() <= header.dataEnd - Util.dtohl(chunk.size)) {
            int err = ResourceTypes.validate_chunk(chunk, ResourceTypes.ResChunk_header.SIZEOF, header.dataEnd, "ResTable");
            if (err != 0) {
                this.mError = err;
                return this.mError;
            }
            int csize = Util.dtohl(chunk.size);
            short ctype = Util.dtohs(chunk.type);
            if (ctype == 1) {
                if (header.values.getError() != 0) {
                    err = header.values.setTo(chunk.myBuf(), chunk.myOffset(), csize, false);
                    if (err != 0) {
                        this.mError = err;
                        return this.mError;
                    }
                } else {
                    Util.ALOGW("Multiple string chunks found in resource table.", new Object[0]);
                }
            } else if (ctype == 512) {
                if (curPackage >= Util.dtohl(header.header.packageCount)) {
                    Util.ALOGW("More package chunks were found than the %d declared in the header.", Util.dtohl(header.header.packageCount));
                    this.mError = -2147483646;
                    return -2147483646;
                }
                if (this.parsePackage(new ResourceTypes.ResTable_package(chunk.myBuf(), chunk.myOffset()), header, appAsLib, isSystemAsset) != 0) {
                    return this.mError;
                }
                ++curPackage;
            } else {
                Util.ALOGW("Unknown chunk type 0x%x in table at 0x%x.\n", ctype, chunk.myOffset() - header.header.myOffset());
            }
            chunk = chunk.myOffset() + csize < header.dataEnd ? new ResourceTypes.ResChunk_header(chunk.myBuf(), chunk.myOffset() + csize) : null;
        }
        if (curPackage < Util.dtohl(header.header.packageCount)) {
            Util.ALOGW("Fewer package chunks (%d) were found than the %d declared in the header.", curPackage, Util.dtohl(header.header.packageCount));
            this.mError = -2147483646;
            return -2147483646;
        }
        this.mError = header.values.getError();
        if (this.mError != 0) {
            Util.ALOGW("No string values found in resource table!", new Object[0]);
        }
        return this.mError;
    }

    public final int getResource(int resID, Ref<ResourceTypes.Res_value> outValue, boolean mayBeBag, int density, Ref<Integer> outSpecFlags, Ref<ResTable_config> outConfig) {
        Entry entry;
        int err;
        if (this.mError != 0) {
            return this.mError;
        }
        int p = this.getResourcePackageIndex(resID);
        int t = ResTable.Res_GETTYPE(resID);
        int e = ResTable.Res_GETENTRY(resID);
        if (p < 0) {
            if (ResTable.Res_GETPACKAGE(resID) + 1 == 0) {
                Util.ALOGW("No package identifier when getting value for resource number 0x%08x", resID);
            } else {
                Util.ALOGW("No known package when getting value for resource number 0x%08x", resID);
            }
            return -2147483647;
        }
        if (t < 0) {
            Util.ALOGW("No type identifier when getting value for resource number 0x%08x", resID);
            return -2147483647;
        }
        PackageGroup grp = this.mPackageGroups.get(p);
        if (grp == NULL) {
            Util.ALOGW("Bad identifier when getting value for resource number 0x%08x", resID);
            return -2147483647;
        }
        ResTable_config desiredConfig = this.mParams;
        if (density > 0) {
            desiredConfig.density = density;
        }
        if ((err = this.getEntry(grp, t, e, desiredConfig, entry = new Entry())) != 0) {
            return err;
        }
        if ((entry.entry.flags & 1) != 0) {
            if (!mayBeBag) {
                Util.ALOGW("Requesting resource 0x%08x failed because it is complex\n", resID);
            }
            return -2147483645;
        }
        ResourceTypes.Res_value value = new ResourceTypes.Res_value(entry.entry.myBuf(), entry.entry.myOffset() + entry.entry.size);
        outValue.set(value);
        if (grp.dynamicRefTable.lookupResourceValue(outValue) != 0) {
            Util.ALOGW("Failed to resolve referenced package: 0x%08x", outValue.get().data);
            return -2147483645;
        }
        if (outSpecFlags != null) {
            outSpecFlags.set(entry.specFlags);
        }
        if (outConfig != null) {
            outConfig.set(entry.config);
        }
        return entry._package_.header.index;
    }

    public final int resolveReference(Ref<ResourceTypes.Res_value> value, int blockIndex, Ref<Integer> outLastRef) {
        return this.resolveReference(value, blockIndex, outLastRef, null, null);
    }

    public final int resolveReference(Ref<ResourceTypes.Res_value> value, int blockIndex, Ref<Integer> outLastRef, Ref<Integer> inoutTypeSpecFlags) {
        return this.resolveReference(value, blockIndex, outLastRef, inoutTypeSpecFlags, null);
    }

    public final int resolveReference(Ref<ResourceTypes.Res_value> value, int blockIndex, Ref<Integer> outLastRef, Ref<Integer> inoutTypeSpecFlags, Ref<ResTable_config> outConfig) {
        for (int count = 0; blockIndex >= 0 && value.get().dataType == DataType.REFERENCE.code() && value.get().data != 0 && count < 20; ++count) {
            Ref<Integer> newFlags;
            int newIndex;
            if (outLastRef != null) {
                outLastRef.set(value.get().data);
            }
            if ((newIndex = this.getResource(value.get().data, value, true, 0, newFlags = new Ref<Integer>(0), outConfig)) == -2147483647) {
                return -2147483647;
            }
            if (inoutTypeSpecFlags != null) {
                inoutTypeSpecFlags.set(inoutTypeSpecFlags.get() | newFlags.get());
            }
            if (newIndex < 0) {
                return blockIndex;
            }
            blockIndex = newIndex;
        }
        return blockIndex;
    }

    ResourceTypes.ResTable_sparseTypeEntry lower_bound(ResourceTypes.ResTable_sparseTypeEntry first, ResourceTypes.ResTable_sparseTypeEntry last, ResourceTypes.ResTable_sparseTypeEntry value, Compare comparator) {
        int count = (last.myOffset() - first.myOffset()) / 4;
        while (count > 0) {
            int itOffset = first.myOffset();
            int step = count / 2;
            if (comparator.compare(new ResourceTypes.ResTable_sparseTypeEntry(first.myBuf(), itOffset += step * 4), value)) {
                first = new ResourceTypes.ResTable_sparseTypeEntry(first.myBuf(), itOffset += 4);
                continue;
            }
            count = step;
        }
        return first;
    }

    private int getEntry(PackageGroup packageGroup, int typeIndex, int entryIndex, ResTable_config config, Entry outEntry) {
        List typeList = ResTable.getOrDefault(packageGroup.types, typeIndex, Collections.emptyList());
        if (typeList.isEmpty()) {
            Util.ALOGV("Skipping entry type index 0x%02x because type is NULL!\n", typeIndex);
            return -2147483646;
        }
        ResourceTypes.WithOffset bestType = null;
        int bestOffset = -1;
        ResTablePackage bestPackage = null;
        int specFlags = 0;
        byte actualTypeIndex = (byte)typeIndex;
        ResTable_config bestConfig = null;
        int typeCount = typeList.size();
        block0: for (int i = 0; i < typeCount; ++i) {
            Type typeSpec = (Type)typeList.get(i);
            int realEntryIndex = entryIndex;
            int realTypeIndex = typeIndex;
            boolean currentTypeIsOverlay = false;
            if (typeSpec.idmapEntries.hasEntries()) {
                Ref<Short> overlayEntryIndex = new Ref<Short>((short)0);
                if (typeSpec.idmapEntries.lookup(entryIndex, overlayEntryIndex) != 0) continue;
                realEntryIndex = overlayEntryIndex.get().shortValue();
                realTypeIndex = typeSpec.idmapEntries.overlayTypeId() - 1;
                currentTypeIsOverlay = true;
            }
            if (realEntryIndex >= typeSpec.entryCount) {
                Util.ALOGW("For resource 0x%08x, entry index(%d) is beyond type entryCount(%d)", this.Res_MAKEID(packageGroup.id - 1, typeIndex, entryIndex), entryIndex, typeSpec.entryCount);
                continue;
            }
            specFlags = typeSpec.typeSpecFlags != null ? (specFlags |= Util.dtohl(typeSpec.typeSpecFlags[realEntryIndex])) : -1;
            List<ResourceTypes.ResTable_type> candidateConfigs = typeSpec.configs;
            int numConfigs = candidateConfigs.size();
            for (int c = 0; c < numConfigs; ++c) {
                int thisOffset;
                ResourceTypes.ResTable_type thisType = candidateConfigs.get(c);
                if (thisType == NULL) continue;
                ResTable_config thisConfig = ResTable_config.fromDtoH(thisType.config);
                if (config != NULL && !thisConfig.match(config)) continue;
                int eindex = thisType.myOffset() + Util.dtohs(thisType.header.headerSize);
                if (Util.isTruthy(thisType.flags & 1)) {
                    ByteBuffer buf = thisType.myBuf();
                    ResourceTypes.ResTable_sparseTypeEntry sparseIndices = new ResourceTypes.ResTable_sparseTypeEntry(buf, eindex);
                    ResourceTypes.ResTable_sparseTypeEntry result = this.lower_bound(sparseIndices, new ResourceTypes.ResTable_sparseTypeEntry(buf, sparseIndices.myOffset() + Util.dtohl(thisType.entryCount)), new ResourceTypes.ResTable_sparseTypeEntry(buf, realEntryIndex), (a, b) -> Util.dtohs(a.idx) < Util.dtohs(b.idx));
                    if (result.myOffset() == sparseIndices.myOffset() + Util.dtohl(thisType.entryCount) || Util.dtohs(result.idx) != realEntryIndex) continue;
                    thisOffset = Util.dtohs(result.offset) * 4;
                } else {
                    if (realEntryIndex >= Util.dtohl(thisType.entryCount)) continue;
                    thisOffset = thisType.entryOffset(realEntryIndex);
                }
                if (thisOffset == -1 || bestType != NULL && !thisConfig.isBetterThan(bestConfig, config) && (!currentTypeIsOverlay || thisConfig.compare(bestConfig) != 0)) continue;
                bestType = thisType;
                bestOffset = thisOffset;
                bestConfig = thisConfig;
                bestPackage = typeSpec._package_;
                actualTypeIndex = (byte)realTypeIndex;
                if (config == NULL) continue block0;
            }
        }
        if (bestType == NULL) {
            return -2147483647;
        }
        if ((bestOffset += Util.dtohl(((ResourceTypes.ResTable_type)bestType).entriesStart)) > Util.dtohl(((ResourceTypes.ResTable_type)bestType).header.size) - 8) {
            Util.ALOGW("ResTable_entry at 0x%x is beyond type chunk data 0x%x", bestOffset, Util.dtohl(((ResourceTypes.ResTable_type)bestType).header.size));
            return -2147483646;
        }
        if ((bestOffset & 3) != 0) {
            Util.ALOGW("ResTable_entry at 0x%x is not on an integer boundary", bestOffset);
            return -2147483646;
        }
        ResourceTypes.ResTable_entry entry = new ResourceTypes.ResTable_entry(bestType.myBuf(), bestType.myOffset() + bestOffset);
        if (Util.dtohs(entry.size) < 8) {
            Util.ALOGW("ResTable_entry size 0x%x is too small", Util.dtohs(entry.size));
            return -2147483646;
        }
        if (outEntry != null) {
            outEntry.entry = entry;
            outEntry.config = bestConfig;
            outEntry.type = bestType;
            outEntry.specFlags = specFlags;
            outEntry._package_ = bestPackage;
            outEntry.typeStr = new StringPoolRef(bestPackage.typeStrings, actualTypeIndex - bestPackage.typeIdOffset);
            outEntry.keyStr = new StringPoolRef(bestPackage.keyStrings, Util.dtohl(entry.key.index));
        }
        return 0;
    }

    int parsePackage(ResourceTypes.ResTable_package pkg, Header header, boolean appAsLib, boolean isSystemAsset) {
        int base = pkg.myOffset();
        int err = ResourceTypes.validate_chunk(pkg.header, ResourceTypes.ResTable_package.SIZEOF - 4, header.dataEnd, "ResTable_package");
        if (err != 0) {
            this.mError = err;
            return this.mError;
        }
        int pkgSize = Util.dtohl(pkg.header.size);
        if (Util.dtohl(pkg.typeStrings) >= pkgSize) {
            Util.ALOGW("ResTable_package type strings at 0x%x are past chunk size 0x%x.", Util.dtohl(pkg.typeStrings), pkgSize);
            this.mError = -2147483646;
            return -2147483646;
        }
        if ((Util.dtohl(pkg.typeStrings) & 3) != 0) {
            Util.ALOGW("ResTable_package type strings at 0x%x is not on an integer boundary.", Util.dtohl(pkg.typeStrings));
            this.mError = -2147483646;
            return -2147483646;
        }
        if (Util.dtohl(pkg.keyStrings) >= pkgSize) {
            Util.ALOGW("ResTable_package key strings at 0x%x are past chunk size 0x%x.", Util.dtohl(pkg.keyStrings), pkgSize);
            this.mError = -2147483646;
            return -2147483646;
        }
        if ((Util.dtohl(pkg.keyStrings) & 3) != 0) {
            Util.ALOGW("ResTable_package key strings at 0x%x is not on an integer boundary.", Util.dtohl(pkg.keyStrings));
            this.mError = -2147483646;
            return -2147483646;
        }
        int id = Util.dtohl(pkg.id);
        HashMap idmapEntries = new HashMap();
        if (header.resourceIDMap != NULL) {
            // empty if block
        }
        boolean isDynamic = false;
        if (id >= 256) {
            throw new IllegalStateException("Package id out of range");
        }
        if (id == 0 || id == 127 && appAsLib || isSystemAsset) {
            byte by = this.mNextPackageId;
            this.mNextPackageId = (byte)(by + 1);
            id = by;
            isDynamic = true;
        }
        PackageGroup group = null;
        ResTablePackage _package = new ResTablePackage(this, header, pkg);
        if (_package == NULL) {
            this.mError = -2147483644;
            return -2147483644;
        }
        err = _package.typeStrings.setTo(pkg.myBuf(), base + Util.dtohl(pkg.typeStrings), header.dataEnd - (base + Util.dtohl(pkg.typeStrings)), false);
        if (err != 0) {
            this.mError = err;
            return this.mError;
        }
        err = _package.keyStrings.setTo(pkg.myBuf(), base + Util.dtohl(pkg.keyStrings), header.dataEnd - (base + Util.dtohl(pkg.keyStrings)), false);
        if (err != 0) {
            this.mError = err;
            return this.mError;
        }
        int idx = this.mPackageMap[id];
        if (idx == 0) {
            idx = this.mPackageGroups.size() + 1;
            group = new PackageGroup(this, new String(pkg.name), id, appAsLib, isSystemAsset, isDynamic);
            if (group == NULL) {
                this.mError = -2147483644;
                return -2147483644;
            }
            this.mPackageGroups.put(group.id, group);
            this.mPackageMap[id] = (byte)idx;
            for (PackageGroup packageGroup : this.mPackageGroups.values()) {
                packageGroup.dynamicRefTable.addMapping(group.name, (byte)group.id);
            }
        } else {
            group = this.mPackageGroups.get(idx - 1);
            if (group == NULL) {
                this.mError = Integer.MIN_VALUE;
                return Integer.MIN_VALUE;
            }
        }
        group.packages.add(_package);
        ResourceTypes.ResChunk_header chunk = new ResourceTypes.ResChunk_header(pkg.myBuf(), pkg.myOffset() + Util.dtohs(pkg.header.headerSize));
        int endPos = pkg.myOffset() + pkg.header.size;
        while (chunk != null && chunk.myOffset() <= endPos - ResourceTypes.ResChunk_header.SIZEOF && chunk.myOffset() <= endPos - Util.dtohl(chunk.size)) {
            Type t;
            List typeList;
            IdmapEntries idmapEntry;
            byte typeIndex;
            boolean addToType;
            int newEntryCount;
            int csize = Util.dtohl(chunk.size);
            short ctype = Util.dtohs(chunk.type);
            if (ctype == 514) {
                ResourceTypes.ResTable_typeSpec typeSpec = new ResourceTypes.ResTable_typeSpec(chunk.myBuf(), chunk.myOffset());
                err = ResourceTypes.validate_chunk(typeSpec.header, ResourceTypes.ResTable_typeSpec.SIZEOF, endPos, "ResTable_typeSpec");
                if (err != 0) {
                    this.mError = err;
                    return this.mError;
                }
                int typeSpecSize = Util.dtohl(typeSpec.header.size);
                newEntryCount = Util.dtohl(typeSpec.entryCount);
                if (Util.dtohl(typeSpec.entryCount) > 0x1FFFFFFF || Util.dtohs(typeSpec.header.headerSize) + 4 * newEntryCount > typeSpecSize) {
                    Util.ALOGW("ResTable_typeSpec entry index to %s extends beyond chunk end %s.", Util.dtohs(typeSpec.header.headerSize) + 4 * newEntryCount, typeSpecSize);
                    this.mError = -2147483646;
                    return -2147483646;
                }
                if (typeSpec.id == 0) {
                    Util.ALOGW("ResTable_type has an id of 0.", new Object[0]);
                    this.mError = -2147483646;
                    return -2147483646;
                }
                if (newEntryCount > 0) {
                    addToType = true;
                    typeIndex = (byte)(typeSpec.id - 1);
                    idmapEntry = (IdmapEntries)idmapEntries.get(typeSpec.id);
                    if (idmapEntry != null) {
                        typeIndex = (byte)(idmapEntry.targetTypeId() - 1);
                    } else if (header.resourceIDMap != NULL) {
                        addToType = false;
                    }
                    if (addToType) {
                        typeList = ResTable.computeIfAbsent(group.types, Integer.valueOf(typeIndex), k -> new ArrayList());
                        if (!typeList.isEmpty()) {
                            Type existingType = (Type)typeList.get(0);
                            if (existingType.entryCount != newEntryCount && idmapEntry == null) {
                                Util.ALOGW("ResTable_typeSpec entry count inconsistent: given %d, previously %d", newEntryCount, existingType.entryCount);
                            }
                        }
                        t = new Type(header, _package, newEntryCount);
                        t.typeSpec = typeSpec;
                        t.typeSpecFlags = typeSpec.getSpecFlags();
                        if (idmapEntry != null) {
                            t.idmapEntries = idmapEntry;
                        }
                        typeList.add(t);
                        group.largestTypeId = UnsignedBytes.max((byte[])new byte[]{group.largestTypeId, typeSpec.id});
                    }
                } else {
                    Util.ALOGV("Skipping empty ResTable_typeSpec for type %d", typeSpec.id);
                }
            } else if (ctype == 513) {
                ResourceTypes.ResTable_type type = new ResourceTypes.ResTable_type(chunk.myBuf(), chunk.myOffset());
                err = ResourceTypes.validate_chunk(type.header, ResourceTypes.ResTable_type.SIZEOF_WITHOUT_CONFIG + 4, endPos, "ResTable_type");
                if (err != 0) {
                    this.mError = err;
                    return this.mError;
                }
                int typeSize = Util.dtohl(type.header.size);
                newEntryCount = Util.dtohl(type.entryCount);
                if (Util.dtohs(type.header.headerSize) + 4 * newEntryCount > typeSize) {
                    Util.ALOGW("ResTable_type entry index to %s extends beyond chunk end 0x%x.", Util.dtohs(type.header.headerSize) + 4 * newEntryCount, typeSize);
                    this.mError = -2147483646;
                    return -2147483646;
                }
                if (newEntryCount != 0 && Util.dtohl(type.entriesStart) > typeSize - 8) {
                    Util.ALOGW("ResTable_type entriesStart at 0x%x extends beyond chunk end 0x%x.", Util.dtohl(type.entriesStart), typeSize);
                    this.mError = -2147483646;
                    return -2147483646;
                }
                if (type.id == 0) {
                    Util.ALOGW("ResTable_type has an id of 0.", new Object[0]);
                    this.mError = -2147483646;
                    return -2147483646;
                }
                if (newEntryCount > 0) {
                    addToType = true;
                    typeIndex = (byte)(type.id - 1);
                    idmapEntry = (IdmapEntries)idmapEntries.get(type.id);
                    if (idmapEntry != null) {
                        typeIndex = (byte)(idmapEntry.targetTypeId() - 1);
                    } else if (header.resourceIDMap != NULL) {
                        addToType = false;
                    }
                    if (addToType) {
                        typeList = ResTable.getOrDefault(group.types, Integer.valueOf(typeIndex), Collections.emptyList());
                        if (typeList.isEmpty()) {
                            Util.ALOGE("No TypeSpec for type %d", type.id);
                            this.mError = -2147483646;
                            return -2147483646;
                        }
                        t = (Type)typeList.get(typeList.size() - 1);
                        if (t._package_ != _package) {
                            Util.ALOGE("No TypeSpec for type %d", type.id);
                            this.mError = -2147483646;
                            return -2147483646;
                        }
                        t.configs.add(type);
                    }
                } else {
                    Util.ALOGV("Skipping empty ResTable_type for type %d", type.id);
                }
            } else if (ctype == 515) {
                if (group.dynamicRefTable.entries().isEmpty()) {
                    throw new UnsupportedOperationException("libraries not supported yet");
                }
                Util.ALOGW("Found multiple library tables, ignoring...", new Object[0]);
            } else {
                err = ResourceTypes.validate_chunk(chunk, ResourceTypes.ResChunk_header.SIZEOF, endPos, "ResTable_package:unknown");
                if (err != 0) {
                    this.mError = err;
                    return this.mError;
                }
            }
            chunk = chunk.myOffset() + csize < endPos ? new ResourceTypes.ResChunk_header(chunk.myBuf(), chunk.myOffset() + csize) : null;
        }
        return 0;
    }

    public int getTableCookie(int index) {
        return this.mHeaders.get((int)index).cookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParameters(ResTable_config params) {
        Semaphore semaphore = this.mLock;
        synchronized (semaphore) {
            Object object = this.mFilteredConfigLock;
            synchronized (object) {
                this.mParams = params;
                for (PackageGroup packageGroup : this.mPackageGroups.values()) {
                    packageGroup.clearBagCache();
                    for (List<Type> typeList : packageGroup.types.values()) {
                        if (typeList.isEmpty()) continue;
                        for (int ts = 0; ts < typeList.size(); ++ts) {
                            Type type = typeList.get(ts);
                            ArrayList<ResourceTypes.ResTable_type> newFilteredConfigs = new ArrayList<ResourceTypes.ResTable_type>();
                            for (int ti = 0; ti < type.configs.size(); ++ti) {
                                ResTable_config config = ResTable_config.fromDtoH(type.configs.get((int)ti).config);
                                if (!config.match(this.mParams)) continue;
                                newFilteredConfigs.add(type.configs.get(ti));
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResTable_config getParameters() {
        Semaphore semaphore = this.mLock;
        synchronized (semaphore) {
            return this.mParams;
        }
    }

    public int identifierForName(String name, String type, String packageName) {
        return this.identifierForName(name, type, packageName, null);
    }

    public int identifierForName(String nameString, String type, String packageName, Ref<Integer> outTypeSpecFlags) {
        if (nameString.startsWith("^")) {
            if (sInternalNameToIdMap.containsKey(nameString)) {
                if (outTypeSpecFlags != null) {
                    outTypeSpecFlags.set(0x40000000);
                }
                return sInternalNameToIdMap.get(nameString);
            }
            if (nameString.length() > 7 && nameString.substring(1, 6).equals("index_")) {
                int index = Integer.getInteger(nameString.substring(7));
                if (ResTable.Res_CHECKID(index)) {
                    Util.ALOGW("Array resource index: %d is too large.", index);
                    return 0;
                }
                if (outTypeSpecFlags != null) {
                    outTypeSpecFlags.set(0x40000000);
                }
                return ResTable.Res_MAKEARRAY(index);
            }
            return 0;
        }
        if (this.mError != 0) {
            return 0;
        }
        boolean fakePublic = false;
        char[] name = nameString.toCharArray();
        int packageEnd = -1;
        int typeEnd = -1;
        int nameEnd = name.length;
        for (int pIndex = 0; pIndex < nameEnd; ++pIndex) {
            char p = name[pIndex];
            if (p == ':') {
                packageEnd = pIndex;
                continue;
            }
            if (p != '/') continue;
            typeEnd = pIndex;
        }
        int nameIndex = 0;
        if (name[nameIndex] == '@' && name[++nameIndex] == '*') {
            fakePublic = true;
            ++nameIndex;
        }
        if (nameIndex >= nameEnd) {
            return 0;
        }
        if (packageEnd != -1) {
            packageName = nameString.substring(nameIndex, packageEnd);
            nameIndex = packageEnd + 1;
        } else if (packageName == null) {
            return 0;
        }
        if (typeEnd != -1) {
            type = nameString.substring(nameIndex, typeEnd);
            nameIndex = typeEnd + 1;
        } else if (type == null) {
            return 0;
        }
        if (nameIndex >= nameEnd) {
            return 0;
        }
        nameString = nameString.substring(nameIndex, nameEnd);
        String attr = "attr";
        String attrPrivate = "^attr-private";
        for (PackageGroup group : this.mPackageGroups.values()) {
            if (!Objects.equals(packageName.trim(), group.name.trim())) continue;
            block2: for (ResTablePackage pkg : group.packages) {
                String targetType = type;
                do {
                    int identifier;
                    int ti;
                    if ((ti = pkg.typeStrings.indexOfString(targetType)) >= 0 && (identifier = this.findEntry(group, ti += pkg.typeIdOffset, nameString, outTypeSpecFlags)) != 0) {
                        if (fakePublic && outTypeSpecFlags != null) {
                            outTypeSpecFlags.set(outTypeSpecFlags.get() | 0x40000000);
                        }
                        return identifier;
                    }
                    if ("attr".compareTo(targetType) != 0) continue block2;
                    targetType = "^attr-private";
                } while ("^attr-private" != null);
            }
        }
        return 0;
    }

    int findEntry(PackageGroup group, int typeIndex, String name, Ref<Integer> outTypeSpecFlags) {
        List<Type> typeList = ResTable.getOrDefault(group.types, typeIndex, Collections.emptyList());
        for (Type type : typeList) {
            int ei = type._package_.keyStrings.indexOfString(name);
            if (ei < 0) continue;
            for (ResourceTypes.ResTable_type resTableType : type.configs) {
                int entryIndex = resTableType.findEntryByResName(ei);
                if (entryIndex < 0) continue;
                int resId = this.Res_MAKEID(group.id - 1, typeIndex, entryIndex);
                if (outTypeSpecFlags != null) {
                    Entry result = new Entry();
                    if (this.getEntry(group, typeIndex, entryIndex, null, result) != 0) {
                        Util.ALOGW("Failed to find spec flags for 0x%08x", resId);
                        return 0;
                    }
                    outTypeSpecFlags.set(result.specFlags);
                }
                return resId;
            }
        }
        return 0;
    }

    public int getBasePackageCount() {
        if (this.mError != 0) {
            return 0;
        }
        return this.mPackageGroups.size();
    }

    public String getBasePackageName(int idx) {
        if (this.mError != 0) {
            return null;
        }
        Util.LOG_FATAL_IF(idx >= this.mPackageGroups.size(), "Requested package index %d past package count %d", idx, this.mPackageGroups.size());
        return this.mPackageGroups.get((Object)Integer.valueOf((int)this.keyFor((int)idx))).name;
    }

    public int getBasePackageId(int idx) {
        if (this.mError != 0) {
            return 0;
        }
        Util.LOG_FATAL_IF(idx >= this.mPackageGroups.size(), "Requested package index %d past package count %d", idx, this.mPackageGroups.size());
        return this.mPackageGroups.get((Object)Integer.valueOf((int)this.keyFor((int)idx))).id;
    }

    int getLastTypeIdForPackage(int idx) {
        if (this.mError != 0) {
            return 0;
        }
        Util.LOG_FATAL_IF(idx >= this.mPackageGroups.size(), "Requested package index %d past package count %d", idx, this.mPackageGroups.size());
        PackageGroup group = this.mPackageGroups.get(this.keyFor(idx));
        return group.largestTypeId;
    }

    int keyFor(int idx) {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.mPackageGroups.keySet());
        Collections.sort(keys);
        return keys.get(idx);
    }

    public int getTableCount() {
        return this.mHeaders.size();
    }

    public ResStringPool getTableStringBlock(int index) {
        return this.mHeaders.get((int)index).values;
    }

    public DynamicRefTable getDynamicRefTableForCookie(int cookie) {
        for (PackageGroup pg : this.mPackageGroups.values()) {
            int M = pg.packages.size();
            for (int j = 0; j < M; ++j) {
                if (pg.packages.get((int)j).header.cookie != cookie) continue;
                return pg.dynamicRefTable;
            }
        }
        return null;
    }

    public boolean getResourceName(int resID, boolean allowUtf8, ResourceName outName) {
        if (this.mError != 0) {
            return false;
        }
        int p = this.getResourcePackageIndex(resID);
        int t = ResTable.Res_GETTYPE(resID);
        int e = ResTable.Res_GETENTRY(resID);
        if (p < 0) {
            if (ResTable.Res_GETPACKAGE(resID) + 1 == 0) {
                Util.ALOGW("No package identifier when getting name for resource number 0x%08x", resID);
            }
            return false;
        }
        if (t < 0) {
            Util.ALOGW("No type identifier when getting name for resource number 0x%08x", resID);
            return false;
        }
        PackageGroup grp = this.mPackageGroups.get(p);
        if (grp == NULL) {
            Util.ALOGW("Bad identifier when getting name for resource number 0x%08x", resID);
            return false;
        }
        Entry entry = new Entry();
        int err = this.getEntry(grp, t, e, null, entry);
        if (err != 0) {
            return false;
        }
        outName.packageName = grp.name;
        outName.type = entry.typeStr.string();
        if (outName.type == null) {
            return false;
        }
        outName.name = entry.keyStr.string();
        return outName.name != null;
    }

    String getResourceName(int resId) {
        ResourceName outName = new ResourceName();
        if (this.getResourceName(resId, true, outName)) {
            return outName.toString();
        }
        throw new IllegalArgumentException("Unknown resource id " + resId);
    }

    public void lock() {
        try {
            this.mLock.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void unlock() {
        this.mLock.release();
    }

    public int lockBag(int resID, Ref<bag_entry[]> outBag) {
        this.lock();
        int err = this.getBagLocked(resID, outBag, null);
        if (err < 0) {
            this.mLock.release();
        }
        return err;
    }

    public int getBagLocked(int resID, Ref<bag_entry[]> outBag, Ref<Integer> outTypeSpecFlags) {
        bag_set set;
        int count;
        Entry entry;
        int err;
        if (this.mError != 0) {
            return this.mError;
        }
        int p = this.getResourcePackageIndex(resID);
        int t = ResTable.Res_GETTYPE(resID);
        int e = ResTable.Res_GETENTRY(resID);
        if (p < 0) {
            Util.ALOGW("Invalid package identifier when getting bag for resource number 0x%08x", resID);
            return -2147483647;
        }
        if (t < 0) {
            Util.ALOGW("No type identifier when getting bag for resource number 0x%08x", resID);
            return -2147483647;
        }
        PackageGroup grp = this.mPackageGroups.get(p);
        if (grp == NULL) {
            Util.ALOGW("Bad identifier when getting bag for resource number 0x%08x", resID);
            return -2147483647;
        }
        List typeConfigs = ResTable.getOrDefault(grp.types, t, Collections.emptyList());
        if (typeConfigs.isEmpty()) {
            Util.ALOGW("Type identifier 0x%x does not exist.", t + 1);
            return -2147483647;
        }
        int NENTRY = ((Type)typeConfigs.get((int)0)).entryCount;
        if (e >= NENTRY) {
            Util.ALOGW("Entry identifier 0x%x is larger than entry count 0x%x", e, ((Type)typeConfigs.get((int)0)).entryCount);
            return -2147483647;
        }
        TypeCacheEntry cacheEntry = grp.typeCacheEntries.editItemAt(t);
        bag_set[] typeSet = cacheEntry.cachedBags;
        if (!Util.isTruthy(typeSet)) {
            typeSet = new bag_set[NENTRY];
        }
        if ((err = this.getEntry(grp, t, e, this.mParams, entry = new Entry())) != 0) {
            return err;
        }
        short entrySize = Util.dtohs(entry.entry.size);
        ResourceTypes.ResTable_map_entry mapEntry = entrySize >= 16 ? new ResourceTypes.ResTable_map_entry(entry.entry.myBuf(), entry.entry.myOffset()) : null;
        int parent = mapEntry != null ? Util.dtohl(mapEntry.parent.ident) : 0;
        int N = count = mapEntry != null ? Util.dtohl(mapEntry.count) : 0;
        if (Util.isTruthy(parent)) {
            Ref<Integer> resolvedParent = new Ref<Integer>(parent);
            err = grp.dynamicRefTable.lookupResourceId(resolvedParent);
            if (err != 0) {
                Util.ALOGE("Failed resolving bag parent id 0x%08x", parent);
                return Integer.MIN_VALUE;
            }
            Ref<Object> parentBag = new Ref<Object>(null);
            Ref<Integer> parentTypeSpecFlags = new Ref<Integer>(0);
            int NP = this.getBagLocked(resolvedParent.get(), parentBag, parentTypeSpecFlags);
            int NT = (NP >= 0 ? NP : 0) + N;
            set = new bag_set(NT);
            if (NP > 0) {
                set.copyFrom(parentBag.get(), NP);
                set.numAttrs = NP;
            } else {
                set.numAttrs = 0;
            }
            set.availAttrs = NT;
            set.typeSpecFlags = parentTypeSpecFlags.get();
        } else {
            set = new bag_set(N);
            set.numAttrs = 0;
            set.availAttrs = N;
            set.typeSpecFlags = 0;
        }
        set.typeSpecFlags |= entry.specFlags;
        int curOff = entry.entry.myOffset() - entry.type.myOffset() + entry.entry.size;
        bag_entry[] entries = set.bag_entries;
        int curEntry = 0;
        int pos = 0;
        while (pos < count) {
            bag_entry cur;
            boolean isInside;
            if (curOff > Util.dtohl(entry.type.header.size) - 12) {
                Util.ALOGW("ResTable_map at %d is beyond type chunk data %d", curOff, Util.dtohl(entry.type.header.size));
                return -2147483646;
            }
            ResourceTypes.ResTable_map map = new ResourceTypes.ResTable_map(entry.type.myBuf(), entry.type.myOffset() + curOff);
            ++N;
            Ref<Integer> newName = new Ref<Integer>(Util.htodl(map.name.ident));
            if (!ResTable.Res_INTERNALID(newName.get()) && grp.dynamicRefTable.lookupResourceId(newName) != 0) {
                Util.ALOGE("Failed resolving ResTable_map name at %d with ident 0x%08x", curEntry, newName.get());
                return Integer.MIN_VALUE;
            }
            int oldName = 0;
            while ((isInside = curEntry < set.numAttrs) && (oldName = entries[curEntry].map.name.ident) < newName.get()) {
                ++curEntry;
            }
            if (!isInside || oldName != newName.get()) {
                if (set.numAttrs >= set.availAttrs) {
                    int newAvail = set.availAttrs + N;
                    set.resizeBagEntries(newAvail);
                    set.availAttrs = newAvail;
                    entries = set.bag_entries;
                }
                if (isInside) {
                    System.arraycopy(entries, curEntry, entries, curEntry + 1, set.numAttrs - curEntry);
                    entries[curEntry] = null;
                    ++set.numAttrs;
                }
            }
            if ((cur = entries[curEntry]) == null) {
                cur = entries[curEntry] = new bag_entry();
            }
            cur.stringBlock = entry._package_.header.index;
            cur.map.name.ident = newName.get();
            cur.map.value = map.value;
            Ref<ResourceTypes.Res_value> valueRef = new Ref<ResourceTypes.Res_value>(cur.map.value);
            err = grp.dynamicRefTable.lookupResourceValue(valueRef);
            cur.map.value = map.value = valueRef.get();
            if (err != 0) {
                Util.ALOGE("Reference item(0x%08x) in bag could not be resolved.", cur.map.value.data);
                return Integer.MIN_VALUE;
            }
            ++curEntry;
            ++pos;
            short size = Util.dtohs(map.value.size);
            curOff += size + 12 - 8;
        }
        if (curEntry > set.numAttrs) {
            set.numAttrs = curEntry;
        }
        typeSet[e] = set;
        if (Util.isTruthy(set)) {
            if (outTypeSpecFlags != NULL) {
                outTypeSpecFlags.set(set.typeSpecFlags);
            }
            outBag.set(set.bag_entries);
            return set.numAttrs;
        }
        return -2147483647;
    }

    public void unlockBag(Ref<bag_entry[]> bag) {
        this.unlock();
    }

    private int Res_MAKEID(int packageId, int typeId, int entryId) {
        return packageId + 1 << 24 | (typeId + 1 & 0xFF) << 16 | entryId & 0xFFFF;
    }

    static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<K, V> vFunction) {
        V v = map.get(key);
        if (v == null) {
            v = vFunction.apply(key);
            map.put(key, v);
        }
        return v;
    }

    static <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        V v = map.get(key);
        return v != null || map.containsKey(key) ? v : defaultValue;
    }

    static {
        sInternalNameToIdMap.put("^type", ResourceTypes.ResTable_map.ATTR_TYPE);
        sInternalNameToIdMap.put("^l10n", ResourceTypes.ResTable_map.ATTR_L10N);
        sInternalNameToIdMap.put("^min", ResourceTypes.ResTable_map.ATTR_MIN);
        sInternalNameToIdMap.put("^max", ResourceTypes.ResTable_map.ATTR_MAX);
        sInternalNameToIdMap.put("^other", ResourceTypes.ResTable_map.ATTR_OTHER);
        sInternalNameToIdMap.put("^zero", ResourceTypes.ResTable_map.ATTR_ZERO);
        sInternalNameToIdMap.put("^one", ResourceTypes.ResTable_map.ATTR_ONE);
        sInternalNameToIdMap.put("^two", ResourceTypes.ResTable_map.ATTR_TWO);
        sInternalNameToIdMap.put("^few", ResourceTypes.ResTable_map.ATTR_FEW);
        sInternalNameToIdMap.put("^many", ResourceTypes.ResTable_map.ATTR_MANY);
    }

    private static interface Function<K, V> {
        public V apply(K var1);
    }

    public static class ResourceName {
        public String packageName;
        public String type;
        public String name;

        public String toString() {
            return this.packageName.trim() + '@' + this.type + ':' + this.name;
        }
    }

    static class TypeCacheEntry {
        bag_set[] cachedBags;
        List<List<ResourceTypes.ResTable_type>> filteredConfigs;

        TypeCacheEntry() {
        }
    }

    static class bag_set {
        int numAttrs;
        int availAttrs;
        int typeSpecFlags;
        bag_entry[] bag_entries;

        public bag_set(int entryCount) {
            this.bag_entries = new bag_entry[entryCount];
        }

        public void copyFrom(bag_entry[] parentBag, int count) {
            for (int i = 0; i < count; ++i) {
                this.bag_entries[i] = parentBag[i];
            }
        }

        public void resizeBagEntries(int newEntryCount) {
            bag_entry[] newEntries = new bag_entry[newEntryCount];
            System.arraycopy(this.bag_entries, 0, newEntries, 0, Math.min(this.bag_entries.length, newEntryCount));
            this.bag_entries = newEntries;
        }
    }

    public static class bag_entry {
        public int stringBlock;
        public ResourceTypes.ResTable_map map = new ResourceTypes.ResTable_map();
    }

    public static class ResTablePackage {
        final ResTable owner;
        final Header header;
        final ResourceTypes.ResTable_package _package_;
        ResStringPool typeStrings = new ResStringPool();
        ResStringPool keyStrings = new ResStringPool();
        int typeIdOffset;

        public ResTablePackage(ResTable owner, Header header, ResourceTypes.ResTable_package _package) {
            this.owner = owner;
            this.header = header;
            this._package_ = _package;
        }
    }

    public static class Type {
        final Header header;
        final ResTablePackage _package_;
        public final int entryCount;
        public ResourceTypes.ResTable_typeSpec typeSpec;
        public int[] typeSpecFlags;
        public IdmapEntries idmapEntries = new IdmapEntries();
        public List<ResourceTypes.ResTable_type> configs;

        public Type(Header _header, ResTablePackage _package, int count) {
            this.header = _header;
            this._package_ = _package;
            this.entryCount = count;
            this.typeSpec = null;
            this.typeSpecFlags = null;
            this.configs = new ArrayList<ResourceTypes.ResTable_type>();
        }
    }

    public static class Entry {
        ResTable_config config;
        ResourceTypes.ResTable_entry entry;
        ResourceTypes.ResTable_type type;
        int specFlags;
        ResTablePackage _package_;
        StringPoolRef typeStr;
        StringPoolRef keyStr;
    }

    public static class Header {
        ResTable owner;
        byte[] ownedData;
        ResourceTypes.ResTable_header header;
        int size;
        int dataEnd;
        int index;
        int cookie;
        ResStringPool values = new ResStringPool();
        int[] resourceIDMap;
        int resourceIDMapSize;

        public Header(ResTable owner) {
            this.owner = owner;
        }
    }

    public static class PackageGroup {
        final ResTable owner;
        final String name;
        final int id;
        List<ResTablePackage> packages = new ArrayList<ResTablePackage>();
        public final Map<Integer, List<Type>> types = new HashMap<Integer, List<Type>>();
        byte largestTypeId;
        ByteBucketArray<TypeCacheEntry> typeCacheEntries = new ByteBucketArray<TypeCacheEntry>(this, new TypeCacheEntry()){

            @Override
            TypeCacheEntry newInstance() {
                return new TypeCacheEntry();
            }
        };
        DynamicRefTable dynamicRefTable;
        final boolean isSystemAsset;
        final boolean isDynamic;

        public PackageGroup(ResTable _owner, String _name, int _id, boolean appAsLib, boolean _isSystemAsset, boolean _isDynamic) {
            this.owner = _owner;
            this.name = _name;
            this.id = _id;
            this.dynamicRefTable = new DynamicRefTable((byte)_id, appAsLib);
            this.isSystemAsset = _isSystemAsset;
            this.isDynamic = _isDynamic;
        }

        void clearBagCache() {
        }
    }

    private static interface Compare {
        public boolean compare(ResourceTypes.ResTable_sparseTypeEntry var1, ResourceTypes.ResTable_sparseTypeEntry var2);
    }
}

