/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation;

import android.app.Application;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface Config {
    public static final String NONE = "--none";
    public static final String DEFAULT = "--default";

    public int emulateSdk() default -1;

    public String manifest() default "--default";

    public Class<? extends Application> application() default Application.class;

    public String qualifiers() default "";

    public String resourceDir() default "res";

    public int reportSdk() default -1;

    public Class<?>[] shadows() default {};

    public String[] libraries() default {};

    public static class Implementation
    implements Config {
        private final int emulateSdk;
        private final String manifest;
        private final String qualifiers;
        private final String resourceDir;
        private final int reportSdk;
        private final Class<?>[] shadows;
        private final Class<? extends Application> application;
        private final String[] libraries;

        public static Config fromProperties(Properties configProperties) {
            if (configProperties == null || configProperties.size() == 0) {
                return null;
            }
            return new Implementation(Integer.parseInt(configProperties.getProperty("emulateSdk", "-1")), configProperties.getProperty("manifest", Config.DEFAULT), configProperties.getProperty("qualifiers", ""), configProperties.getProperty("resourceDir", "res"), Integer.parseInt(configProperties.getProperty("reportSdk", "-1")), Implementation.parseClasses(configProperties.getProperty("shadows", "")), Implementation.parseApplication(configProperties.getProperty("application", "android.app.Application")), Implementation.parsePaths(configProperties.getProperty("libraries", "")));
        }

        private static Class<?>[] parseClasses(String classList) {
            if (classList.length() == 0) {
                return new Class[0];
            }
            String[] classNames = classList.split("[, ]+");
            Class[] classes = new Class[classNames.length];
            for (int i = 0; i < classNames.length; ++i) {
                try {
                    classes[i] = Implementation.class.getClassLoader().loadClass(classNames[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return classes;
        }

        private static <T extends Application> Class<T> parseApplication(String className) {
            try {
                Class<?> aClass = Implementation.class.getClassLoader().loadClass(className);
                return aClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private static String[] parsePaths(String pathList) {
            if (pathList.length() == 0) {
                return new String[0];
            }
            return pathList.split("[, ]+");
        }

        public Implementation(int emulateSdk, String manifest, String qualifiers, String resourceDir, int reportSdk, Class<?>[] shadows, Class<? extends Application> application, String[] libraries) {
            this.emulateSdk = emulateSdk;
            this.manifest = manifest;
            this.qualifiers = qualifiers;
            this.resourceDir = resourceDir;
            this.reportSdk = reportSdk;
            this.shadows = shadows;
            this.application = application;
            this.libraries = libraries;
        }

        public Implementation(Config baseConfig, Config overlayConfig) {
            this.emulateSdk = this.pick(baseConfig.emulateSdk(), overlayConfig.emulateSdk(), -1);
            this.manifest = this.pick(baseConfig.manifest(), overlayConfig.manifest(), Config.DEFAULT);
            this.qualifiers = this.pick(baseConfig.qualifiers(), overlayConfig.qualifiers(), "");
            this.resourceDir = this.pick(baseConfig.resourceDir(), overlayConfig.resourceDir(), "res");
            this.reportSdk = this.pick(baseConfig.reportSdk(), overlayConfig.reportSdk(), -1);
            HashSet shadows = new HashSet();
            shadows.addAll(Arrays.asList(baseConfig.shadows()));
            shadows.addAll(Arrays.asList(overlayConfig.shadows()));
            this.shadows = shadows.toArray(new Class[shadows.size()]);
            this.application = this.pick(baseConfig.application(), overlayConfig.application(), null);
            HashSet<String> libraries = new HashSet<String>();
            libraries.addAll(Arrays.asList(baseConfig.libraries()));
            libraries.addAll(Arrays.asList(overlayConfig.libraries()));
            this.libraries = libraries.toArray(new String[libraries.size()]);
        }

        private <T> T pick(T baseValue, T overlayValue, T nullValue) {
            return overlayValue.equals(nullValue) ? baseValue : overlayValue;
        }

        @Override
        public int emulateSdk() {
            return this.emulateSdk;
        }

        @Override
        public String manifest() {
            return this.manifest;
        }

        @Override
        public Class<? extends Application> application() {
            return this.application;
        }

        @Override
        public String qualifiers() {
            return this.qualifiers;
        }

        @Override
        public String resourceDir() {
            return this.resourceDir;
        }

        @Override
        public int reportSdk() {
            return this.reportSdk;
        }

        @Override
        public Class<?>[] shadows() {
            return this.shadows;
        }

        @Override
        public String[] libraries() {
            return this.libraries;
        }

        @Override
        @NotNull
        public Class<? extends Annotation> annotationType() {
            return Config.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Implementation other = (Implementation)o;
            if (this.emulateSdk != other.emulateSdk) {
                return false;
            }
            if (this.reportSdk != other.reportSdk) {
                return false;
            }
            if (!this.qualifiers.equals(other.qualifiers)) {
                return false;
            }
            if (!Arrays.equals(this.shadows, other.shadows)) {
                return false;
            }
            return this.application == other.application;
        }

        @Override
        public int hashCode() {
            int result = this.emulateSdk;
            result = 31 * result + this.qualifiers.hashCode();
            result = 31 * result + this.reportSdk;
            result = 31 * result + Arrays.hashCode(this.shadows);
            result = 31 * result + this.application.hashCode();
            return result;
        }
    }
}

