/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation;

import android.app.Application;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface Config {
    public static final String NONE = "--none";
    public static final String DEFAULT = "--default";
    public static final String DEFAULT_RES_FOLDER = "res";
    public static final String DEFAULT_ASSET_FOLDER = "assets";

    public int[] sdk() default {};

    public String manifest() default "--default";

    public Class<?> constants() default Void.class;

    public Class<? extends Application> application() default Application.class;

    public String packageName() default "";

    public String qualifiers() default "";

    public String resourceDir() default "res";

    public String assetDir() default "assets";

    public Class<?>[] shadows() default {};

    public String[] libraries() default {};

    public static class Implementation
    implements Config {
        private final int[] sdk;
        private final String manifest;
        private final String qualifiers;
        private final String resourceDir;
        private final String assetDir;
        private final String packageName;
        private final Class<?> constants;
        private final Class<?>[] shadows;
        private final Class<? extends Application> application;
        private final String[] libraries;

        public static Config fromProperties(Properties properties) {
            if (properties == null || properties.size() == 0) {
                return null;
            }
            return new Implementation(Implementation.parseIntArrayProperty(properties.getProperty("sdk", "")), properties.getProperty("manifest", Config.DEFAULT), properties.getProperty("qualifiers", ""), properties.getProperty("packageName", ""), properties.getProperty("resourceDir", Config.DEFAULT_RES_FOLDER), properties.getProperty("assetDir", Config.DEFAULT_ASSET_FOLDER), Implementation.parseClasses(properties.getProperty("shadows", "")), Implementation.parseApplication(properties.getProperty("application", "android.app.Application")), Implementation.parseStringArrayProperty(properties.getProperty("libraries", "")), Implementation.parseClass(properties.getProperty("constants", "")));
        }

        private static Class<?> parseClass(String className) {
            if (className.isEmpty()) {
                return null;
            }
            try {
                return Implementation.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load class: " + className);
            }
        }

        private static Class<?>[] parseClasses(String input) {
            if (input.isEmpty()) {
                return new Class[0];
            }
            String[] classNames = input.split("[, ]+");
            Class[] classes = new Class[classNames.length];
            for (int i = 0; i < classNames.length; ++i) {
                classes[i] = Implementation.parseClass(classNames[i]);
            }
            return classes;
        }

        private static <T extends Application> Class<T> parseApplication(String className) {
            return Implementation.parseClass(className);
        }

        private static String[] parseStringArrayProperty(String property) {
            if (property.isEmpty()) {
                return new String[0];
            }
            return property.split("[, ]+");
        }

        private static int[] parseIntArrayProperty(String property) {
            String[] parts = Implementation.parseStringArrayProperty(property);
            int[] result = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Integer.parseInt(parts[i]);
            }
            return result;
        }

        public Implementation(int[] sdk, String manifest, String qualifiers, String packageName, String resourceDir, String assetDir, Class<?>[] shadows, Class<? extends Application> application, String[] libraries, Class<?> constants) {
            this.sdk = sdk;
            this.manifest = manifest;
            this.qualifiers = qualifiers;
            this.packageName = packageName;
            this.resourceDir = resourceDir;
            this.assetDir = assetDir;
            this.shadows = shadows;
            this.application = application;
            this.libraries = libraries;
            this.constants = constants;
        }

        public Implementation(Config other) {
            this.sdk = other.sdk();
            this.manifest = other.manifest();
            this.qualifiers = other.qualifiers();
            this.packageName = other.packageName();
            this.resourceDir = other.resourceDir();
            this.assetDir = other.assetDir();
            this.constants = other.constants();
            this.shadows = other.shadows();
            this.application = other.application();
            this.libraries = other.libraries();
        }

        public Implementation(Config baseConfig, Config overlayConfig) {
            this.sdk = this.pickSdk(baseConfig.sdk(), overlayConfig.sdk(), new int[0]);
            this.manifest = this.pick(baseConfig.manifest(), overlayConfig.manifest(), Config.DEFAULT);
            this.qualifiers = this.pick(baseConfig.qualifiers(), overlayConfig.qualifiers(), "");
            this.packageName = this.pick(baseConfig.packageName(), overlayConfig.packageName(), "");
            this.resourceDir = this.pick(baseConfig.resourceDir(), overlayConfig.resourceDir(), Config.DEFAULT_RES_FOLDER);
            this.assetDir = this.pick(baseConfig.assetDir(), overlayConfig.assetDir(), Config.DEFAULT_ASSET_FOLDER);
            this.constants = this.pick(baseConfig.constants(), overlayConfig.constants(), Void.class);
            HashSet shadows = new HashSet();
            shadows.addAll(Arrays.asList(baseConfig.shadows()));
            shadows.addAll(Arrays.asList(overlayConfig.shadows()));
            this.shadows = shadows.toArray(new Class[shadows.size()]);
            this.application = this.pick(baseConfig.application(), overlayConfig.application(), null);
            HashSet<String> libraries = new HashSet<String>();
            libraries.addAll(Arrays.asList(baseConfig.libraries()));
            libraries.addAll(Arrays.asList(overlayConfig.libraries()));
            this.libraries = libraries.toArray(new String[libraries.size()]);
        }

        private <T> T pick(T baseValue, T overlayValue, T nullValue) {
            return overlayValue != null ? (overlayValue.equals(nullValue) ? (T)baseValue : (T)overlayValue) : null;
        }

        private int[] pickSdk(int[] baseValue, int[] overlayValue, int[] nullValue) {
            return Arrays.equals(overlayValue, nullValue) ? baseValue : overlayValue;
        }

        @Override
        public int[] sdk() {
            return this.sdk;
        }

        @Override
        public String manifest() {
            return this.manifest;
        }

        @Override
        public Class<?> constants() {
            return this.constants;
        }

        @Override
        public Class<? extends Application> application() {
            return this.application;
        }

        @Override
        public String qualifiers() {
            return this.qualifiers;
        }

        @Override
        public String packageName() {
            return this.packageName;
        }

        @Override
        public String resourceDir() {
            return this.resourceDir;
        }

        @Override
        public String assetDir() {
            return this.assetDir;
        }

        @Override
        public Class<?>[] shadows() {
            return this.shadows;
        }

        @Override
        public String[] libraries() {
            return this.libraries;
        }

        @Override
        @NotNull
        public Class<? extends Annotation> annotationType() {
            return Config.class;
        }
    }
}

