/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.AttrResourceLoader;
import org.robolectric.res.ColorResourceLoader;
import org.robolectric.res.DocumentLoader;
import org.robolectric.res.DrawableResourceLoader;
import org.robolectric.res.OpaqueFileLoader;
import org.robolectric.res.PluralResourceLoader;
import org.robolectric.res.PreferenceLoader;
import org.robolectric.res.RawResourceLoader;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceExtractor;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.StyleResourceLoader;
import org.robolectric.res.ValueResourceLoader;
import org.robolectric.res.XResourceLoader;
import org.robolectric.res.XmlBlockLoader;
import org.robolectric.util.Logger;

public class PackageResourceLoader
extends XResourceLoader {
    private final ResourcePath resourcePath;

    public PackageResourceLoader(ResourcePath resourcePath) {
        this(resourcePath, new ResourceExtractor(resourcePath));
    }

    public PackageResourceLoader(ResourcePath resourcePath, ResourceIndex resourceIndex) {
        super(resourceIndex);
        this.resourcePath = resourcePath;
    }

    @Override
    void doInitialize() {
        try {
            this.loadEverything();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadEverything() throws Exception {
        Logger.debug((String)"Loading resources for %s from %s...", (Object[])new Object[]{this.resourcePath.getPackageName(), this.resourcePath.resourceBase});
        DocumentLoader documentLoader = new DocumentLoader(this.resourcePath);
        documentLoader.load("values", new ValueResourceLoader(this.data, "/resources/bool", "bool", ResType.BOOLEAN), new ValueResourceLoader(this.data, "/resources/item[@type='bool']", "bool", ResType.BOOLEAN), new ValueResourceLoader(this.data, "/resources/color", "color", ResType.COLOR), new ValueResourceLoader(this.data, "/resources/drawable", "drawable", ResType.DRAWABLE), new ValueResourceLoader(this.data, "/resources/item[@type='color']", "color", ResType.COLOR), new ValueResourceLoader(this.data, "/resources/dimen", "dimen", ResType.DIMEN), new ValueResourceLoader(this.data, "/resources/item[@type='dimen']", "dimen", ResType.DIMEN), new ValueResourceLoader(this.data, "/resources/integer", "integer", ResType.INTEGER), new ValueResourceLoader(this.data, "/resources/item[@type='integer']", "integer", ResType.INTEGER), new ValueResourceLoader(this.data, "/resources/integer-array", "array", ResType.INTEGER_ARRAY), new ValueResourceLoader(this.data, "/resources/fraction", "fraction", ResType.FRACTION), new ValueResourceLoader(this.data, "/resources/item[@type='fraction']", "fraction", ResType.FRACTION), new ValueResourceLoader(this.data, "/resources/item", "layout", ResType.LAYOUT), new PluralResourceLoader(this.pluralsData), new ValueResourceLoader(this.data, "/resources/string", "string", ResType.CHAR_SEQUENCE), new ValueResourceLoader(this.data, "/resources/item[@type='string']", "string", ResType.CHAR_SEQUENCE), new ValueResourceLoader(this.data, "/resources/string-array", "array", ResType.CHAR_SEQUENCE_ARRAY), new AttrResourceLoader(this.data), new StyleResourceLoader(this.data));
        documentLoader.load("layout", new OpaqueFileLoader(this.data, "layout"), new XmlBlockLoader(this.xmlDocuments, "layout"));
        documentLoader.load("menu", new OpaqueFileLoader(this.data, "menu"), new XmlBlockLoader(this.xmlDocuments, "menu"));
        documentLoader.load("drawable", new OpaqueFileLoader(this.data, "drawable"), new XmlBlockLoader(this.xmlDocuments, "drawable"));
        documentLoader.load("anim", new OpaqueFileLoader(this.data, "anim"), new XmlBlockLoader(this.xmlDocuments, "anim"));
        documentLoader.load("animator", new OpaqueFileLoader(this.data, "animator"), new XmlBlockLoader(this.xmlDocuments, "animator"));
        documentLoader.load("color", new ColorResourceLoader(this.data), new XmlBlockLoader(this.xmlDocuments, "color"));
        documentLoader.load("xml", new PreferenceLoader(this.preferenceData), new XmlBlockLoader(this.xmlDocuments, "xml"));
        documentLoader.load("transition", new OpaqueFileLoader(this.data, "transition"), new XmlBlockLoader(this.xmlDocuments, "transition"));
        documentLoader.load("interpolator", new OpaqueFileLoader(this.data, "interpolator"), new XmlBlockLoader(this.xmlDocuments, "interpolator"));
        new DrawableResourceLoader(this.drawableData).findDrawableResources(this.resourcePath);
        new RawResourceLoader(this.resourcePath).loadTo(this.rawResources);
        this.loadOtherResources(this.resourcePath);
    }

    protected void loadOtherResources(ResourcePath resourcePath) {
    }

    public String toString() {
        return "PackageResourceLoader{resourcePath=" + this.resourcePath + '}';
    }

    @Override
    public boolean providesFor(String namespace) {
        return this.resourcePath.getPackageName().equals(namespace);
    }
}

