/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.builder;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlBlock {
    private final Document document;
    private final String filename;
    private final String packageName;

    public static XmlBlock create(Document document, String file, String packageName) {
        XmlBlock.replaceResAutoNamespace(document, packageName);
        return new XmlBlock(document, file, packageName);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private static void replaceResAutoNamespace(Document document, String packageName) {
        String autoNs = "http://schemas.android.com/apk/res-auto";
        String newNs = "http://schemas.android.com/apk/res/" + packageName;
        XmlBlock.replaceAttributeNamespace(document, document.getDocumentElement(), autoNs, newNs);
    }

    private static void replaceAttributeNamespace(Document document, Node n, String oldNs, String newNs) {
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                XmlBlock.replaceNamespace(document, attrs.item(i), oldNs, newNs);
            }
        }
        if (n.hasChildNodes()) {
            NodeList list = n.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                XmlBlock.replaceAttributeNamespace(document, list.item(i), oldNs, newNs);
            }
        }
    }

    private static void replaceNamespace(Document document, Node n, String oldNs, String newNs) {
        if (oldNs.equals(n.getNamespaceURI())) {
            document.renameNode(n, newNs, n.getNodeName());
        }
    }

    private XmlBlock(Document document, String filename, String packageName) {
        this.document = document;
        this.filename = filename;
        this.packageName = packageName;
    }
}

