/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.ResourceRemapper;

public class ResourceExtractor
extends ResourceIndex {
    private static final ResourceRemapper RESOURCE_REMAPPER = new ResourceRemapper();
    private static final boolean REMAP_RESOURCES = false;
    private static final Logger LOGGER = Logger.getLogger(ResourceExtractor.class.getName());
    private final Class<?> processedRFile;
    private final String packageName;
    private final List<String> packageNames;
    private Integer maxUsedInt = null;

    public ResourceExtractor() {
        this.processedRFile = null;
        this.packageName = "";
        this.packageNames = Arrays.asList(new String[0]);
    }

    public ResourceExtractor(Class<?> androidInternalRClass, Class<?> androidRClass) {
        this.gatherResourceIdsAndNames(androidRClass, "android", true);
        this.gatherResourceIdsAndNames(androidInternalRClass, "android", false);
        this.processedRFile = androidRClass;
        this.packageName = this.processedRFile.getPackage().getName();
        this.packageNames = Arrays.asList(this.packageName);
    }

    public ResourceExtractor(ResourcePath resourcePath) {
        this.packageName = resourcePath.getPackageName();
        this.packageNames = Arrays.asList(this.packageName);
        if (resourcePath.rClass == null) {
            this.processedRFile = null;
            return;
        }
        this.processedRFile = resourcePath.rClass;
        this.gatherResourceIdsAndNames(resourcePath.rClass, this.packageName, true);
    }

    private void gatherResourceIdsAndNames(Class<?> rClass, String packageName, boolean checkForCollisions) {
        for (Class<?> innerClass : rClass.getClasses()) {
            for (Field field : innerClass.getDeclaredFields()) {
                int id;
                if (!field.getType().equals(Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
                String section = innerClass.getSimpleName();
                try {
                    id = field.getInt(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (section.equals("styleable")) continue;
                String fieldName = field.getName();
                ResName resName = new ResName(packageName, section, fieldName);
                this.resourceNameToId.put(resName, id);
                if (checkForCollisions && this.resourceIdToResName.containsKey(id)) {
                    String message = id + " is already defined with name: " + this.resourceIdToResName.get(id) + " can't also call it: " + resName;
                    LOGGER.severe(message);
                }
                this.resourceIdToResName.put(id, resName);
            }
        }
    }

    @Override
    public synchronized Integer getResourceId(ResName resName) {
        Integer id = (Integer)this.resourceNameToId.get(resName);
        if (id == null && ("android".equals(resName.packageName) || "".equals(resName.packageName))) {
            if (this.maxUsedInt == null) {
                this.maxUsedInt = this.resourceIdToResName.isEmpty() ? 0 : (Integer)Collections.max(this.resourceIdToResName.keySet());
            }
            id = this.maxUsedInt = Integer.valueOf(this.maxUsedInt + 1);
            this.resourceNameToId.put(resName, id);
            this.resourceIdToResName.put(id, resName);
            LOGGER.fine("no id mapping found for " + resName.getFullyQualifiedName() + "; assigning ID #0x" + Integer.toHexString(id));
        }
        return id;
    }

    @Override
    public synchronized ResName getResName(int resourceId) {
        return (ResName)this.resourceIdToResName.get(resourceId);
    }

    @Override
    public Collection<String> getPackages() {
        return this.packageNames;
    }

    public Class<?> getProcessedRFile() {
        return this.processedRFile;
    }

    public String toString() {
        return "ResourceExtractor{package=" + this.processedRFile + '}';
    }

    public String getPackageName() {
        return this.packageName;
    }
}

