/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.DrawableNode;
import org.robolectric.res.Plural;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.TypedResource;
import org.robolectric.res.builder.XmlBlock;

public abstract class ResourceLoader {
    public abstract TypedResource getValue(@NotNull ResName var1, String var2);

    public TypedResource getValue(int resId, String qualifiers) {
        ResName resName = this.getResourceIndex().getResName(resId);
        return resName != null ? this.getValue(resName, qualifiers) : null;
    }

    protected abstract Plural getPlural(ResName var1, int var2, String var3);

    public Plural getPlural(int resId, int quantity, String qualifiers) {
        ResName resName = this.getResourceIndex().getResName(resId);
        return resName != null ? this.getPlural(resName, quantity, qualifiers) : null;
    }

    public abstract XmlBlock getXml(ResName var1, String var2);

    public XmlBlock getXml(int resId, String qualifiers) {
        ResName resName = this.resolveResName(resId, qualifiers);
        return resName != null ? this.getXml(resName, qualifiers) : null;
    }

    public abstract DrawableNode getDrawableNode(ResName var1, String var2);

    public DrawableNode getDrawableNode(int resId, String qualifiers) {
        return this.getDrawableNode(this.getResourceIndex().getResName(resId), qualifiers);
    }

    public abstract InputStream getRawValue(ResName var1);

    public InputStream getRawValue(int resId) {
        return this.getRawValue(this.getResourceIndex().getResName(resId));
    }

    public abstract ResourceIndex getResourceIndex();

    public abstract boolean providesFor(String var1);

    private ResName resolveResName(int resId, String qualifiers) {
        TypedResource value = this.getValue(resId, qualifiers);
        return this.resolveResource(value, qualifiers, resId);
    }

    private ResName resolveResource(TypedResource value, String qualifiers, int resId) {
        ResName resName = this.getResourceIndex().getResName(resId);
        while (value != null && value.isReference()) {
            String s = value.asString();
            if (AttributeResource.isNull(s) || AttributeResource.isEmpty(s)) {
                value = null;
                continue;
            }
            String refStr = s.substring(1).replace("+", "");
            resName = ResName.qualifyResName(refStr, resName);
            value = this.getValue(resName, qualifiers);
        }
        return resName;
    }

    public TypedResource resolveResourceValue(TypedResource value, String qualifiers, int resId) {
        ResName resName = this.getResourceIndex().getResName(resId);
        while (value != null && value.isReference()) {
            String s = value.asString();
            if (AttributeResource.isNull(s) || AttributeResource.isEmpty(s)) {
                value = null;
                continue;
            }
            String refStr = s.substring(1).replace("+", "");
            resName = ResName.qualifyResName(refStr, resName);
            value = this.getValue(resName, qualifiers);
        }
        return value;
    }
}

