/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.XmlLoader;
import org.w3c.dom.Node;

public class Attribute {
    public static final String ANDROID_RES_NS_PREFIX = "http://schemas.android.com/apk/res/";
    private static final int ANDROID_RES_NS_PREFIX_LENGTH = "http://schemas.android.com/apk/res/".length();
    private static final Logger LOGGER = Logger.getLogger(Attribute.class.getName());
    public static final String RES_AUTO_NS_URI = "http://schemas.android.com/apk/res-auto";
    @NotNull
    public final ResName resName;
    @NotNull
    public final String value;
    @NotNull
    public final String contextPackageName;

    public static Attribute find(List<Attribute> attributes, String fullyQualifiedName) {
        return Attribute.find(attributes, new ResName(fullyQualifiedName));
    }

    public static Attribute find(List<Attribute> attributes, ResName resName) {
        for (Attribute attribute : attributes) {
            if (!resName.equals(attribute.resName)) continue;
            return attribute;
        }
        return null;
    }

    public static Attribute find(List<Attribute> attributes, int attrId, ResourceIndex resourceIndex) {
        for (Attribute attribute : attributes) {
            Integer resourceId = resourceIndex.getResourceId(attribute.resName);
            if (resourceId == null || resourceId != attrId) continue;
            return attribute;
        }
        return null;
    }

    public static String findValue(List<Attribute> attributes, String fullyQualifiedName) {
        return Attribute.findValue(attributes, fullyQualifiedName, null);
    }

    public static String findValue(List<Attribute> attributes, String fullyQualifiedName, String defaultValue) {
        Attribute attribute = Attribute.find(attributes, fullyQualifiedName);
        return attribute != null ? attribute.value : defaultValue;
    }

    public static void put(List<Attribute> attributes, Attribute attribute) {
        Attribute.remove(attributes, attribute.resName);
        attributes.add(attribute);
    }

    public static Attribute remove(List<Attribute> attributes, String fullyQualifiedName) {
        return Attribute.remove(attributes, new ResName(fullyQualifiedName));
    }

    public static Attribute remove(List<Attribute> attributes, ResName resName) {
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attribute = attributes.get(i);
            if (!resName.equals(attribute.resName)) continue;
            attributes.remove(i);
            return attribute;
        }
        return null;
    }

    public static String addType(String possiblyPartiallyQualifiedAttrName, String typeName) {
        return possiblyPartiallyQualifiedAttrName.contains(":") ? possiblyPartiallyQualifiedAttrName.replaceFirst(":", ":" + typeName + "/") : ":" + typeName + "/" + possiblyPartiallyQualifiedAttrName;
    }

    public static String qualifyName(String possiblyQualifiedAttrName, String defaultPackage) {
        if (possiblyQualifiedAttrName.indexOf(58) == -1) {
            return defaultPackage + ":" + possiblyQualifiedAttrName;
        }
        return possiblyQualifiedAttrName;
    }

    public Attribute(@NotNull String fullyQualifiedName, @NotNull String value, @NotNull String contextPackageName) {
        this(new ResName(fullyQualifiedName), value, contextPackageName);
    }

    public Attribute(@NotNull ResName resName, @NotNull String value, @NotNull String contextPackageName) {
        if (!resName.type.equals("attr")) {
            throw new IllegalStateException("\"" + resName.getFullyQualifiedName() + "\" unexpected");
        }
        this.resName = resName;
        this.value = value;
        this.contextPackageName = contextPackageName;
    }

    public Attribute(Node attr, XmlLoader.XmlContext xmlContext) {
        this(Attribute.extractPackageName(attr.getNamespaceURI(), xmlContext) + ":attr/" + attr.getLocalName(), attr.getNodeValue(), xmlContext.packageName);
    }

    private static String extractPackageName(String namespaceUri, XmlLoader.XmlContext xmlContext) {
        if (namespaceUri == null) {
            return "";
        }
        if (RES_AUTO_NS_URI.equals(namespaceUri)) {
            return xmlContext.packageName;
        }
        return Attribute.extractPackageName(namespaceUri);
    }

    public static String extractPackageName(@NotNull String namespaceUri) {
        if (namespaceUri.startsWith(ANDROID_RES_NS_PREFIX)) {
            return namespaceUri.substring(ANDROID_RES_NS_PREFIX_LENGTH);
        }
        if (!namespaceUri.equals("http://schemas.android.com/apk/prv/res/android")) {
            LOGGER.log(Level.WARNING, "unexpected ns uri \"" + namespaceUri + "\"");
        }
        return URLEncoder.encode(namespaceUri);
    }

    public String qualifiedValue() {
        if (this.isResourceReference()) {
            return "@" + this.getResourceReference().getFullyQualifiedName();
        }
        if (this.isStyleReference()) {
            return "?" + this.getStyleReference().getFullyQualifiedName();
        }
        return this.value;
    }

    public boolean isResourceReference() {
        return this.value.startsWith("@") && !this.isNull();
    }

    @NotNull
    public ResName getResourceReference() {
        if (!this.isResourceReference()) {
            throw new RuntimeException("not a resource reference: " + this);
        }
        return ResName.qualifyResName(this.value.substring(1).replace("+", ""), this.contextPackageName, "attr");
    }

    public boolean isStyleReference() {
        return this.value.startsWith("?");
    }

    public ResName getStyleReference() {
        if (!this.isStyleReference()) {
            throw new RuntimeException("not a style reference: " + this);
        }
        return ResName.qualifyResName(this.value.substring(1), this.contextPackageName, "attr");
    }

    public boolean isNull() {
        return "@null".equals(this.value);
    }

    public boolean isEmpty() {
        return "@empty".equals(this.value);
    }

    public String toString() {
        return "Attribute{name='" + this.resName + '\'' + ", value='" + this.value + '\'' + ", contextPackageName='" + this.contextPackageName + '\'' + '}';
    }
}

