/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.Arrays;
import org.robolectric.res.FsFile;

public class ResourcePath {
    public final String packageName;
    public final FsFile resourceBase;
    public final FsFile assetsDir;
    public Class<?>[] rClasses;

    public ResourcePath(String packageName, FsFile resourceBase, FsFile assetsDir, Class<?> ... rClasses) {
        this.packageName = packageName;
        this.resourceBase = resourceBase;
        this.assetsDir = assetsDir;
        this.rClasses = rClasses;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "ResourcePath{package=" + this.getPackageName() + ", path=" + this.resourceBase + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourcePath)) {
            return false;
        }
        ResourcePath that = (ResourcePath)o;
        if (!this.assetsDir.equals(that.assetsDir)) {
            return false;
        }
        if (!this.packageName.equals(that.packageName)) {
            return false;
        }
        if (!this.resourceBase.equals(that.resourceBase)) {
            return false;
        }
        return Arrays.equals(this.rClasses, that.rClasses);
    }

    public int hashCode() {
        int result = 31 * this.packageName.hashCode();
        result = 31 * result + this.resourceBase.hashCode();
        result = 31 * result + this.assetsDir.hashCode();
        result = 31 * result + Arrays.hashCode(this.rClasses);
        return result;
    }
}

