/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ResourceRemapper {
    private Set<Class<?>> seenClasses = new HashSet();
    private int nextInt = 0x70000000;

    public void remapRClass(Class<?> rClass) {
        if (this.seenClasses.add(rClass)) {
            HashMap<Integer, Integer> mappings = new HashMap<Integer, Integer>();
            for (Class<?> innerClass : rClass.getClasses()) {
                try {
                    int modifiers;
                    String section = innerClass.getSimpleName();
                    if (!section.equals("styleable")) {
                        for (Field field : innerClass.getFields()) {
                            int newValue;
                            modifiers = field.getModifiers();
                            if (Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers) || field.getType() != Integer.TYPE) continue;
                            ++this.nextInt;
                            mappings.put(field.getInt(null), newValue);
                            field.setAccessible(true);
                            field.set(null, newValue);
                        }
                    }
                    if (!section.equals("styleable")) continue;
                    for (Field field : innerClass.getFields()) {
                        modifiers = field.getModifiers();
                        if (Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers) || field.getType() != int[].class) continue;
                        field.setAccessible(true);
                        int[] intArray = (int[])field.get(null);
                        for (int i = 0; i < intArray.length; ++i) {
                            int oldValue = intArray[i];
                            intArray[i] = (Integer)mappings.get(oldValue);
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

