/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.ResBundle;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;

public class ResBunch {
    private final Map<String, ResBundle> types = new LinkedHashMap<String, ResBundle>();

    public void put(String attrType, String name, TypedResource value) {
        ResBundle bundle = this.getBundle(attrType);
        bundle.put(attrType, name, value);
    }

    private ResBundle getBundle(String attrType) {
        ResBundle bundle = this.types.get(attrType);
        if (bundle == null) {
            bundle = new ResBundle();
            this.types.put(attrType, bundle);
        }
        return bundle;
    }

    public TypedResource get(@NotNull ResName resName, String qualifiers) {
        ResBundle bundle = this.getBundle(resName.type);
        return bundle.get(resName, qualifiers);
    }

    void receive(ResourceTable.Visitor visitor) {
        for (ResBundle resBundle : this.types.values()) {
            resBundle.receive(visitor);
        }
    }
}

