/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import org.robolectric.res.StringResources;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlLoader;
import org.robolectric.res.XpathResourceXmlLoader;

public enum ResType {
    DRAWABLE,
    ATTR_DATA,
    BOOLEAN,
    COLOR,
    COLOR_STATE_LIST,
    DIMEN,
    FILE,
    FLOAT,
    FRACTION,
    INTEGER,
    LAYOUT,
    STYLE{

        @Override
        public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CHAR_SEQUENCE{

        @Override
        public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) {
            return new TypedResource<String>(StringResources.proccessStringResources(xmlNode.getTextContent()), this, xmlContext);
        }
    }
    ,
    CHAR_SEQUENCE_ARRAY{

        @Override
        public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) {
            return ResType.extractScalarItems(xmlNode, 3.CHAR_SEQUENCE_ARRAY, 3.CHAR_SEQUENCE, xmlContext);
        }
    }
    ,
    INTEGER_ARRAY{

        @Override
        public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) {
            return ResType.extractScalarItems(xmlNode, 4.INTEGER_ARRAY, 4.INTEGER, xmlContext);
        }
    };


    private static TypedResource extractScalarItems(XpathResourceXmlLoader.XmlNode xmlNode, ResType arrayResType, ResType itemResType, XmlLoader.XmlContext xmlContext) {
        ArrayList<TypedResource<String>> items = new ArrayList<TypedResource<String>>();
        for (XpathResourceXmlLoader.XmlNode item : xmlNode.selectElements("item")) {
            items.add(new TypedResource<String>(item.getTextContent(), itemResType, xmlContext));
        }
        TypedResource[] typedResources = items.toArray(new TypedResource[items.size()]);
        return new TypedResource<TypedResource[]>(typedResources, arrayResType, xmlContext);
    }

    public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) {
        return new TypedResource<String>(xmlNode.getTextContent(), this, xmlContext);
    }

    public static ResType inferFromValue(String value) {
        if (value.startsWith("#")) {
            return COLOR;
        }
        if ("true".equals(value) || "false".equals(value)) {
            return BOOLEAN;
        }
        if (value.endsWith("dp") || value.endsWith("sp") || value.endsWith("pt") || value.endsWith("px") || value.endsWith("mm") || value.endsWith("in")) {
            return DIMEN;
        }
        try {
            Integer.parseInt(value);
            return INTEGER;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Float.parseFloat(value);
                return FRACTION;
            }
            catch (NumberFormatException numberFormatException2) {
                return CHAR_SEQUENCE;
            }
        }
    }
}

