/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.ResName;
import org.robolectric.res.StyleData;
import org.robolectric.res.TypedResource;
import org.robolectric.res.builder.XmlBlock;

public abstract class ResourceTable {
    public abstract Integer getResourceId(ResName var1);

    public abstract ResName getResName(int var1);

    public abstract TypedResource getValue(int var1, String var2);

    public abstract TypedResource getValue(@NotNull ResName var1, String var2);

    public abstract XmlBlock getXml(ResName var1, String var2);

    public abstract InputStream getRawValue(ResName var1, String var2);

    public abstract InputStream getRawValue(int var1, String var2);

    public abstract boolean hasValue(ResName var1, String var2);

    public abstract void addResource(int var1, String var2, String var3);

    public abstract void receive(Visitor var1);

    @NotNull
    public List<TypedResource> grep(String regex) {
        return this.grep(Pattern.compile(regex));
    }

    @NotNull
    public List<TypedResource> grep(final Pattern pattern) {
        final ArrayList<TypedResource> matches = new ArrayList<TypedResource>();
        this.receive(new Visitor<TypedResource>(){

            @Override
            public void visit(ResName resName, Iterable<TypedResource> items) {
                boolean match = pattern.matcher(resName.getFullyQualifiedName()).find();
                if (!match && resName.type.equals("style")) {
                    for (TypedResource typedResource : items) {
                        TypedResource style = typedResource;
                        if (!((StyleData)style.getData()).grep(pattern)) continue;
                        match = true;
                        break;
                    }
                }
                if (match) {
                    for (TypedResource typedResource : items) {
                        matches.add(typedResource);
                    }
                }
            }
        });
        return matches;
    }

    static interface Visitor<T> {
        public void visit(ResName var1, Iterable<T> var2);
    }
}

