/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.robolectric.res.AttributeResource;

public enum ResType {
    DRAWABLE,
    ATTR_DATA,
    BOOLEAN,
    COLOR,
    COLOR_STATE_LIST,
    DIMEN,
    FILE,
    FLOAT,
    FRACTION,
    INTEGER,
    LAYOUT,
    STYLE,
    CHAR_SEQUENCE,
    CHAR_SEQUENCE_ARRAY,
    INTEGER_ARRAY,
    TYPED_ARRAY,
    NULL;

    private static final Pattern DIMEN_RE;

    @Nullable
    public static ResType inferType(String itemString) {
        ResType itemResType = ResType.inferFromValue(itemString);
        if (itemResType == CHAR_SEQUENCE) {
            if (AttributeResource.isStyleReference(itemString)) {
                itemResType = STYLE;
            } else if (itemString.equals("@null")) {
                itemResType = NULL;
            } else if (AttributeResource.isResourceReference(itemString)) {
                itemResType = null;
            }
        }
        return itemResType;
    }

    public static ResType inferFromValue(String value) {
        if (value.startsWith("#")) {
            return COLOR;
        }
        if ("true".equals(value) || "false".equals(value)) {
            return BOOLEAN;
        }
        if (DIMEN_RE.matcher(value).find()) {
            return DIMEN;
        }
        try {
            Integer.parseInt(value);
            return INTEGER;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Float.parseFloat(value);
                return FRACTION;
            }
            catch (NumberFormatException numberFormatException2) {
                return CHAR_SEQUENCE;
            }
        }
    }

    static {
        DIMEN_RE = Pattern.compile("^\\d+(dp|dip|sp|pt|px|mm|in)$");
    }
}

