/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.res.FsFile;

public class XmlContext {
    private static final Pattern DIR_QUALIFIER_PATTERN = Pattern.compile("^[^-]+(?:-(.*))?$");
    private final String packageName;
    private final FsFile xmlFile;

    public XmlContext(String packageName, FsFile xmlFile) {
        this.packageName = packageName;
        this.xmlFile = xmlFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getQualifiers() {
        FsFile parentDir = this.xmlFile.getParent();
        if (parentDir == null) {
            return "";
        }
        String parentDirName = parentDir.getName();
        Matcher matcher = DIR_QUALIFIER_PATTERN.matcher(parentDirName);
        if (!matcher.find()) {
            throw new IllegalStateException(parentDirName);
        }
        return matcher.group(1);
    }

    public FsFile getXmlFile() {
        return this.xmlFile;
    }

    public String toString() {
        return '{' + this.packageName + ':' + this.xmlFile + '}';
    }

    public XmlContext withLineNumber(final int lineNumber) {
        return new XmlContext(this.packageName, this.xmlFile){

            @Override
            public String toString() {
                return '{' + XmlContext.this.packageName + ':' + XmlContext.this.xmlFile + ':' + lineNumber + '}';
            }
        };
    }
}

