/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.util.Set;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.Interceptors;
import org.robolectric.internal.bytecode.InvokeDynamic;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowImpl;
import org.robolectric.internal.bytecode.ShadowInvalidator;
import org.robolectric.internal.bytecode.ShadowMap;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

public class Sandbox {
    private final ClassLoader robolectricClassLoader;
    private final ShadowInvalidator shadowInvalidator;
    public ClassHandler classHandler;
    private ShadowMap shadowMap = ShadowMap.EMPTY;

    public Sandbox(ClassLoader robolectricClassLoader) {
        this.robolectricClassLoader = robolectricClassLoader;
        this.shadowInvalidator = new ShadowInvalidator();
    }

    public <T> Class<T> bootstrappedClass(Class<?> clazz) {
        try {
            return this.robolectricClassLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getRobolectricClassLoader() {
        return this.robolectricClassLoader;
    }

    public ShadowInvalidator getShadowInvalidator() {
        return this.shadowInvalidator;
    }

    public void replaceShadowMap(ShadowMap shadowMap) {
        if (InvokeDynamic.ENABLED) {
            ShadowMap oldShadowMap = this.shadowMap;
            this.shadowMap = shadowMap;
            Set<String> invalidatedClasses = shadowMap.getInvalidatedClasses(oldShadowMap);
            this.getShadowInvalidator().invalidateClasses(invalidatedClasses);
        }
    }

    public void configure(ClassHandler classHandler, Interceptors interceptors) {
        this.classHandler = classHandler;
        ClassLoader robolectricClassLoader = this.getRobolectricClassLoader();
        ShadowInvalidator invalidator = this.getShadowInvalidator();
        Class robolectricInternalsClass = this.bootstrappedClass(RobolectricInternals.class);
        ReflectionHelpers.setStaticField(robolectricInternalsClass, (String)"classHandler", (Object)classHandler);
        ReflectionHelpers.setStaticField(robolectricInternalsClass, (String)"shadowInvalidator", (Object)invalidator);
        ReflectionHelpers.setStaticField(robolectricInternalsClass, (String)"classLoader", (Object)robolectricClassLoader);
        Class invokeDynamicSupportClass = this.bootstrappedClass(InvokeDynamicSupport.class);
        ReflectionHelpers.setStaticField(invokeDynamicSupportClass, (String)"INTERCEPTORS", (Object)interceptors);
        Class shadowClass = this.bootstrappedClass(Shadow.class);
        ReflectionHelpers.setStaticField(shadowClass, (String)"SHADOW_IMPL", (Object)ReflectionHelpers.newInstance(this.bootstrappedClass(ShadowImpl.class)));
    }
}

