/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultUtils;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.TouchTargetSizeViewCheck;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.junit.Test;
import org.robolectric.annotation.AccessibilityChecks;

public class AccessibilityUtil {
    private AccessibilityUtil() {
    }

    public static boolean passesAccessibilityChecksIfEnabled(View view) {
        StackTraceElement[] stack;
        boolean checksEnabled = false;
        String checksEnabledString = System.getenv("robolectric.accessibility.enablechecks");
        if (checksEnabledString != null) {
            checksEnabled = checksEnabledString.equals("true");
        }
        for (StackTraceElement element : stack = new Throwable().fillInStackTrace().getStackTrace()) {
            try {
                Class<?> clazz = Class.forName(element.getClassName());
                Method method = clazz.getMethod(element.getMethodName(), new Class[0]);
                AccessibilityChecks classChecksAnnotation = method.getAnnotation(AccessibilityChecks.class);
                if (classChecksAnnotation == null) {
                    classChecksAnnotation = clazz.getAnnotation(AccessibilityChecks.class);
                }
                if (classChecksAnnotation != null) {
                    checksEnabled = classChecksAnnotation.enabled();
                    break;
                }
                if (clazz.getAnnotation(Test.class) == null) continue;
                break;
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                // empty catch block
            }
        }
        if (!checksEnabled) {
            return true;
        }
        return AccessibilityUtil.passesAccessibilityChecks(view, System.out);
    }

    public static boolean passesAccessibilityChecks(View view, PrintStream printStream) {
        HashSet viewChecks = new HashSet(AccessibilityCheckPreset.getAllChecksForPreset((AccessibilityCheckPreset)AccessibilityCheckPreset.VIEW_CHECKS));
        Iterator viewCheckIterator = viewChecks.iterator();
        while (viewCheckIterator.hasNext()) {
            AccessibilityCheck viewCheck = (AccessibilityCheck)viewCheckIterator.next();
            if (!(viewCheck instanceof TouchTargetSizeViewCheck)) continue;
            viewCheckIterator.remove();
        }
        Set viewHierarchyChecks = AccessibilityCheckPreset.getAllChecksForPreset((AccessibilityCheckPreset)AccessibilityCheckPreset.VIEW_HIERARCHY_CHECKS);
        LinkedList results = new LinkedList();
        for (AccessibilityCheck check : viewChecks) {
            results.addAll(((AccessibilityViewCheck)check).runCheckOnView(view));
        }
        for (AccessibilityCheck check : viewHierarchyChecks) {
            results.addAll(((AccessibilityViewHierarchyCheck)check).runCheckOnViewHierarchy(view));
        }
        List errors = AccessibilityCheckResultUtils.getResultsForType(results, (AccessibilityCheckResult.AccessibilityCheckResultType)AccessibilityCheckResult.AccessibilityCheckResultType.ERROR);
        if (printStream != null) {
            for (AccessibilityViewCheckResult error : errors) {
                printStream.println("Accessibility Issue: " + error.getMessage().toString());
            }
        }
        return errors.size() == 0;
    }
}

