/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class Scheduler {
    private long currentTime = 0L;
    private boolean paused = false;
    private boolean isConstantlyIdling = false;
    private boolean isExecutingRunnable = false;
    private final Thread associatedThread = Thread.currentThread();
    private final List<ScheduledRunnable> runnables = new ArrayList<ScheduledRunnable>();

    public synchronized long getCurrentTime() {
        return this.currentTime;
    }

    public synchronized void pause() {
        this.paused = true;
    }

    public synchronized void unPause() {
        this.paused = false;
        this.advanceToLastPostedRunnable();
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    public synchronized void post(Runnable runnable) {
        this.postDelayed(runnable, 0L);
    }

    public synchronized void postDelayed(Runnable runnable, long delayMillis) {
        if (!this.isConstantlyIdling && (this.paused || delayMillis > 0L) || Thread.currentThread() != this.associatedThread) {
            this.queueRunnableAndSort(runnable, this.currentTime + delayMillis);
        } else {
            this.runOrQueueRunnable(runnable, this.currentTime + delayMillis);
        }
    }

    public synchronized void postAtFrontOfQueue(Runnable runnable) {
        if (this.paused || Thread.currentThread() != this.associatedThread) {
            this.runnables.add(0, new ScheduledRunnable(runnable, this.currentTime));
        } else {
            this.runOrQueueRunnable(runnable, this.currentTime);
        }
    }

    public synchronized void remove(Runnable runnable) {
        ListIterator<ScheduledRunnable> iterator = this.runnables.listIterator();
        while (iterator.hasNext()) {
            ScheduledRunnable next = iterator.next();
            if (next.runnable != runnable) continue;
            iterator.remove();
        }
    }

    public synchronized boolean advanceToLastPostedRunnable() {
        return this.size() >= 1 && this.advanceTo(this.runnables.get(this.runnables.size() - 1).scheduledTime);
    }

    public synchronized boolean advanceToNextPostedRunnable() {
        return this.size() >= 1 && this.advanceTo(this.runnables.get(0).scheduledTime);
    }

    public synchronized boolean advanceBy(long interval) {
        long endingTime = this.currentTime + interval;
        return this.advanceTo(endingTime);
    }

    public synchronized boolean advanceTo(long endTime) {
        if (endTime - this.currentTime < 0L || this.size() < 1) {
            this.currentTime = endTime;
            return false;
        }
        int runCount = 0;
        while (this.nextTaskIsScheduledBefore(endTime)) {
            this.runOneTask();
            ++runCount;
        }
        this.currentTime = endTime;
        return runCount > 0;
    }

    public synchronized boolean runOneTask() {
        if (this.size() < 1) {
            return false;
        }
        ScheduledRunnable postedRunnable = this.runnables.remove(0);
        this.currentTime = postedRunnable.scheduledTime;
        postedRunnable.run();
        return true;
    }

    public synchronized boolean areAnyRunnable() {
        return this.nextTaskIsScheduledBefore(this.currentTime);
    }

    public synchronized void reset() {
        this.runnables.clear();
        this.paused = false;
        this.isConstantlyIdling = false;
    }

    public synchronized int size() {
        return this.runnables.size();
    }

    public void idleConstantly(boolean shouldIdleConstantly) {
        this.isConstantlyIdling = shouldIdleConstantly;
    }

    private boolean nextTaskIsScheduledBefore(long endingTime) {
        return this.size() > 0 && this.runnables.get(0).scheduledTime <= endingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOrQueueRunnable(Runnable runnable, long scheduledTime) {
        if (this.isExecutingRunnable) {
            this.queueRunnableAndSort(runnable, scheduledTime);
            return;
        }
        this.isExecutingRunnable = true;
        try {
            runnable.run();
        }
        finally {
            this.isExecutingRunnable = false;
        }
        if (scheduledTime > this.currentTime) {
            this.currentTime = scheduledTime;
        }
        if (this.isConstantlyIdling) {
            this.advanceToLastPostedRunnable();
        } else if (!this.paused) {
            this.advanceBy(0L);
        }
    }

    private void queueRunnableAndSort(Runnable runnable, long scheduledTime) {
        this.runnables.add(new ScheduledRunnable(runnable, scheduledTime));
        Collections.sort(this.runnables);
    }

    private class ScheduledRunnable
    implements Comparable<ScheduledRunnable> {
        private final Runnable runnable;
        private final long scheduledTime;

        private ScheduledRunnable(Runnable runnable, long scheduledTime) {
            this.runnable = runnable;
            this.scheduledTime = scheduledTime;
        }

        @Override
        public int compareTo(ScheduledRunnable runnable) {
            return (int)(this.scheduledTime - runnable.scheduledTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Scheduler.this.isExecutingRunnable = true;
            try {
                this.runnable.run();
            }
            finally {
                Scheduler.this.isExecutingRunnable = false;
            }
        }
    }
}

