/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;

public class Transcript {
    private List<String> events = new ArrayList<String>();

    public void add(String event) {
        this.events.add(event);
    }

    public void assertNoEventsSoFar() {
        Assert.assertEquals((String)("Expected no events but got " + this.events + "."), (long)0L, (long)this.events.size());
    }

    public void assertEventsSoFar(String ... expectedEvents) {
        Assert.assertEquals(Arrays.asList(expectedEvents), this.events);
        this.events.clear();
    }

    public void assertEventsInclude(String ... expectedEvents) {
        ArrayList<String> original = new ArrayList<String>(this.events);
        for (String expectedEvent : expectedEvents) {
            int index = this.events.indexOf(expectedEvent);
            if (index == -1) {
                Assert.assertEquals(Arrays.asList(expectedEvents), original);
            }
            this.events.subList(0, index + 1).clear();
        }
    }

    public void clear() {
        this.events.clear();
    }

    public List<String> getEvents() {
        return this.events;
    }
}

