/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;

public class TempDirectory {
    private static final TempDirectory instance = new TempDirectory();
    private final Queue<Path> reusableDirs = new ArrayDeque<Path>();
    private final Set<String> deletePaths = new LinkedHashSet<String>();

    TempDirectory() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                for (String file : TempDirectory.this.deletePaths) {
                    try {
                        Path path = Paths.get(file, new String[0]);
                        TempDirectory.this.clearDirectory(path);
                        Files.delete(path);
                    }
                    catch (IOException iOException) {}
                }
            }
        }));
    }

    public static Path create() {
        return instance.createImpl(true);
    }

    @Deprecated
    public static Path createDeleteOnExit() {
        return instance.createImpl(true);
    }

    public static void destroy(Path path) {
        if (path != null) {
            instance.destroyImpl(path);
        }
    }

    Path createImpl(boolean deleteOnExit) {
        Path empty = this.reusableDirs.poll();
        if (empty != null && Files.exists(empty, new LinkOption[0])) {
            return empty;
        }
        try {
            Path directory = this.createTempDir("robolectric");
            if (deleteOnExit) {
                this.deleteOnExit(directory);
            }
            return directory;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void destroyImpl(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            this.clearDirectory(path);
            this.reusableDirs.add(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.deleteOnExit(path);
    }

    private void clearDirectory(final Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(directory)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void deleteOnExit(Path path) {
        this.deletePaths.add(path.toString());
    }

    private Path createTempDir(String name) throws IOException {
        return Files.createTempDirectory(name, new FileAttribute[0]);
    }
}

