/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.templates;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;

public class LogHandler
implements LogChute {
    private final AbstractMojo mojo;

    public LogHandler(AbstractMojo mojo) {
        this.mojo = mojo;
    }

    public void init(RuntimeServices runtimeServices) throws Exception {
    }

    public boolean isLevelEnabled(int level) {
        if (level == 0 && this.mojo.getLog().isDebugEnabled()) {
            return true;
        }
        if (level == 1 && this.mojo.getLog().isInfoEnabled()) {
            return true;
        }
        if (level == 2 && this.mojo.getLog().isWarnEnabled()) {
            return true;
        }
        return level == 3 && this.mojo.getLog().isErrorEnabled();
    }

    public void log(int level, String content) {
        if (this.isLevelEnabled(level)) {
            switch (level) {
                case 0: {
                    this.mojo.getLog().debug((CharSequence)content);
                    break;
                }
                case 1: {
                    this.mojo.getLog().info((CharSequence)content);
                    break;
                }
                case 2: {
                    this.mojo.getLog().warn((CharSequence)content);
                    break;
                }
                case 3: {
                    this.mojo.getLog().error((CharSequence)content);
                }
            }
        }
    }

    public void log(int level, String content, Throwable throwable) {
        if (this.isLevelEnabled(level)) {
            switch (level) {
                case 0: {
                    this.mojo.getLog().debug((CharSequence)content, throwable);
                    break;
                }
                case 1: {
                    this.mojo.getLog().info((CharSequence)content, throwable);
                    break;
                }
                case 2: {
                    this.mojo.getLog().warn((CharSequence)content, throwable);
                    break;
                }
                case 3: {
                    this.mojo.getLog().error((CharSequence)content, throwable);
                }
            }
        }
    }
}

