/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.templates;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.robolectric.templates.LogHandler;

@Mojo(name="process-templates")
public class ProcessTemplatesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    private File output;
    @Parameter(required=true, readonly=true)
    private Integer api;
    @Parameter(required=true, readonly=true)
    private FileSet fileset;

    public void execute() throws MojoExecutionException {
        try {
            Velocity.setProperty((String)"runtime.log.logsystem", (Object)new LogHandler(this));
            Velocity.setProperty((String)"file.resource.loader.path", (Object)this.fileset.getDirectory());
            Velocity.init();
            VelocityContext context = new VelocityContext();
            context.put("api", (Object)this.api);
            if (this.api >= 21) {
                context.put("ptrClass", (Object)"long");
                context.put("ptrClassBoxed", (Object)"Long");
            } else {
                context.put("ptrClass", (Object)"int");
                context.put("ptrClassBoxed", (Object)"Integer");
            }
            for (File file : this.getFiles()) {
                this.processTemplate(context, file);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing file", e);
        }
    }

    private List<File> getFiles() throws IOException {
        FileSetManager manager = new FileSetManager();
        ArrayList<File> files = new ArrayList<File>();
        for (String file : manager.getIncludedFiles(this.fileset)) {
            files.add(new File(file));
        }
        return files;
    }

    private void processTemplate(VelocityContext context, File file) throws VelocityException, MojoExecutionException, IOException {
        try {
            File inputFile = new File(file.getPath());
            this.getLog().debug((CharSequence)("Input file: " + inputFile.getPath()));
            StringWriter sw = new StringWriter();
            Template template = Velocity.getTemplate((String)inputFile.getPath(), (String)"UTF-8");
            template.merge((Context)context, (Writer)sw);
            File outputFile = new File(this.output.getAbsoluteFile(), file.getPath().replace(this.fileset.getDirectory(), "").replace(".vm", ""));
            this.getLog().debug((CharSequence)("Output file: " + outputFile.getPath()));
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
            try (FileOutputStream os = new FileOutputStream(outputFile);){
                os.write(sw.toString().getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing template file: " + file.getAbsolutePath() + ": " + e);
        }
    }
}

