/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.internal.DoNotInstrument;
import org.robolectric.annotation.internal.Instrument;
import org.robolectric.internal.bytecode.ClassInfo;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.MethodRef;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.shadow.api.Shadow;

public class InstrumentationConfiguration {
    static final Set<String> CLASSES_TO_ALWAYS_ACQUIRE = Sets.newHashSet((Object[])new String[]{RobolectricInternals.class.getName(), InvokeDynamicSupport.class.getName(), Shadow.class.getName(), "org.robolectric.util.FragmentTestUtil", "org.robolectric.util.FragmentTestUtil$FragmentUtilActivity"});
    private final List<String> instrumentedPackages;
    private final Set<String> instrumentedClasses;
    private final Set<String> classesToNotInstrument;
    private final Map<String, String> classNameTranslations;
    private final Set<MethodRef> interceptedMethods;
    private final Set<String> classesToNotAcquire;
    private final Set<String> packagesToNotAcquire;
    private final Set<String> packagesToNotInstrument;
    private int cachedHashCode;

    public static Builder newBuilder() {
        return new Builder();
    }

    private InstrumentationConfiguration(Map<String, String> classNameTranslations, Collection<MethodRef> interceptedMethods, Collection<String> instrumentedPackages, Collection<String> instrumentedClasses, Collection<String> classesToNotAcquire, Collection<String> packagesToNotAquire, Collection<String> classesToNotInstrument, Collection<String> packagesToNotInstrument) {
        this.classNameTranslations = ImmutableMap.copyOf(classNameTranslations);
        this.interceptedMethods = ImmutableSet.copyOf(interceptedMethods);
        this.instrumentedPackages = ImmutableList.copyOf(instrumentedPackages);
        this.instrumentedClasses = ImmutableSet.copyOf(instrumentedClasses);
        this.classesToNotAcquire = ImmutableSet.copyOf(classesToNotAcquire);
        this.packagesToNotAcquire = ImmutableSet.copyOf(packagesToNotAquire);
        this.classesToNotInstrument = ImmutableSet.copyOf(classesToNotInstrument);
        this.packagesToNotInstrument = ImmutableSet.copyOf(packagesToNotInstrument);
        this.cachedHashCode = 0;
    }

    public boolean shouldInstrument(ClassInfo classInfo) {
        return !classInfo.isInterface() && !classInfo.isAnnotation() && !classInfo.hasAnnotation(DoNotInstrument.class) && (this.isInInstrumentedPackage(classInfo) || this.instrumentedClasses.contains(classInfo.getName()) || classInfo.hasAnnotation(Instrument.class)) && !this.classesToNotInstrument.contains(classInfo.getName()) && !this.isInPackagesToNotInstrument(classInfo);
    }

    public boolean shouldAcquire(String name) {
        if (CLASSES_TO_ALWAYS_ACQUIRE.contains(name)) {
            return true;
        }
        if (name.matches("(android|com\\.android\\.internal)\\.R(\\$.+)?")) {
            return true;
        }
        if (name.equals("javax.net.ssl.DistinguishedNameParser") || name.equals("javax.microedition.khronos.opengles.GL")) {
            return true;
        }
        for (String packageName : this.packagesToNotAcquire) {
            if (!name.startsWith(packageName)) continue;
            return false;
        }
        boolean isRClass = name.matches(".*\\.R(|\\$[a-z]+)$");
        return !isRClass && !this.classesToNotAcquire.contains(name);
    }

    public Set<MethodRef> methodsToIntercept() {
        return Collections.unmodifiableSet(this.interceptedMethods);
    }

    public Map<String, String> classNameTranslations() {
        return Collections.unmodifiableMap(this.classNameTranslations);
    }

    public boolean containsStubs(ClassInfo classInfo) {
        return classInfo.getName().startsWith("com.google.android.maps.");
    }

    private boolean isInInstrumentedPackage(ClassInfo classInfo) {
        String className = classInfo.getName();
        for (String instrumentedPackage : this.instrumentedPackages) {
            if (!className.startsWith(instrumentedPackage)) continue;
            return true;
        }
        return false;
    }

    private boolean isInPackagesToNotInstrument(ClassInfo classInfo) {
        String className = classInfo.getName();
        for (String notInstrumentedPackage : this.packagesToNotInstrument) {
            if (!className.startsWith(notInstrumentedPackage)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstrumentationConfiguration that = (InstrumentationConfiguration)o;
        if (!this.classNameTranslations.equals(that.classNameTranslations)) {
            return false;
        }
        if (!this.classesToNotAcquire.equals(that.classesToNotAcquire)) {
            return false;
        }
        if (!this.instrumentedPackages.equals(that.instrumentedPackages)) {
            return false;
        }
        if (!this.instrumentedClasses.equals(that.instrumentedClasses)) {
            return false;
        }
        return this.interceptedMethods.equals(that.interceptedMethods);
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int result = this.instrumentedPackages.hashCode();
        result = 31 * result + this.instrumentedClasses.hashCode();
        result = 31 * result + this.classNameTranslations.hashCode();
        result = 31 * result + this.interceptedMethods.hashCode();
        this.cachedHashCode = result = 31 * result + this.classesToNotAcquire.hashCode();
        return result;
    }

    public static final class Builder {
        private final Collection<String> instrumentedPackages = new HashSet<String>();
        private final Collection<MethodRef> interceptedMethods = new HashSet<MethodRef>();
        private final Map<String, String> classNameTranslations = new HashMap<String, String>();
        private final Collection<String> classesToNotAcquire = new HashSet<String>();
        private final Collection<String> packagesToNotAcquire = new HashSet<String>();
        private final Collection<String> instrumentedClasses = new HashSet<String>();
        private final Collection<String> classesToNotInstrument = new HashSet<String>();
        private final Collection<String> packagesToNotInstrument = new HashSet<String>();

        public Builder() {
        }

        public Builder(InstrumentationConfiguration classLoaderConfig) {
            this.instrumentedPackages.addAll(classLoaderConfig.instrumentedPackages);
            this.interceptedMethods.addAll(classLoaderConfig.interceptedMethods);
            this.classNameTranslations.putAll(classLoaderConfig.classNameTranslations);
            this.classesToNotAcquire.addAll(classLoaderConfig.classesToNotAcquire);
            this.packagesToNotAcquire.addAll(classLoaderConfig.packagesToNotAcquire);
            this.instrumentedClasses.addAll(classLoaderConfig.instrumentedClasses);
            this.classesToNotInstrument.addAll(classLoaderConfig.classesToNotInstrument);
            this.packagesToNotInstrument.addAll(classLoaderConfig.packagesToNotInstrument);
        }

        public Builder doNotAcquireClass(Class<?> clazz) {
            this.doNotAcquireClass(clazz.getName());
            return this;
        }

        public Builder doNotAcquireClass(String className) {
            this.classesToNotAcquire.add(className);
            return this;
        }

        public Builder doNotAcquirePackage(String packageName) {
            this.packagesToNotAcquire.add(packageName);
            return this;
        }

        public Builder addClassNameTranslation(String fromName, String toName) {
            this.classNameTranslations.put(fromName, toName);
            return this;
        }

        public Builder addInterceptedMethod(MethodRef methodReference) {
            this.interceptedMethods.add(methodReference);
            return this;
        }

        public Builder addInstrumentedClass(String name) {
            this.instrumentedClasses.add(name);
            return this;
        }

        public Builder addInstrumentedPackage(String packageName) {
            this.instrumentedPackages.add(packageName);
            return this;
        }

        public Builder doNotInstrumentClass(String className) {
            this.classesToNotInstrument.add(className);
            return this;
        }

        public Builder doNotInstrumentPackage(String packageName) {
            this.packagesToNotInstrument.add(packageName);
            return this;
        }

        public InstrumentationConfiguration build() {
            return new InstrumentationConfiguration(this.classNameTranslations, this.interceptedMethods, this.instrumentedPackages, this.instrumentedClasses, this.classesToNotAcquire, this.packagesToNotAcquire, this.classesToNotInstrument, this.packagesToNotInstrument);
        }
    }
}

