/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.Interceptors;
import org.robolectric.internal.bytecode.InvocationProfile;
import org.robolectric.internal.bytecode.MethodSignature;
import org.robolectric.internal.bytecode.RoboType;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowConfig;
import org.robolectric.internal.bytecode.ShadowMap;
import org.robolectric.util.Function;
import org.robolectric.util.ReflectionHelpers;

public class ShadowWrangler
implements ClassHandler {
    public static final Function<Object, Object> DO_NOTHING_HANDLER = new Function<Object, Object>(){

        @Override
        public Object call(Class<?> theClass, Object value, Object[] params) {
            return null;
        }
    };
    public static final ClassHandler.Plan DO_NOTHING_PLAN = new ClassHandler.Plan(){

        @Override
        public Object run(Object instance, Object roboData, Object[] params) throws Exception {
            return null;
        }

        @Override
        public String describe() {
            return "do nothing";
        }
    };
    public static final ClassHandler.Plan CALL_REAL_CODE_PLAN = null;
    public static final MethodHandle CALL_REAL_CODE = null;
    public static final MethodHandle DO_NOTHING = MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE));
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final boolean STRIP_SHADOW_STACK_TRACES = true;
    private static final ShadowConfig NO_SHADOW_CONFIG = new ShadowConfig(Object.class.getName(), true, false, false, -1, -1);
    static final Object NO_SHADOW = new Object();
    private static final MethodHandle NO_SHADOW_HANDLE = MethodHandles.constant(Object.class, NO_SHADOW);
    private final ShadowMap shadowMap;
    private final Interceptors interceptors;
    private final int apiLevel;
    private final Map<Class, MetaShadow> metaShadowMap = new HashMap<Class, MetaShadow>();
    private final Map<String, ClassHandler.Plan> planCache = Collections.synchronizedMap(new LinkedHashMap<String, ClassHandler.Plan>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ClassHandler.Plan> eldest) {
            return this.size() > 500;
        }
    });
    private final Map<Class, ShadowConfig> shadowConfigCache = new ConcurrentHashMap<Class, ShadowConfig>();
    private final ClassValue<ShadowConfig> shadowConfigs = new ClassValue<ShadowConfig>(){

        @Override
        protected ShadowConfig computeValue(Class<?> type) {
            return ShadowWrangler.this.shadowMap.get(type);
        }
    };

    public ShadowWrangler(ShadowMap shadowMap, int apiLevel, Interceptors interceptors) {
        this.shadowMap = shadowMap;
        this.apiLevel = apiLevel;
        this.interceptors = interceptors;
    }

    public static Class<?> loadClass(String paramType, ClassLoader classLoader) {
        Class primitiveClass = RoboType.findPrimitiveClass(paramType);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        int arrayLevel = 0;
        while (paramType.endsWith("[]")) {
            ++arrayLevel;
            paramType = paramType.substring(0, paramType.length() - 2);
        }
        Class<?> clazz = RoboType.findPrimitiveClass(paramType);
        if (clazz == null) {
            try {
                clazz = classLoader.loadClass(paramType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        while (arrayLevel-- > 0) {
            clazz = Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }

    @Override
    public void classInitializing(Class clazz) {
        Class<?> shadowClass = this.findDirectShadowClass(clazz);
        if (shadowClass != null) {
            try {
                Method method = shadowClass.getMethod("__staticInitializer__", new Class[0]);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException(shadowClass.getName() + "." + method.getName() + " is not static");
                }
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                RobolectricInternals.performStaticInitialization(clazz);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            RobolectricInternals.performStaticInitialization(clazz);
        }
    }

    @Override
    public Object initializing(Object instance) {
        return this.createShadowFor(instance);
    }

    @Override
    public ClassHandler.Plan methodInvoked(String signature, boolean isStatic, Class<?> theClass) {
        if (this.planCache.containsKey(signature)) {
            return this.planCache.get(signature);
        }
        ClassHandler.Plan plan = this.calculatePlan(signature, isStatic, theClass);
        this.planCache.put(signature, plan);
        return plan;
    }

    @Override
    public MethodHandle findShadowMethod(Class<?> caller, String name, MethodType type, boolean isStatic) throws IllegalAccessException {
        boolean shadowClassMismatch;
        MethodType actualType;
        ShadowConfig shadowConfig = this.shadowConfigs.get(caller);
        if (shadowConfig == null) {
            return CALL_REAL_CODE;
        }
        ClassLoader classLoader = caller.getClassLoader();
        Method method = this.findShadowMethod(classLoader, shadowConfig, name, (actualType = isStatic ? type : type.dropParameterTypes(0, 1)).parameterArray());
        if (method == null) {
            return shadowConfig.callThroughByDefault ? CALL_REAL_CODE : DO_NOTHING;
        }
        Class<?> declaredShadowedClass = this.getShadowedClass(method);
        if (declaredShadowedClass.equals(Object.class)) {
            return CALL_REAL_CODE;
        }
        boolean bl = shadowClassMismatch = !declaredShadowedClass.equals(caller);
        if (shadowClassMismatch && !shadowConfig.inheritImplementationMethods) {
            return CALL_REAL_CODE;
        }
        MethodHandle mh = LOOKUP.unreflect(method);
        if (!isStatic && Modifier.isStatic(method.getModifiers())) {
            return MethodHandles.dropArguments(mh, 0, new Class[]{Object.class});
        }
        return mh;
    }

    private ClassHandler.Plan calculatePlan(String signature, boolean isStatic, Class<?> theClass) {
        InvocationProfile invocationProfile = new InvocationProfile(signature, isStatic, theClass.getClassLoader());
        ShadowConfig shadowConfig = this.getShadowConfig(theClass);
        if (shadowConfig == null || !shadowConfig.supportsSdk(this.apiLevel)) {
            return CALL_REAL_CODE_PLAN;
        }
        try {
            boolean shadowClassMismatch;
            ClassLoader classLoader = theClass.getClassLoader();
            Class<?>[] types = invocationProfile.getParamClasses(classLoader);
            Method shadowMethod = this.findShadowMethod(classLoader, shadowConfig, invocationProfile.methodName, types);
            if (shadowMethod == null) {
                return shadowConfig.callThroughByDefault ? CALL_REAL_CODE_PLAN : (this.strict(invocationProfile) ? CALL_REAL_CODE_PLAN : DO_NOTHING_PLAN);
            }
            Class<?> declaredShadowedClass = this.getShadowedClass(shadowMethod);
            if (declaredShadowedClass.equals(Object.class)) {
                return CALL_REAL_CODE_PLAN;
            }
            boolean bl = shadowClassMismatch = !declaredShadowedClass.equals(invocationProfile.clazz);
            if (shadowClassMismatch && (!shadowConfig.inheritImplementationMethods || this.strict(invocationProfile))) {
                return CALL_REAL_CODE_PLAN;
            }
            return new ShadowMethodPlan(shadowMethod);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Method findShadowMethod(ClassLoader classLoader, ShadowConfig config, String name, Class<?>[] types) {
        try {
            Class<?> shadowClass = Class.forName(config.shadowClassName, false, classLoader);
            Method method = this.findShadowMethodInternal(shadowClass, name, types);
            if (method == null && config.looseSignatures) {
                Class<?>[] genericTypes = MethodType.genericMethodType(types.length).parameterArray();
                method = this.findShadowMethodInternal(shadowClass, name, genericTypes);
            }
            return method;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private ShadowConfig getShadowConfig(Class clazz) {
        ShadowConfig shadowConfig = this.shadowConfigCache.get(clazz);
        if (shadowConfig == null) {
            shadowConfig = this.shadowMap.get(clazz);
            this.shadowConfigCache.put(clazz, shadowConfig == null ? NO_SHADOW_CONFIG : shadowConfig);
            return shadowConfig;
        }
        return shadowConfig == NO_SHADOW_CONFIG ? null : shadowConfig;
    }

    private boolean isAndroidSupport(InvocationProfile invocationProfile) {
        return invocationProfile.clazz.getName().startsWith("android.support");
    }

    private boolean strict(InvocationProfile invocationProfile) {
        return this.isAndroidSupport(invocationProfile) || invocationProfile.isDeclaredOnObject();
    }

    private Method findShadowMethodInternal(Class<?> shadowClass, String methodName, Class<?>[] paramClasses) throws ClassNotFoundException {
        try {
            Method method = shadowClass.getMethod(methodName, paramClasses);
            Implementation implementation = this.getImplementationAnnotation(method);
            return this.matchesSdk(implementation) ? method : null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private boolean matchesSdk(Implementation implementation) {
        return implementation.minSdk() <= this.apiLevel && (implementation.maxSdk() == -1 || implementation.maxSdk() >= this.apiLevel);
    }

    private Class<?> getShadowedClass(Method shadowMethod) {
        Class<?> shadowingClass = shadowMethod.getDeclaringClass();
        if (shadowingClass.equals(Object.class)) {
            return Object.class;
        }
        Implements implementsAnnotation = shadowingClass.getAnnotation(Implements.class);
        if (implementsAnnotation == null) {
            throw new RuntimeException(shadowingClass + " has no @" + Implements.class.getSimpleName() + " annotation");
        }
        String shadowedClassName = implementsAnnotation.className();
        if (shadowedClassName.isEmpty()) {
            return implementsAnnotation.value();
        }
        try {
            return shadowingClass.getClassLoader().loadClass(shadowedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Implementation getImplementationAnnotation(Method method) {
        if (method == null) {
            return null;
        }
        Implementation implementation = method.getAnnotation(Implementation.class);
        return implementation == null ? (Implementation)ReflectionHelpers.defaultsFor(Implementation.class) : implementation;
    }

    @Override
    public Object intercept(String signature, Object instance, Object[] params, Class theClass) throws Throwable {
        MethodSignature methodSignature = MethodSignature.parse(signature);
        return this.interceptors.getInterceptionHandler(methodSignature).call(theClass, instance, params);
    }

    @Override
    public <T extends Throwable> T stripStackTrace(T throwable) {
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
        String previousClassName = null;
        String previousMethodName = null;
        String previousFileName = null;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            String methodName = stackTraceElement.getMethodName();
            String className = stackTraceElement.getClassName();
            String fileName = stackTraceElement.getFileName();
            if (methodName.equals(previousMethodName) && className.equals(previousClassName) && fileName != null && fileName.equals(previousFileName) && stackTraceElement.getLineNumber() < 0 || className.equals(ShadowMethodPlan.class.getName())) continue;
            if (methodName.startsWith("$$robo$$")) {
                methodName = methodName.substring("$$robo$$".length());
                stackTraceElement = new StackTraceElement(className, methodName, stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
            }
            if (className.startsWith("sun.reflect.") || className.startsWith("java.lang.reflect.")) continue;
            stackTrace.add(stackTraceElement);
            previousClassName = className;
            previousMethodName = methodName;
            previousFileName = fileName;
        }
        throwable.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        return throwable;
    }

    public Object createShadowFor(Object instance) {
        String shadowClassName = this.getShadowClassName(instance.getClass());
        if (shadowClassName == null) {
            return NO_SHADOW;
        }
        try {
            Class<?> shadowClass = ShadowWrangler.loadClass(shadowClassName, instance.getClass().getClassLoader());
            Object shadow = shadowClass.newInstance();
            this.injectRealObjectOn(shadow, shadowClass, instance);
            return shadow;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not instantiate shadow, missing public empty constructor.", e);
        }
    }

    @Override
    public MethodHandle getShadowCreator(Class<?> caller) {
        String shadowClassName = this.getShadowClassNameInvoke(caller);
        if (shadowClassName == null) {
            return MethodHandles.dropArguments(NO_SHADOW_HANDLE, 0, new Class[]{caller});
        }
        try {
            Class<?> shadowClass = Class.forName(shadowClassName, false, caller.getClassLoader());
            MethodHandle constructor = LOOKUP.findConstructor(shadowClass, MethodType.methodType(Void.TYPE));
            MetaShadow metaShadow = this.getMetaShadow(shadowClass);
            MethodHandle mh = MethodHandles.identity(shadowClass);
            mh = MethodHandles.dropArguments(mh, 1, new Class[]{caller});
            for (Field field : metaShadow.realObjectFields) {
                MethodHandle setter = LOOKUP.unreflectSetter(field);
                MethodType setterType = mh.type().changeReturnType(Void.TYPE);
                mh = MethodHandles.foldArguments(mh, setter.asType(setterType));
            }
            mh = MethodHandles.foldArguments(mh, constructor);
            return mh;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Could not instantiate shadow, missing public empty constructor.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not instantiate shadow", e);
        }
    }

    private String getShadowClassNameInvoke(Class<?> cl) {
        ShadowConfig shadowConfig = null;
        for (Class<?> clazz = cl; shadowConfig == null && clazz != null; clazz = clazz.getSuperclass()) {
            shadowConfig = this.shadowConfigs.get(clazz);
        }
        return shadowConfig == null ? null : shadowConfig.shadowClassName;
    }

    private String getShadowClassName(Class<?> cl) {
        ShadowConfig shadowConfig = null;
        for (Class<?> clazz = cl; !(shadowConfig != null && shadowConfig.supportsSdk(this.apiLevel) || clazz == null); clazz = clazz.getSuperclass()) {
            shadowConfig = this.getShadowConfig(clazz);
        }
        return shadowConfig == null ? null : shadowConfig.shadowClassName;
    }

    private void injectRealObjectOn(Object shadow, Class<?> shadowClass, Object instance) {
        MetaShadow metaShadow = this.getMetaShadow(shadowClass);
        for (Field realObjectField : metaShadow.realObjectFields) {
            ShadowWrangler.writeField(shadow, instance, realObjectField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaShadow getMetaShadow(Class<?> shadowClass) {
        Map<Class, MetaShadow> map = this.metaShadowMap;
        synchronized (map) {
            return this.metaShadowMap.computeIfAbsent(shadowClass, MetaShadow::new);
        }
    }

    private Class<?> findDirectShadowClass(Class<?> originalClass) {
        ShadowConfig shadowConfig = this.getShadowConfig(originalClass);
        if (shadowConfig == null || !shadowConfig.supportsSdk(this.apiLevel)) {
            return null;
        }
        return ShadowWrangler.loadClass(shadowConfig.shadowClassName, originalClass.getClassLoader());
    }

    private static void writeField(Object target, Object value, Field realObjectField) {
        try {
            realObjectField.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MetaShadow {
        final List<Field> realObjectFields = new ArrayList<Field>();

        public MetaShadow(Class<?> shadowClass) {
            while (shadowClass != null) {
                for (Field field : shadowClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(RealObject.class)) continue;
                    if (Modifier.isStatic(field.getModifiers())) {
                        String message = "@RealObject must be on a non-static field, " + shadowClass;
                        System.err.println(message);
                        throw new IllegalArgumentException(message);
                    }
                    field.setAccessible(true);
                    this.realObjectFields.add(field);
                }
                shadowClass = shadowClass.getSuperclass();
            }
        }
    }

    private static class ShadowMethodPlan
    implements ClassHandler.Plan {
        private final Method shadowMethod;

        public ShadowMethodPlan(Method shadowMethod) {
            this.shadowMethod = shadowMethod;
        }

        @Override
        public Object run(Object instance, Object roboData, Object[] params) throws Throwable {
            Object shadow = roboData;
            try {
                return this.shadowMethod.invoke(shadow, params);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("attempted to invoke " + this.shadowMethod + (shadow == null ? "" : " on instance of " + shadow.getClass() + ", but " + shadow.getClass().getSimpleName() + " doesn't extend " + this.shadowMethod.getDeclaringClass().getSimpleName()));
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        @Override
        public String describe() {
            return this.shadowMethod.toString();
        }
    }
}

