/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.robolectric.annotation.Implements;
import org.robolectric.internal.ShadowProvider;
import org.robolectric.internal.bytecode.ShadowConfig;

public class ShadowMap {
    public static final ShadowMap EMPTY = new ShadowMap(Collections.emptyMap());
    private final Map<String, ShadowConfig> map;
    private static final Map<String, String> SHADOWS = new HashMap<String, String>();

    ShadowMap(Map<String, ShadowConfig> map) {
        this.map = new HashMap<String, ShadowConfig>(map);
    }

    public ShadowConfig get(Class<?> clazz) {
        ShadowConfig shadowConfig = this.map.get(clazz.getName());
        if (shadowConfig == null && clazz.getClassLoader() != null) {
            Class<?> shadowClass = ShadowMap.getShadowClass(clazz);
            if (shadowClass == null) {
                return null;
            }
            ShadowInfo shadowInfo = ShadowMap.getShadowInfo(shadowClass);
            if (shadowInfo != null && shadowInfo.shadowedClassName.equals(clazz.getName())) {
                return shadowInfo.getShadowConfig();
            }
        }
        return shadowConfig;
    }

    private static Class<?> getShadowClass(Class<?> clazz) {
        try {
            String shadowName;
            String className = clazz.getCanonicalName();
            if (className != null && (shadowName = SHADOWS.get(className)) != null) {
                return clazz.getClassLoader().loadClass(shadowName);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IncompatibleClassChangeError e) {
            return null;
        }
        return null;
    }

    public static ShadowInfo getShadowInfo(Class<?> clazz) {
        Implements annotation = clazz.getAnnotation(Implements.class);
        if (annotation == null) {
            throw new IllegalArgumentException(clazz + " is not annotated with @Implements");
        }
        String className = annotation.className();
        if (className.isEmpty()) {
            className = annotation.value().getName();
        }
        return new ShadowInfo(className, new ShadowConfig(clazz.getName(), annotation));
    }

    public Set<String> getInvalidatedClasses(ShadowMap previous) {
        if (this == previous) {
            return Collections.emptySet();
        }
        HashMap<String, ShadowConfig> invalidated = new HashMap<String, ShadowConfig>();
        invalidated.putAll(this.map);
        for (Map.Entry<String, ShadowConfig> entry : previous.map.entrySet()) {
            String className = entry.getKey();
            ShadowConfig previousConfig = entry.getValue();
            ShadowConfig currentConfig = (ShadowConfig)invalidated.get(className);
            if (currentConfig == null) {
                invalidated.put(className, previousConfig);
                continue;
            }
            if (!previousConfig.equals(currentConfig)) continue;
            invalidated.remove(className);
        }
        return invalidated.keySet();
    }

    public static String convertToShadowName(String className) {
        String shadowClassName = "org.robolectric.shadows.Shadow" + className.substring(className.lastIndexOf(".") + 1);
        shadowClassName = shadowClassName.replaceAll("\\$", "\\$Shadow");
        return shadowClassName;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShadowMap shadowMap = (ShadowMap)o;
        return this.map.equals(shadowMap.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    static {
        for (ShadowProvider provider : ServiceLoader.load(ShadowProvider.class)) {
            SHADOWS.putAll(provider.getShadowMap());
        }
    }

    public static class ShadowInfo {
        private final String shadowedClassName;
        private final ShadowConfig shadowConfig;

        ShadowInfo(String shadowedClassName, ShadowConfig shadowConfig) {
            this.shadowConfig = shadowConfig;
            this.shadowedClassName = shadowedClassName;
        }

        public String getShadowedClassName() {
            return this.shadowedClassName;
        }

        public ShadowConfig getShadowConfig() {
            return this.shadowConfig;
        }
    }

    public static class Builder {
        private final Map<String, ShadowConfig> map;

        public Builder() {
            this.map = new HashMap<String, ShadowConfig>();
        }

        public Builder(ShadowMap shadowMap) {
            this.map = new HashMap<String, ShadowConfig>(shadowMap.map);
        }

        public Builder addShadowClasses(Class<?> ... shadowClasses) {
            for (Class<?> shadowClass : shadowClasses) {
                this.addShadowClass(shadowClass);
            }
            return this;
        }

        public Builder addShadowClasses(Collection<Class<?>> shadowClasses) {
            for (Class<?> shadowClass : shadowClasses) {
                this.addShadowClass(shadowClass);
            }
            return this;
        }

        public Builder addShadowClass(Class<?> shadowClass) {
            ShadowInfo shadowInfo = ShadowMap.getShadowInfo(shadowClass);
            if (shadowInfo != null) {
                this.addShadowConfig(shadowInfo.getShadowedClassName(), shadowInfo.getShadowConfig());
            }
            return this;
        }

        public Builder addShadowClass(String realClassName, Class<?> shadowClass, boolean callThroughByDefault, boolean inheritImplementationMethods, boolean looseSignatures) {
            this.addShadowClass(realClassName, shadowClass.getName(), callThroughByDefault, inheritImplementationMethods, looseSignatures);
            return this;
        }

        public Builder addShadowClass(Class<?> realClass, Class<?> shadowClass, boolean callThroughByDefault, boolean inheritImplementationMethods, boolean looseSignatures) {
            this.addShadowClass(realClass.getName(), shadowClass.getName(), callThroughByDefault, inheritImplementationMethods, looseSignatures);
            return this;
        }

        public Builder addShadowClass(String realClassName, String shadowClassName, boolean callThroughByDefault, boolean inheritImplementationMethods, boolean looseSignatures) {
            this.addShadowConfig(realClassName, new ShadowConfig(shadowClassName, callThroughByDefault, inheritImplementationMethods, looseSignatures, -1, -1));
            return this;
        }

        private void addShadowConfig(String realClassName, ShadowConfig shadowConfig) {
            this.map.put(realClassName, shadowConfig);
        }

        public ShadowMap build() {
            return new ShadowMap(this.map);
        }
    }
}

