/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.Implements;
import org.robolectric.internal.ShadowProvider;
import org.robolectric.internal.bytecode.ShadowInfo;

public class ShadowMap {
    public static final ShadowMap EMPTY = new ShadowMap(Collections.emptyMap(), Collections.emptyMap());
    private final ImmutableMap<String, String> defaultShadows;
    private final ImmutableMap<String, ShadowInfo> overriddenShadows;

    public static ShadowMap createFromShadowProviders(Iterable<ShadowProvider> shadowProviders) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ShadowProvider provider : shadowProviders) {
            map.putAll(provider.getShadowMap());
        }
        return new ShadowMap(map, new HashMap<String, ShadowInfo>());
    }

    ShadowMap(Map<String, String> defaultShadows, Map<String, ShadowInfo> overriddenShadows) {
        this.defaultShadows = ImmutableMap.copyOf(defaultShadows);
        this.overriddenShadows = ImmutableMap.copyOf(overriddenShadows);
    }

    public ShadowInfo getShadowInfo(Class<?> clazz, int apiLevel) {
        String instrumentedClassName = clazz.getName();
        ShadowInfo shadowInfo = (ShadowInfo)this.overriddenShadows.get((Object)instrumentedClassName);
        if (shadowInfo == null && clazz.getClassLoader() != null) {
            try {
                String shadowName = (String)this.defaultShadows.get((Object)clazz.getCanonicalName());
                if (shadowName != null) {
                    Class<?> shadowClass = clazz.getClassLoader().loadClass(shadowName);
                    shadowInfo = ShadowMap.obtainShadowInfo(shadowClass);
                    if (!shadowInfo.shadowedClassName.equals(instrumentedClassName)) {
                        shadowInfo = null;
                    }
                }
            }
            catch (ClassNotFoundException | IncompatibleClassChangeError e) {
                return null;
            }
        }
        if (shadowInfo != null && !shadowInfo.supportsSdk(apiLevel)) {
            return null;
        }
        return shadowInfo;
    }

    @Deprecated
    public static ShadowInfo getShadowInfo(Class<?> shadowClass) {
        return ShadowMap.obtainShadowInfo(shadowClass);
    }

    public static ShadowInfo obtainShadowInfo(Class<?> clazz) {
        return ShadowMap.obtainShadowInfo(clazz, false);
    }

    static ShadowInfo obtainShadowInfo(Class<?> clazz, boolean mayBeNonShadow) {
        Implements annotation = clazz.getAnnotation(Implements.class);
        if (annotation == null) {
            if (mayBeNonShadow) {
                return null;
            }
            throw new IllegalArgumentException(clazz + " is not annotated with @Implements");
        }
        String className = annotation.className();
        if (className.isEmpty()) {
            className = annotation.value().getName();
        }
        return new ShadowInfo(className, clazz.getName(), annotation);
    }

    public Set<String> getInvalidatedClasses(ShadowMap previous) {
        if (this == previous) {
            return Collections.emptySet();
        }
        HashMap<String, ShadowInfo> invalidated = new HashMap<String, ShadowInfo>();
        invalidated.putAll((Map<String, ShadowInfo>)this.overriddenShadows);
        for (Map.Entry entry : previous.overriddenShadows.entrySet()) {
            String className = (String)entry.getKey();
            ShadowInfo previousConfig = (ShadowInfo)entry.getValue();
            ShadowInfo currentConfig = (ShadowInfo)invalidated.get(className);
            if (currentConfig == null) {
                invalidated.put(className, previousConfig);
                continue;
            }
            if (!previousConfig.equals(currentConfig)) continue;
            invalidated.remove(className);
        }
        return invalidated.keySet();
    }

    @Deprecated
    public static String convertToShadowName(String className) {
        String shadowClassName = "org.robolectric.shadows.Shadow" + className.substring(className.lastIndexOf(".") + 1);
        shadowClassName = shadowClassName.replaceAll("\\$", "\\$Shadow");
        return shadowClassName;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShadowMap shadowMap = (ShadowMap)o;
        return this.overriddenShadows.equals(shadowMap.overriddenShadows);
    }

    public int hashCode() {
        return this.overriddenShadows.hashCode();
    }

    public static class Builder {
        private final ImmutableMap<String, String> defaultShadows;
        private final Map<String, ShadowInfo> overriddenShadows;

        public Builder() {
            this.defaultShadows = ImmutableMap.of();
            this.overriddenShadows = new HashMap<String, ShadowInfo>();
        }

        public Builder(ShadowMap shadowMap) {
            this.defaultShadows = shadowMap.defaultShadows;
            this.overriddenShadows = new HashMap<String, ShadowInfo>((Map<String, ShadowInfo>)shadowMap.overriddenShadows);
        }

        public Builder addShadowClasses(Class<?> ... shadowClasses) {
            for (Class<?> shadowClass : shadowClasses) {
                this.addShadowClass(shadowClass);
            }
            return this;
        }

        public Builder addShadowClasses(Collection<Class<?>> shadowClasses) {
            for (Class<?> shadowClass : shadowClasses) {
                this.addShadowClass(shadowClass);
            }
            return this;
        }

        public Builder addShadowClass(Class<?> shadowClass) {
            this.addShadowInfo(ShadowMap.obtainShadowInfo(shadowClass));
            return this;
        }

        public Builder addShadowClass(String realClassName, Class<?> shadowClass, boolean callThroughByDefault, boolean inheritImplementationMethods, boolean looseSignatures) {
            this.addShadowClass(realClassName, shadowClass.getName(), callThroughByDefault, inheritImplementationMethods, looseSignatures);
            return this;
        }

        public Builder addShadowClass(Class<?> realClass, Class<?> shadowClass, boolean callThroughByDefault, boolean inheritImplementationMethods, boolean looseSignatures) {
            this.addShadowClass(realClass.getName(), shadowClass.getName(), callThroughByDefault, inheritImplementationMethods, looseSignatures);
            return this;
        }

        public Builder addShadowClass(String realClassName, String shadowClassName, boolean callThroughByDefault, boolean inheritImplementationMethods, boolean looseSignatures) {
            this.addShadowInfo(new ShadowInfo(realClassName, shadowClassName, callThroughByDefault, inheritImplementationMethods, looseSignatures, -1, -1));
            return this;
        }

        private void addShadowInfo(ShadowInfo shadowInfo) {
            this.overriddenShadows.put(shadowInfo.shadowedClassName, shadowInfo);
        }

        public ShadowMap build() {
            return new ShadowMap((Map<String, String>)this.defaultShadows, this.overriddenShadows);
        }
    }
}

