/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.Interceptor;
import org.robolectric.internal.bytecode.MethodRef;
import org.robolectric.internal.bytecode.MethodSignature;
import org.robolectric.util.Function;

public class Interceptors {
    private final Map<MethodRef, Interceptor> interceptors = new HashMap<MethodRef, Interceptor>();

    public Interceptors(Interceptor ... interceptors) {
        this(Arrays.asList(interceptors));
    }

    public Interceptors(Collection<Interceptor> interceptorList) {
        for (Interceptor interceptor : interceptorList) {
            for (MethodRef methodRef : interceptor.getMethodRefs()) {
                this.interceptors.put(methodRef, interceptor);
            }
        }
    }

    public Collection<MethodRef> getAllMethodRefs() {
        return this.interceptors.keySet();
    }

    public Function<Object, Object> getInterceptionHandler(MethodSignature methodSignature) {
        Interceptor interceptor = this.findInterceptor(methodSignature.className, methodSignature.methodName);
        if (interceptor != null) {
            return interceptor.handle(methodSignature);
        }
        return Interceptor.returnDefaultValue(methodSignature);
    }

    public Interceptor findInterceptor(String className, String methodName) {
        Interceptor mh = this.interceptors.get(new MethodRef(className, methodName));
        if (mh == null) {
            mh = this.interceptors.get(new MethodRef(className, "*"));
        }
        return mh;
    }
}

