/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.robolectric.internal.bytecode.ClassDetails;
import org.robolectric.internal.bytecode.ClassInstrumentor;
import org.robolectric.internal.bytecode.ClassNodeProvider;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.ResourceProvider;
import org.robolectric.internal.bytecode.ShadowDecorator;
import org.robolectric.internal.bytecode.UrlResourceProvider;
import org.robolectric.util.Logger;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.Util;

public class SandboxClassLoader
extends URLClassLoader {
    private static final String DUMP_CLASSES_PROPERTY = "robolectric.dumpClassesDirectory";
    private static final AtomicInteger DUMP_CLASSES_COUNTER = new AtomicInteger();
    private final InstrumentationConfiguration config;
    private final ResourceProvider resourceProvider;
    private final ClassInstrumentor classInstrumentor;
    private final ClassNodeProvider classNodeProvider;
    private final String dumpClassesDirectory;
    private boolean isClosed;

    SandboxClassLoader(InstrumentationConfiguration config) {
        this(config, new UrlResourceProvider(new URL[0]), new ClassInstrumentor(new ShadowDecorator()));
    }

    @Inject
    public SandboxClassLoader(InstrumentationConfiguration config, ResourceProvider resourceProvider, ClassInstrumentor classInstrumentor) {
        this(Thread.currentThread().getContextClassLoader(), config, resourceProvider, classInstrumentor);
    }

    public SandboxClassLoader(ClassLoader erstwhileClassLoader, InstrumentationConfiguration config, ResourceProvider resourceProvider, ClassInstrumentor classInstrumentor) {
        super(SandboxClassLoader.getClassPathUrls(erstwhileClassLoader), erstwhileClassLoader);
        this.config = config;
        this.resourceProvider = resourceProvider;
        this.classInstrumentor = classInstrumentor;
        this.classNodeProvider = new ClassNodeProvider(){

            @Override
            protected byte[] getClassBytes(String internalClassName) throws ClassNotFoundException {
                return SandboxClassLoader.this.getByteCode(internalClassName);
            }
        };
        this.dumpClassesDirectory = System.getProperty(DUMP_CLASSES_PROPERTY, "");
    }

    private static URL[] getClassPathUrls(ClassLoader classloader) {
        if (classloader instanceof URLClassLoader) {
            return ((URLClassLoader)classloader).getURLs();
        }
        return SandboxClassLoader.parseJavaClassPath();
    }

    private static URL[] parseJavaClassPath() {
        ImmutableList.Builder urls = ImmutableList.builder();
        for (String entry : Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value())) {
            try {
                try {
                    urls.add((Object)new File(entry).toURI().toURL());
                }
                catch (SecurityException e) {
                    urls.add((Object)new URL("file", null, new File(entry).getAbsolutePath()));
                }
            }
            catch (MalformedURLException e) {
                Logger.strict((String)("malformed classpath entry: " + entry), (Throwable)e);
            }
        }
        return (URL[])urls.build().toArray((Object[])new URL[0]);
    }

    @Override
    public URL getResource(String name) {
        if (this.config.shouldAcquireResource(name)) {
            return this.resourceProvider.getResource(name);
        }
        URL fromParent = super.getResource(name);
        if (fromParent != null) {
            return fromParent;
        }
        return this.resourceProvider.getResource(name);
    }

    private InputStream getClassBytesAsStreamPreferringLocalUrls(String resName) {
        InputStream fromUrlsClassLoader = this.resourceProvider.getResourceAsStream(resName);
        if (fromUrlsClassLoader != null) {
            return fromUrlsClassLoader;
        }
        return super.getResourceAsStream(resName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<Object> loadedClass = this.findLoadedClass(name);
            if (loadedClass != null) {
                return loadedClass;
            }
            if (this.isClosed) {
                throw new ClassNotFoundException("This ClassLoader is closed");
            }
            loadedClass = this.config.shouldAcquire(name) ? (Class<Object>)PerfStatsCollector.getInstance().measure("load sandboxed class", () -> this.maybeInstrumentClass(name)) : this.getParent().loadClass(name);
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    protected Class<?> maybeInstrumentClass(String className) throws ClassNotFoundException {
        byte[] classBytes = this.getByteCode(className);
        ClassDetails classDetails = new ClassDetails(classBytes);
        if (this.config.shouldInstrument(classDetails)) {
            classBytes = this.classInstrumentor.instrument(classDetails, this.config, this.classNodeProvider);
            this.maybeDumpClassBytes(classDetails, classBytes);
        }
        this.ensurePackage(className);
        return this.defineClass(className, classBytes, 0, classBytes.length);
    }

    private void maybeDumpClassBytes(ClassDetails classDetails, byte[] classBytes) {
        if (!Strings.isNullOrEmpty((String)this.dumpClassesDirectory)) {
            String outputClassName = classDetails.getName() + "-robo-instrumented-" + DUMP_CLASSES_COUNTER.getAndIncrement();
            Path path = Paths.get(this.dumpClassesDirectory, outputClassName + ".class");
            try {
                Files.write(path, classBytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    protected byte[] getByteCode(String className) throws ClassNotFoundException {
        byte[] byArray;
        block9: {
            String classFilename = className.replace('.', '/') + ".class";
            InputStream classBytesStream = this.getClassBytesAsStreamPreferringLocalUrls(classFilename);
            try {
                if (classBytesStream == null) {
                    throw new ClassNotFoundException(className);
                }
                byArray = Util.readBytes((InputStream)classBytesStream);
                if (classBytesStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (classBytesStream != null) {
                        try {
                            classBytesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("couldn't load " + className, e);
                }
            }
            classBytesStream.close();
        }
        return byArray;
    }

    private void ensurePackage(String className) {
        String pckgName;
        Package pckg;
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex != -1 && (pckg = this.getPackage(pckgName = className.substring(0, lastDotIndex))) == null) {
            this.definePackage(pckgName, null, null, null, null, null, null, null);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.resourceProvider.close();
        this.isClosed = true;
    }
}

