/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.auto.service.AutoService;
import com.google.errorprone.annotations.Keep;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.ClassValueMap;
import org.robolectric.internal.bytecode.Interceptors;
import org.robolectric.internal.bytecode.MethodSignature;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowInfo;
import org.robolectric.internal.bytecode.ShadowMap;
import org.robolectric.sandbox.ShadowMatcher;
import org.robolectric.util.Function;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.reflector.Reflector;

@Priority(value=-2147483648)
@AutoService(value={ClassHandler.class})
public class ShadowWrangler
implements ClassHandler {
    public static final Function<Object, Object> DO_NOTHING_HANDLER = new Function<Object, Object>(){

        @Override
        public Object call(Class<?> theClass, Object value, Object[] params) {
            return null;
        }
    };
    public static final Method CALL_REAL_CODE = null;
    public static final MethodHandle DO_NOTHING = MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE));
    public static final Method DO_NOTHING_METHOD;
    private static final MethodHandles.Lookup LOOKUP;
    private static final Class<?>[] NO_ARGS;
    static final Object NO_SHADOW;
    private static final MethodHandle NO_SHADOW_HANDLE;
    private final ShadowMap shadowMap;
    private final Interceptors interceptors;
    private final ShadowMatcher shadowMatcher;
    private final MethodHandle reflectorHandle;
    private final ClassValueMap<ShadowInfo> cachedShadowInfos = new ClassValueMap<ShadowInfo>(){

        @Override
        protected ShadowInfo computeValue(Class<?> type) {
            return ShadowWrangler.this.shadowMap.getShadowInfo(type, ShadowWrangler.this.shadowMatcher);
        }
    };
    private final ClassValueMap<ShadowMetadata> cachedShadowMetadata = new ClassValueMap<ShadowMetadata>(){

        @Override
        @Nonnull
        protected ShadowMetadata computeValue(Class<?> type) {
            return new ShadowMetadata(type);
        }
    };

    public ShadowWrangler(ShadowMap shadowMap, ShadowMatcher shadowMatcher, Interceptors interceptors) {
        this.shadowMap = shadowMap;
        this.shadowMatcher = shadowMatcher;
        this.interceptors = interceptors;
        try {
            this.reflectorHandle = LOOKUP.findVirtual(ShadowWrangler.class, "injectReflectorObjectOn", MethodType.methodType(Void.TYPE, Object.class, Object.class)).bindTo(this);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Could not instantiate MethodHandle for ReflectorObject injection.", e);
        }
    }

    @Override
    public void classInitializing(Class clazz) {
        try {
            Method method = this.pickShadowMethod(clazz, "__staticInitializer__", NO_ARGS);
            if (method == DO_NOTHING_METHOD) {
                method = null;
            }
            if (method != null) {
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException(method.getDeclaringClass().getName() + "." + method.getName() + " is not static");
                }
                method.invoke(null, new Object[0]);
            } else {
                RobolectricInternals.performStaticInitialization(clazz);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MethodHandle findShadowMethodHandle(Class<?> definingClass, String name, MethodType methodType, boolean isStatic, boolean isNative) throws IllegalAccessException {
        return (MethodHandle)PerfStatsCollector.getInstance().measure("find shadow method handle", () -> {
            MethodHandle mh;
            MethodType actualType = isStatic ? methodType : methodType.dropParameterTypes(0, 1);
            Class<?>[] paramTypes = actualType.parameterArray();
            Method shadowMethod = this.pickShadowMethod(definingClass, name, paramTypes);
            if (shadowMethod == CALL_REAL_CODE) {
                ShadowInfo shadowInfo = this.getExactShadowInfo(definingClass);
                if (isNative && shadowInfo != null && shadowInfo.callNativeMethodsByDefault) {
                    try {
                        Method method = definingClass.getDeclaredMethod("$$robo$$" + name + "$nativeBinding", paramTypes);
                        method.setAccessible(true);
                        return LOOKUP.unreflect(method);
                    }
                    catch (NoSuchMethodException e) {
                        throw new LinkageError("Missing native binding method", e);
                    }
                }
                return null;
            }
            if (shadowMethod == DO_NOTHING_METHOD) {
                return DO_NOTHING;
            }
            shadowMethod.setAccessible(true);
            if (name.equals("__constructor__")) {
                if (Modifier.isStatic(shadowMethod.getModifiers())) {
                    throw new UnsupportedOperationException("static __constructor__ shadow methods are not supported");
                }
                mh = MethodHandles.privateLookupIn(shadowMethod.getDeclaringClass(), LOOKUP).unreflectSpecial(shadowMethod, shadowMethod.getDeclaringClass());
            } else {
                mh = LOOKUP.unreflect(shadowMethod);
            }
            if (!isStatic && Modifier.isStatic(shadowMethod.getModifiers())) {
                return MethodHandles.dropArguments(mh, 0, new Class[]{Object.class});
            }
            return mh;
        });
    }

    protected Method pickShadowMethod(Class<?> definingClass, String name, Class<?>[] paramTypes) {
        Class<?> shadowClass;
        ShadowInfo shadowInfo = this.getExactShadowInfo(definingClass);
        if (shadowInfo == null) {
            return CALL_REAL_CODE;
        }
        ClassLoader classLoader = definingClass.getClassLoader();
        try {
            shadowClass = Class.forName(shadowInfo.shadowClassName, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        Method method = this.findShadowMethod(definingClass, name, paramTypes, shadowInfo, shadowClass);
        if (method == null) {
            return shadowInfo.callThroughByDefault ? CALL_REAL_CODE : DO_NOTHING_METHOD;
        }
        return method;
    }

    private Method findShadowMethod(Class<?> definingClass, String name, Class<?>[] types, ShadowInfo shadowInfo, Class<?> shadowClass) {
        ShadowInfo shadowSuperclassInfo;
        Method method = this.findShadowMethodDeclaredOnClass(shadowClass, name, types, shadowInfo.looseSignatures);
        if (method != null) {
            return method;
        }
        Class<?> shadowSuperclass = shadowClass.getSuperclass();
        if (shadowSuperclass != null && !shadowSuperclass.equals(Object.class) && (shadowSuperclassInfo = ShadowMap.obtainShadowInfo(shadowSuperclass, true)) != null && shadowSuperclassInfo.isShadowOf(definingClass) && this.shadowMatcher.matches(shadowSuperclassInfo)) {
            method = this.findShadowMethod(definingClass, name, types, shadowSuperclassInfo, shadowSuperclass);
        }
        return method;
    }

    private Method findShadowMethodDeclaredOnClass(Class<?> shadowClass, String methodName, Class<?>[] paramClasses, boolean looseSignatures) {
        Method[] methods;
        Method foundMethod = null;
        for (Method method : methods = shadowClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != paramClasses.length || !Modifier.isPublic(method.getModifiers()) && !Modifier.isProtected(method.getModifiers()) || !this.shadowMatcher.matches(method)) continue;
            if (Arrays.equals(method.getParameterTypes(), paramClasses)) {
                foundMethod = method;
                break;
            }
            if (looseSignatures) {
                boolean allParameterTypesAreObject = true;
                for (Class<?> paramClass : method.getParameterTypes()) {
                    if (paramClass.equals(Object.class)) continue;
                    allParameterTypesAreObject = false;
                    break;
                }
                if (!allParameterTypesAreObject) continue;
                foundMethod = method;
                continue;
            }
            if (!this.parameterClassNameMatch(method, paramClasses)) continue;
            foundMethod = method;
        }
        if (foundMethod == null) {
            for (Method method : methods) {
                String mappedMethodName;
                Implementation implementation = method.getAnnotation(Implementation.class);
                if (implementation == null || (mappedMethodName = implementation.methodName().trim()).isEmpty() || !mappedMethodName.equals(methodName) || !this.shadowMatcher.matches(method) || !Arrays.equals(method.getParameterTypes(), paramClasses) && !this.parameterClassNameMatch(method, paramClasses)) continue;
                foundMethod = method;
                break;
            }
        }
        if (foundMethod != null) {
            foundMethod.setAccessible(true);
            return foundMethod;
        }
        return null;
    }

    private boolean parameterClassNameMatch(Method method, Class<?>[] paramClasses) {
        Parameter[] params = method.getParameters();
        if (params.length != paramClasses.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getType().equals(paramClasses[i])) continue;
            if (!params[i].getType().equals(Object.class)) {
                return false;
            }
            ClassName className = params[i].getAnnotation(ClassName.class);
            if (className != null && className.value().equals(paramClasses[i].getName())) continue;
            return false;
        }
        return true;
    }

    public Object intercept(String signature, Object instance, Object[] params, Class theClass) throws Throwable {
        MethodSignature methodSignature = MethodSignature.parse(signature);
        return this.interceptors.getInterceptionHandler(methodSignature).call(theClass, instance, params);
    }

    @Override
    public <T extends Throwable> T stripStackTrace(T throwable) {
        StackTraceElement[] elements = throwable.getStackTrace();
        if (elements != null) {
            ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
            String previousClassName = null;
            String previousMethodName = null;
            String previousFileName = null;
            for (StackTraceElement stackTraceElement : elements) {
                String methodName = stackTraceElement.getMethodName();
                String className = stackTraceElement.getClassName();
                String fileName = stackTraceElement.getFileName();
                if (methodName.equals(previousMethodName) && className.equals(previousClassName) && fileName != null && fileName.equals(previousFileName) && stackTraceElement.getLineNumber() < 0) continue;
                if (methodName.startsWith("$$robo$$")) {
                    methodName = methodName.substring(methodName.indexOf(36, "$$robo$$".length() + 1) + 1);
                    stackTraceElement = new StackTraceElement(className, methodName, stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
                }
                if (className.startsWith("sun.reflect.") || className.startsWith("java.lang.reflect.")) continue;
                stackTrace.add(stackTraceElement);
                previousClassName = className;
                previousMethodName = methodName;
                previousFileName = fileName;
            }
            throwable.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        }
        return throwable;
    }

    private ShadowMetadata getShadowMetadata(Class<?> shadowClass) {
        return this.cachedShadowMetadata.get(shadowClass);
    }

    @Override
    public MethodHandle getShadowCreator(Class<?> theClass) {
        ShadowInfo shadowInfo = this.getShadowInfo(theClass);
        if (shadowInfo == null) {
            return MethodHandles.dropArguments(NO_SHADOW_HANDLE, 0, new Class[]{theClass});
        }
        String shadowClassName = shadowInfo.shadowClassName;
        try {
            Class<?> shadowClass = Class.forName(shadowClassName, false, theClass.getClassLoader());
            ShadowMetadata shadowMetadata = this.getShadowMetadata(shadowClass);
            MethodHandle mh = MethodHandles.identity(shadowClass);
            mh = MethodHandles.dropArguments(mh, 1, new Class[]{theClass});
            for (Field field : shadowMetadata.realObjectFields) {
                MethodHandle setter = LOOKUP.unreflectSetter(field);
                MethodType setterType = mh.type().changeReturnType(Void.TYPE);
                mh = MethodHandles.foldArguments(mh, setter.asType(setterType));
            }
            MethodHandle classHandle = this.reflectorHandle.asType(this.reflectorHandle.type().changeParameterType(0, shadowClass).changeParameterType(1, theClass));
            mh = MethodHandles.foldArguments(mh, classHandle);
            mh = MethodHandles.foldArguments(mh, LOOKUP.unreflectConstructor(shadowMetadata.constructor));
            return mh;
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException("Could not instantiate shadow " + shadowClassName + " for " + theClass, e);
        }
    }

    @Keep
    private void injectReflectorObjectOn(Object shadow, Object instance) {
        ShadowMetadata shadowMetadata = this.getShadowMetadata(shadow.getClass());
        for (Field reflectorObjectField : shadowMetadata.reflectorObjectFields) {
            ShadowWrangler.setField(shadow, Reflector.reflector(reflectorObjectField.getType(), (Object)instance), reflectorObjectField);
        }
    }

    private ShadowInfo getShadowInfo(Class<?> clazz) {
        ShadowInfo shadowInfo = null;
        while (shadowInfo == null && clazz != null) {
            shadowInfo = this.getExactShadowInfo(clazz);
            clazz = clazz.getSuperclass();
        }
        return shadowInfo;
    }

    private ShadowInfo getExactShadowInfo(Class<?> clazz) {
        return this.cachedShadowInfos.get(clazz);
    }

    private static void setField(Object target, Object value, Field realObjectField) {
        try {
            realObjectField.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void doNothing() {
    }

    static {
        try {
            DO_NOTHING_METHOD = ShadowWrangler.class.getDeclaredMethod("doNothing", new Class[0]);
            DO_NOTHING_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        LOOKUP = MethodHandles.lookup();
        NO_ARGS = new Class[0];
        NO_SHADOW = new Object();
        NO_SHADOW_HANDLE = MethodHandles.constant(Object.class, NO_SHADOW);
    }

    private static class ShadowMetadata {
        final Constructor<?> constructor;
        final List<Field> realObjectFields = new ArrayList<Field>();
        final List<Field> reflectorObjectFields = new ArrayList<Field>();

        public ShadowMetadata(Class<?> shadowClass) {
            try {
                this.constructor = shadowClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Missing public empty constructor on " + shadowClass, e);
            }
            while (shadowClass != null) {
                for (Field field : shadowClass.getDeclaredFields()) {
                    if (field.isAnnotationPresent(RealObject.class)) {
                        if (Modifier.isStatic(field.getModifiers())) {
                            String message = "@RealObject must be on a non-static field, " + shadowClass;
                            System.err.println(message);
                            throw new IllegalArgumentException(message);
                        }
                        field.setAccessible(true);
                        this.realObjectFields.add(field);
                    }
                    if (!field.isAnnotationPresent(ReflectorObject.class)) continue;
                    if (Modifier.isStatic(field.getModifiers())) {
                        String message = "@ReflectorObject must be on a non-static field, " + shadowClass;
                        System.err.println(message);
                        throw new IllegalArgumentException(message);
                    }
                    field.setAccessible(true);
                    this.reflectorObjectFields.add(field);
                }
                shadowClass = shadowClass.getSuperclass();
            }
        }
    }
}

