/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.robolectric.annotation.Implements;
import org.robolectric.internal.ShadowProvider;
import org.robolectric.internal.bytecode.ShadowInfo;
import org.robolectric.shadow.api.ShadowPicker;

public class ShadowMap {
    static final ShadowMap EMPTY = new ShadowMap((ImmutableMap<String, String>)ImmutableMap.of(), (Map<String, ShadowInfo>)ImmutableMap.of());
    private final ImmutableMap<String, String> defaultShadows;
    private final ImmutableMap<String, ShadowInfo> overriddenShadows;
    private final ImmutableMap<String, String> shadowPickers;

    public static ShadowMap createFromShadowProviders(Iterable<ShadowProvider> shadowProviders) {
        HashMap shadowMap = new HashMap();
        HashMap shadowPickerMap = new HashMap();
        TreeSet<ShadowProvider> sortedProviders = new TreeSet<ShadowProvider>(Comparator.comparing(shadowProvider -> shadowProvider.getClass().getPackage().getName()));
        Iterables.addAll(sortedProviders, shadowProviders);
        for (ShadowProvider provider : sortedProviders) {
            shadowMap.putAll(provider.getShadowMap());
            shadowPickerMap.putAll(provider.getShadowPickerMap());
        }
        return new ShadowMap((ImmutableMap<String, String>)ImmutableMap.copyOf(shadowMap), Collections.emptyMap(), (Map<String, String>)ImmutableMap.copyOf(shadowPickerMap));
    }

    ShadowMap(ImmutableMap<String, String> defaultShadows, Map<String, ShadowInfo> overriddenShadows) {
        this(defaultShadows, overriddenShadows, Collections.emptyMap());
    }

    private ShadowMap(ImmutableMap<String, String> defaultShadows, Map<String, ShadowInfo> overriddenShadows, Map<String, String> shadowPickers) {
        this.defaultShadows = defaultShadows;
        this.overriddenShadows = ImmutableMap.copyOf(overriddenShadows);
        this.shadowPickers = ImmutableMap.copyOf(shadowPickers);
    }

    public ShadowInfo getShadowInfo(Class<?> clazz, int apiLevel) {
        String instrumentedClassName = clazz.getName();
        ShadowInfo shadowInfo = (ShadowInfo)this.overriddenShadows.get((Object)instrumentedClassName);
        if (shadowInfo == null) {
            shadowInfo = this.checkShadowPickers(instrumentedClassName, clazz);
        }
        if (shadowInfo == null && clazz.getClassLoader() != null) {
            try {
                String shadowName = (String)this.defaultShadows.get((Object)clazz.getCanonicalName());
                if (shadowName != null) {
                    Class<?> shadowClass = clazz.getClassLoader().loadClass(shadowName);
                    shadowInfo = ShadowMap.obtainShadowInfo(shadowClass);
                    if (!shadowInfo.shadowedClassName.equals(instrumentedClassName)) {
                        shadowInfo = null;
                    }
                }
            }
            catch (ClassNotFoundException | IncompatibleClassChangeError e) {
                return null;
            }
        }
        if (shadowInfo != null && !shadowInfo.supportsSdk(apiLevel)) {
            return null;
        }
        return shadowInfo;
    }

    private ShadowInfo checkShadowPickers(String instrumentedClassName, Class<?> clazz) {
        String shadowPickerClassName = (String)this.shadowPickers.get((Object)instrumentedClassName);
        if (shadowPickerClassName == null) {
            return null;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        try {
            Class<?> shadowPickerClass = classLoader.loadClass(shadowPickerClassName);
            ShadowPicker shadowPicker = (ShadowPicker)shadowPickerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class selectedShadowClass = shadowPicker.pickShadowClass();
            if (selectedShadowClass == null) {
                return ShadowMap.obtainShadowInfo(Object.class, true);
            }
            ShadowInfo shadowInfo = ShadowMap.obtainShadowInfo(selectedShadowClass);
            if (!shadowInfo.shadowedClassName.equals(instrumentedClassName)) {
                throw new IllegalArgumentException("Implemented class for " + selectedShadowClass.getName() + " (" + shadowInfo.shadowedClassName + ") != " + instrumentedClassName);
            }
            return shadowInfo;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to resolve shadow picker for " + instrumentedClassName, e);
        }
    }

    public static ShadowInfo obtainShadowInfo(Class<?> clazz) {
        return ShadowMap.obtainShadowInfo(clazz, false);
    }

    static ShadowInfo obtainShadowInfo(Class<?> clazz, boolean mayBeNonShadow) {
        Implements annotation = clazz.getAnnotation(Implements.class);
        if (annotation == null) {
            if (mayBeNonShadow) {
                return null;
            }
            throw new IllegalArgumentException(clazz + " is not annotated with @Implements");
        }
        String className = annotation.className();
        if (className.isEmpty()) {
            className = annotation.value().getName();
        }
        return new ShadowInfo(className, clazz.getName(), annotation);
    }

    public Set<String> getInvalidatedClasses(ShadowMap previous) {
        if (this == previous && this.shadowPickers.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<String, ShadowInfo> invalidated = new HashMap<String, ShadowInfo>((Map<String, ShadowInfo>)this.overriddenShadows);
        for (Map.Entry entry : previous.overriddenShadows.entrySet()) {
            String className = (String)entry.getKey();
            ShadowInfo previousConfig = (ShadowInfo)entry.getValue();
            ShadowInfo currentConfig = (ShadowInfo)invalidated.get(className);
            if (currentConfig == null) {
                invalidated.put(className, previousConfig);
                continue;
            }
            if (!previousConfig.equals(currentConfig)) continue;
            invalidated.remove(className);
        }
        return invalidated.keySet();
    }

    @Deprecated
    public static String convertToShadowName(String className) {
        String shadowClassName = "org.robolectric.shadows.Shadow" + className.substring(className.lastIndexOf(".") + 1);
        shadowClassName = shadowClassName.replaceAll("\\$", "\\$Shadow");
        return shadowClassName;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShadowMap)) {
            return false;
        }
        ShadowMap shadowMap = (ShadowMap)o;
        return this.overriddenShadows.equals(shadowMap.overriddenShadows);
    }

    public int hashCode() {
        return this.overriddenShadows.hashCode();
    }

    public static class Builder {
        private final ImmutableMap<String, String> defaultShadows;
        private final Map<String, ShadowInfo> overriddenShadows;
        private final Map<String, String> shadowPickers;

        public Builder() {
            this.defaultShadows = ImmutableMap.of();
            this.overriddenShadows = new HashMap<String, ShadowInfo>();
            this.shadowPickers = new HashMap<String, String>();
        }

        public Builder(ShadowMap shadowMap) {
            this.defaultShadows = shadowMap.defaultShadows;
            this.overriddenShadows = new HashMap<String, ShadowInfo>((Map<String, ShadowInfo>)shadowMap.overriddenShadows);
            this.shadowPickers = new HashMap<String, String>((Map<String, String>)shadowMap.shadowPickers);
        }

        public Builder addShadowClasses(Class<?> ... shadowClasses) {
            for (Class<?> shadowClass : shadowClasses) {
                this.addShadowClass(shadowClass);
            }
            return this;
        }

        Builder addShadowClass(Class<?> shadowClass) {
            this.addShadowInfo(ShadowMap.obtainShadowInfo(shadowClass));
            return this;
        }

        Builder addShadowClass(String realClassName, String shadowClassName, boolean callThroughByDefault, boolean looseSignatures) {
            this.addShadowInfo(new ShadowInfo(realClassName, shadowClassName, callThroughByDefault, looseSignatures, -1, -1, null));
            return this;
        }

        private void addShadowInfo(ShadowInfo shadowInfo) {
            this.overriddenShadows.put(shadowInfo.shadowedClassName, shadowInfo);
            if (shadowInfo.hasShadowPicker()) {
                this.shadowPickers.put(shadowInfo.shadowedClassName, shadowInfo.getShadowPickerClass().getName());
            }
        }

        public ShadowMap build() {
            return new ShadowMap(this.defaultShadows, this.overriddenShadows, this.shadowPickers);
        }
    }
}

