/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.robolectric.internal.bytecode.ClassNodeProvider;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;

public class MutableClass {
    public final ClassNode classNode;
    final InstrumentationConfiguration config;
    final ClassNodeProvider classNodeProvider;
    final boolean containsStubs;
    final String internalClassName;
    private final String className;
    final Type classType;
    final ImmutableSet<String> foundMethods;

    MutableClass(ClassNode classNode, InstrumentationConfiguration config, ClassNodeProvider classNodeProvider) {
        this.classNode = classNode;
        this.config = config;
        this.classNodeProvider = classNodeProvider;
        this.internalClassName = classNode.name;
        this.className = classNode.name.replace('/', '.');
        this.classType = Type.getObjectType((String)this.internalClassName);
        this.containsStubs = config.containsStubs(this.className);
        ArrayList<String> foundMethods = new ArrayList<String>(classNode.methods.size());
        for (MethodNode methodNode : this.getMethods()) {
            foundMethods.add(methodNode.name + methodNode.desc);
        }
        this.foundMethods = ImmutableSet.copyOf(foundMethods);
    }

    public boolean isInterface() {
        return (this.classNode.access & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.classNode.access & 0x2000) != 0;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        String internalName = "L" + annotationClass.getName().replace('.', '/') + ";";
        if (this.classNode.visibleAnnotations == null) {
            return false;
        }
        for (Object visibleAnnotation : this.classNode.visibleAnnotations) {
            AnnotationNode annotationNode = (AnnotationNode)visibleAnnotation;
            if (!annotationNode.desc.equals(internalName)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.className;
    }

    public Iterable<? extends MethodNode> getMethods() {
        return new ArrayList(this.classNode.methods);
    }

    public void addMethod(MethodNode methodNode) {
        this.classNode.methods.add(methodNode);
    }

    public List<FieldNode> getFields() {
        return this.classNode.fields;
    }

    public void addField(int index, FieldNode fieldNode) {
        this.classNode.fields.add(index, fieldNode);
    }

    public void addInterface(String internalName) {
        this.classNode.interfaces.add(internalName);
    }
}

