/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.inject.Inject;
import org.robolectric.internal.bytecode.ClassInstrumentor;
import org.robolectric.internal.bytecode.ClassNodeProvider;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.MutableClass;
import org.robolectric.internal.bytecode.OldClassInstrumentor;
import org.robolectric.internal.bytecode.ResourceProvider;
import org.robolectric.internal.bytecode.ShadowDecorator;
import org.robolectric.internal.bytecode.UrlResourceProvider;
import org.robolectric.util.Logger;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Util;

public class SandboxClassLoader
extends URLClassLoader {
    private final ClassLoader erstwhileClassLoader;
    private final InstrumentationConfiguration config;
    private final ResourceProvider resourceProvider;
    private final ClassInstrumentor classInstrumentor;
    private final ClassNodeProvider classNodeProvider;

    SandboxClassLoader(InstrumentationConfiguration config) {
        this(config, new UrlResourceProvider(new URL[0]), new OldClassInstrumentor(new ShadowDecorator()));
    }

    @Inject
    public SandboxClassLoader(InstrumentationConfiguration config, ResourceProvider resourceProvider, ClassInstrumentor classInstrumentor) {
        this(Thread.currentThread().getContextClassLoader(), config, resourceProvider, classInstrumentor);
    }

    public SandboxClassLoader(ClassLoader erstwhileClassLoader, InstrumentationConfiguration config, ResourceProvider resourceProvider, ClassInstrumentor classInstrumentor) {
        super(SandboxClassLoader.getClassPathUrls(erstwhileClassLoader), erstwhileClassLoader.getParent());
        this.erstwhileClassLoader = erstwhileClassLoader;
        this.config = config;
        this.resourceProvider = resourceProvider;
        this.classInstrumentor = classInstrumentor;
        this.classNodeProvider = new ClassNodeProvider(){

            @Override
            protected byte[] getClassBytes(String internalClassName) throws ClassNotFoundException {
                return SandboxClassLoader.this.getByteCode(internalClassName);
            }
        };
    }

    private static URL[] getClassPathUrls(ClassLoader classloader) {
        if (classloader instanceof URLClassLoader) {
            return ((URLClassLoader)classloader).getURLs();
        }
        return SandboxClassLoader.parseJavaClassPath();
    }

    private static URL[] parseJavaClassPath() {
        ImmutableList.Builder urls = ImmutableList.builder();
        for (String entry : Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value())) {
            try {
                try {
                    urls.add((Object)new File(entry).toURI().toURL());
                }
                catch (SecurityException e) {
                    urls.add((Object)new URL("file", null, new File(entry).getAbsolutePath()));
                }
            }
            catch (MalformedURLException e) {
                Logger.strict((String)("malformed classpath entry: " + entry), (Throwable)e);
            }
        }
        return (URL[])urls.build().toArray((Object[])new URL[0]);
    }

    @Override
    public URL getResource(String name) {
        if (this.config.shouldAcquireResource(name)) {
            return this.resourceProvider.getResource(name);
        }
        URL fromParent = super.getResource(name);
        if (fromParent != null) {
            return fromParent;
        }
        return this.resourceProvider.getResource(name);
    }

    private InputStream getClassBytesAsStreamPreferringLocalUrls(String resName) {
        InputStream fromUrlsClassLoader = this.resourceProvider.getResourceAsStream(resName);
        if (fromUrlsClassLoader != null) {
            return fromUrlsClassLoader;
        }
        return super.getResourceAsStream(resName);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.config.shouldAcquire(name)) {
            return (Class)PerfStatsCollector.getInstance().measure("load sandboxed class", () -> this.maybeInstrumentClass(name));
        }
        return this.erstwhileClassLoader.loadClass(name);
    }

    protected Class<?> maybeInstrumentClass(String className) throws ClassNotFoundException {
        byte[] origClassBytes = this.getByteCode(className);
        MutableClass mutableClass = (MutableClass)PerfStatsCollector.getInstance().measure("analyze class", () -> this.classInstrumentor.analyzeClass(origClassBytes, this.config, this.classNodeProvider));
        try {
            byte[] bytes = this.config.shouldInstrument(mutableClass) ? (byte[])PerfStatsCollector.getInstance().measure("instrument class", () -> this.classInstrumentor.instrumentToBytes(mutableClass)) : this.postProcessUninstrumentedClass(mutableClass, origClassBytes);
            this.ensurePackage(className);
            return this.defineClass(className, bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("couldn't load " + className, e);
        }
        catch (OutOfMemoryError e) {
            System.err.println("[ERROR] couldn't load " + className + " in " + this);
            throw e;
        }
    }

    protected byte[] postProcessUninstrumentedClass(MutableClass mutableClass, byte[] origClassBytes) {
        return origClassBytes;
    }

    @Override
    protected Package getPackage(String name) {
        Package aPackage = super.getPackage(name);
        if (aPackage != null) {
            return aPackage;
        }
        return (Package)ReflectionHelpers.callInstanceMethod((Object)this.erstwhileClassLoader, (String)"getPackage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)name)});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getByteCode(String className) throws ClassNotFoundException {
        String classFilename = className.replace('.', '/') + ".class";
        try (InputStream classBytesStream = this.getClassBytesAsStreamPreferringLocalUrls(classFilename);){
            if (classBytesStream == null) {
                throw new ClassNotFoundException(className);
            }
            byte[] byArray = Util.readBytes((InputStream)classBytesStream);
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("couldn't load " + className, e);
        }
    }

    private void ensurePackage(String className) {
        String pckgName;
        Package pckg;
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex != -1 && (pckg = this.getPackage(pckgName = className.substring(0, lastDotIndex))) == null) {
            this.definePackage(pckgName, null, null, null, null, null, null, null);
        }
    }
}

