/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.robolectric.internal.bytecode.ClassNodeProvider;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.InstrumentingClassWriter;
import org.robolectric.internal.bytecode.MutableClass;
import org.robolectric.internal.bytecode.RobolectricGeneratorAdapter;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowImpl;
import org.robolectric.util.PerfStatsCollector;

public abstract class ClassInstrumentor {
    private static final String ROBO_INIT_METHOD_NAME = "$$robo$init";
    private static final String DUMP_CLASSES_PROPERTY = "robolectric.dumpClassesDirectory";
    private static final AtomicInteger DUMP_CLASSES_COUNTER = new AtomicInteger();
    static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final ShadowImpl SHADOW_IMPL = new ShadowImpl();
    final Decorator decorator;
    final String dumpClassesDirectory;

    protected ClassInstrumentor(Decorator decorator) {
        this.decorator = decorator;
        this.dumpClassesDirectory = System.getProperty(DUMP_CLASSES_PROPERTY, "");
    }

    private MutableClass analyzeClass(byte[] origClassBytes, final InstrumentationConfiguration config, ClassNodeProvider classNodeProvider) {
        ClassNode classNode = new ClassNode(this, 262144){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor methodVisitor = super.visitMethod(access, name, config.remapParams(desc), signature, exceptions);
                return new JSRInlinerAdapter(methodVisitor, access, name, desc, signature, exceptions);
            }
        };
        ClassReader classReader = new ClassReader(origClassBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return new MutableClass(classNode, config, classNodeProvider);
    }

    byte[] instrumentToBytes(final MutableClass mutableClass) {
        this.instrument(mutableClass);
        ClassNode classNode = mutableClass.classNode;
        InstrumentingClassWriter writer = new InstrumentingClassWriter(mutableClass.classNodeProvider, classNode);
        Remapper remapper = new Remapper(this){

            public String map(String internalName) {
                return mutableClass.config.mappedTypeName(internalName);
            }
        };
        ClassRemapper visitor = new ClassRemapper((ClassVisitor)writer, remapper);
        classNode.accept((ClassVisitor)visitor);
        byte[] classBytes = writer.toByteArray();
        if (!Strings.isNullOrEmpty((String)this.dumpClassesDirectory)) {
            String string = mutableClass.getName();
            int n = DUMP_CLASSES_COUNTER.getAndIncrement();
            String outputClassName = new StringBuilder(30 + String.valueOf(string).length()).append(string).append("-robo-instrumented-").append(n).toString();
            Path path = Paths.get(this.dumpClassesDirectory, String.valueOf(outputClassName).concat(".class"));
            try {
                Files.write(path, classBytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return classBytes;
    }

    public byte[] instrument(byte[] origBytes, InstrumentationConfiguration config, ClassNodeProvider classNodeProvider) {
        PerfStatsCollector perfStats = PerfStatsCollector.getInstance();
        MutableClass mutableClass = (MutableClass)perfStats.measure("analyze class", () -> this.analyzeClass(origBytes, config, classNodeProvider));
        byte[] instrumentedBytes = (byte[])perfStats.measure("instrument class", () -> this.instrumentToBytes(mutableClass));
        this.recordPackageStats(perfStats, mutableClass);
        return instrumentedBytes;
    }

    private void recordPackageStats(PerfStatsCollector perfStats, MutableClass mutableClass) {
        String className = mutableClass.getName();
        int i = className.indexOf(46);
        while (i != -1) {
            String string = String.valueOf(className.substring(0, i));
            perfStats.incrementCount(string.length() != 0 ? "instrument package ".concat(string) : new String("instrument package "));
            i = className.indexOf(46, i + 1);
        }
    }

    public void instrument(MutableClass mutableClass) {
        try {
            if (mutableClass.isInterface()) {
                return;
            }
            ClassInstrumentor.makeClassPublic(mutableClass.classNode);
            if ((mutableClass.classNode.access & 0x10) == 16) {
                mutableClass.classNode.visitAnnotation("Lcom/google/errorprone/annotations/DoNotMock;", true).visit("value", (Object)"This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.");
            }
            mutableClass.classNode.access &= 0xFFFFFFEF;
            mutableClass.classNode.version = Math.max(mutableClass.classNode.version, 51);
            this.instrumentMethods(mutableClass);
            ClassInstrumentor.addNoArgsConstructor(mutableClass);
            this.addDirectCallConstructor(mutableClass);
            this.addRoboInitMethod(mutableClass);
            this.decorator.decorate(mutableClass);
            ClassInstrumentor.removeFinalFromFields(mutableClass);
        }
        catch (Exception e) {
            String string = String.valueOf(mutableClass.getName());
            throw new RuntimeException(string.length() != 0 ? "failed to instrument ".concat(string) : new String("failed to instrument "), e);
        }
    }

    private void instrumentMethods(MutableClass mutableClass) {
        for (MethodNode methodNode : mutableClass.getMethods()) {
            this.rewriteMethodBody(mutableClass, methodNode);
            if (methodNode.name.equals("<clinit>")) {
                methodNode.name = "__staticInitializer__";
                mutableClass.addMethod(ClassInstrumentor.generateStaticInitializerNotifierMethod(mutableClass));
                continue;
            }
            if (methodNode.name.equals("<init>")) {
                this.instrumentConstructor(mutableClass, methodNode);
                continue;
            }
            if (ClassInstrumentor.isSyntheticAccessorMethod(methodNode) || Modifier.isAbstract(methodNode.access)) continue;
            this.instrumentNormalMethod(mutableClass, methodNode);
        }
    }

    private static void addNoArgsConstructor(MutableClass mutableClass) {
        if (!mutableClass.foundMethods.contains((Object)"<init>()V")) {
            MethodNode defaultConstructor = new MethodNode(4097, "<init>", "()V", "()V", null);
            RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(defaultConstructor);
            generator.loadThis();
            generator.visitMethodInsn(183, mutableClass.classNode.superName, "<init>", "()V", false);
            generator.loadThis();
            generator.invokeVirtual(mutableClass.classType, new Method(ROBO_INIT_METHOD_NAME, "()V"));
            generator.returnValue();
            mutableClass.addMethod(defaultConstructor);
        }
    }

    protected abstract void addDirectCallConstructor(MutableClass var1);

    private void addRoboInitMethod(MutableClass mutableClass) {
        MethodNode initMethodNode = new MethodNode(4100, ROBO_INIT_METHOD_NAME, "()V", null, null);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(initMethodNode);
        Label alreadyInitialized = new Label();
        generator.loadThis();
        generator.getField(mutableClass.classType, "__robo_data__", OBJECT_TYPE);
        generator.ifNonNull(alreadyInitialized);
        generator.loadThis();
        generator.loadThis();
        this.writeCallToInitializing(mutableClass, generator);
        generator.putField(mutableClass.classType, "__robo_data__", OBJECT_TYPE);
        generator.mark(alreadyInitialized);
        generator.returnValue();
        mutableClass.addMethod(initMethodNode);
    }

    protected abstract void writeCallToInitializing(MutableClass var1, RobolectricGeneratorAdapter var2);

    private static void removeFinalFromFields(MutableClass mutableClass) {
        for (FieldNode fieldNode : mutableClass.getFields()) {
            fieldNode.access &= 0xFFFFFFEF;
        }
    }

    private static boolean isSyntheticAccessorMethod(MethodNode method) {
        return (method.access & 0x1000) != 0;
    }

    private void instrumentConstructor(MutableClass mutableClass, MethodNode method) {
        this.makeMethodPrivate(method);
        InsnList callSuper = ClassInstrumentor.extractCallToSuperConstructor(mutableClass, method);
        method.name = ClassInstrumentor.directMethodName(mutableClass, "__constructor__");
        mutableClass.addMethod(this.redirectorMethod(mutableClass, method, "__constructor__"));
        String[] exceptions = this.exceptionArray(method);
        MethodNode initMethodNode = new MethodNode(method.access, "<init>", method.desc, method.signature, exceptions);
        this.makeMethodPublic(initMethodNode);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(initMethodNode);
        initMethodNode.instructions = callSuper;
        generator.loadThis();
        generator.invokeVirtual(mutableClass.classType, new Method(ROBO_INIT_METHOD_NAME, "()V"));
        this.generateClassHandlerCall(mutableClass, method, "__constructor__", generator);
        generator.endMethod();
        mutableClass.addMethod(initMethodNode);
    }

    private static InsnList extractCallToSuperConstructor(MutableClass mutableClass, MethodNode ctor) {
        InsnList removedInstructions = new InsnList();
        int startIndex = 0;
        AbstractInsnNode[] insns = ctor.instructions.toArray();
        block5: for (int i = 0; i < insns.length; ++i) {
            AbstractInsnNode node = insns[i];
            switch (node.getOpcode()) {
                case 25: {
                    VarInsnNode vnode = (VarInsnNode)node;
                    if (vnode.var != 0) continue block5;
                    startIndex = i;
                    continue block5;
                }
                case 183: {
                    MethodInsnNode mnode = (MethodInsnNode)node;
                    if (!mnode.owner.equals(mutableClass.internalClassName) && !mnode.owner.equals(mutableClass.classNode.superName)) continue block5;
                    if (!"<init>".equals(mnode.name)) {
                        throw new AssertionError((Object)"Invalid MethodInsnNode name");
                    }
                    while (startIndex <= i) {
                        ctor.instructions.remove(insns[startIndex]);
                        removedInstructions.add(insns[startIndex]);
                        ++startIndex;
                    }
                    return removedInstructions;
                }
                case 191: {
                    ctor.visitCode();
                    ctor.visitInsn(177);
                    ctor.visitEnd();
                    return removedInstructions;
                }
            }
        }
        String string = ctor.name;
        String string2 = ctor.desc;
        throw new RuntimeException(new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length()).append("huh? ").append(string).append(string2).toString());
    }

    protected void instrumentNormalMethod(MutableClass mutableClass, MethodNode method) {
        if ((method.access & 0x400) == 0) {
            method.access |= 0x10;
        }
        if ((method.access & 0x100) != 0) {
            this.instrumentNativeMethod(mutableClass, method);
        }
        String originalName = method.name;
        method.name = ClassInstrumentor.directMethodName(mutableClass, originalName);
        MethodNode delegatorMethodNode = new MethodNode(method.access, originalName, method.desc, method.signature, this.exceptionArray(method));
        delegatorMethodNode.visibleAnnotations = method.visibleAnnotations;
        delegatorMethodNode.access &= 0xFFFFFAEF;
        this.makeMethodPrivate(method);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(delegatorMethodNode);
        this.generateClassHandlerCall(mutableClass, method, originalName, generator);
        generator.endMethod();
        mutableClass.addMethod(delegatorMethodNode);
    }

    protected void instrumentNativeMethod(MutableClass mutableClass, MethodNode method) {
        method.access &= 0xFFFFFEFF;
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(method);
        Type returnType = generator.getReturnType();
        generator.pushDefaultReturnValueToStack(returnType);
        generator.returnValue();
    }

    private static String directMethodName(MutableClass mutableClass, String originalName) {
        return SHADOW_IMPL.directMethodName(mutableClass.getName(), originalName);
    }

    private MethodNode redirectorMethod(MutableClass mutableClass, MethodNode method, String newName) {
        MethodNode redirector = new MethodNode(262144, newName, method.desc, method.signature, this.exceptionArray(method));
        redirector.access = method.access & 0xFFFFFAEF;
        this.makeMethodPrivate(redirector);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(redirector);
        generator.invokeMethod(mutableClass.internalClassName, method);
        generator.returnValue();
        return redirector;
    }

    protected String[] exceptionArray(MethodNode method) {
        List exceptions = method.exceptions;
        return exceptions.toArray(new String[exceptions.size()]);
    }

    private void rewriteMethodBody(MutableClass mutableClass, MethodNode callingMethod) {
        ListIterator instructions = callingMethod.instructions.iterator();
        while (instructions.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)instructions.next();
            switch (node.getOpcode()) {
                case 187: {
                    TypeInsnNode newInsnNode = (TypeInsnNode)node;
                    newInsnNode.desc = mutableClass.config.mappedTypeName(newInsnNode.desc);
                    break;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    FieldInsnNode fieldInsnNode = (FieldInsnNode)node;
                    fieldInsnNode.desc = mutableClass.config.mappedTypeName(fieldInsnNode.desc);
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    MethodInsnNode targetMethod = (MethodInsnNode)node;
                    targetMethod.desc = mutableClass.config.remapParams(targetMethod.desc);
                    if (ClassInstrumentor.isGregorianCalendarBooleanConstructor(targetMethod)) {
                        ClassInstrumentor.replaceGregorianCalendarBooleanConstructor(instructions, targetMethod);
                        break;
                    }
                    if (!mutableClass.config.shouldIntercept(targetMethod)) break;
                    this.interceptInvokeVirtualMethod(mutableClass, instructions, targetMethod);
                    break;
                }
                case 186: {
                    break;
                }
            }
        }
    }

    private static boolean isGregorianCalendarBooleanConstructor(MethodInsnNode targetMethod) {
        return targetMethod.owner.equals("java/util/GregorianCalendar") && targetMethod.name.equals("<init>") && targetMethod.desc.equals("(Z)V");
    }

    private static void replaceGregorianCalendarBooleanConstructor(ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
        instructions.remove();
        instructions.add((AbstractInsnNode)new InsnNode(87));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, targetMethod.owner, targetMethod.name, "(III)V", targetMethod.itf));
    }

    protected abstract void interceptInvokeVirtualMethod(MutableClass var1, ListIterator<AbstractInsnNode> var2, MethodInsnNode var3);

    private static void makeClassPublic(ClassNode clazz) {
        clazz.access = (clazz.access | 1) & 0xFFFFFFF9;
    }

    protected void makeMethodPublic(MethodNode method) {
        method.access = (method.access | 1) & 0xFFFFFFF9;
    }

    protected void makeMethodPrivate(MethodNode method) {
        method.access = (method.access | 2) & 0xFFFFFFFA;
    }

    private static MethodNode generateStaticInitializerNotifierMethod(MutableClass mutableClass) {
        MethodNode methodNode = new MethodNode(8, "<clinit>", "()V", "()V", null);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(methodNode);
        generator.push(mutableClass.classType);
        generator.invokeStatic(Type.getType(RobolectricInternals.class), new Method("classInitializing", "(Ljava/lang/Class;)V"));
        generator.returnValue();
        generator.endMethod();
        return methodNode;
    }

    protected abstract void generateClassHandlerCall(MutableClass var1, MethodNode var2, String var3, RobolectricGeneratorAdapter var4);

    int getTag(MethodNode m) {
        return Modifier.isStatic(m.access) ? 6 : 7;
    }

    static class TryCatch {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final GeneratorAdapter generatorAdapter;

        TryCatch(GeneratorAdapter generatorAdapter, Type type) {
            this.generatorAdapter = generatorAdapter;
            this.start = generatorAdapter.mark();
            this.end = new Label();
            this.handler = new Label();
            generatorAdapter.visitTryCatchBlock(this.start, this.end, this.handler, type.getInternalName());
        }

        void end() {
            this.generatorAdapter.mark(this.end);
        }

        void handler() {
            this.generatorAdapter.mark(this.handler);
        }
    }

    public static interface Decorator {
        public void decorate(MutableClass var1);

        public void decorateMethodPreClassHandler(MutableClass var1, MethodNode var2, String var3, RobolectricGeneratorAdapter var4);
    }
}

