/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric;

import android.app.Application;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.res.ResourceTable;
import org.robolectric.util.Scheduler;
import org.robolectric.util.TempDirectory;

public class RuntimeEnvironment {
    public static Application application;
    private static volatile Thread mainThread;
    private static String qualifiers;
    private static Object activityThread;
    private static int apiLevel;
    private static Scheduler masterScheduler;
    private static ResourceTable systemResourceTable;
    private static ResourceTable appResourceTable;
    private static ResourceTable compileTimeResourceTable;
    private static TempDirectory tempDirectory;
    private static AndroidManifest appManifest;

    public static boolean isMainThread(Thread thread) {
        return thread == mainThread;
    }

    public static boolean isMainThread() {
        return RuntimeEnvironment.isMainThread(Thread.currentThread());
    }

    public static Thread getMainThread() {
        return mainThread;
    }

    public static void setMainThread(Thread newMainThread) {
        mainThread = newMainThread;
    }

    public static Object getActivityThread() {
        return activityThread;
    }

    public static void setActivityThread(Object newActivityThread) {
        activityThread = newActivityThread;
    }

    public static String getQualifiers() {
        return qualifiers;
    }

    public static void setQualifiers(String newQualifiers) {
        qualifiers = newQualifiers;
    }

    public static int getApiLevel() {
        return apiLevel;
    }

    public static Number castNativePtr(long ptr) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return ptr;
        }
        return (int)ptr;
    }

    public static Scheduler getMasterScheduler() {
        return masterScheduler;
    }

    public static void setMasterScheduler(Scheduler masterScheduler) {
        RuntimeEnvironment.masterScheduler = masterScheduler;
    }

    public static void setSystemResourceTable(ResourceTable systemResourceTable) {
        RuntimeEnvironment.systemResourceTable = systemResourceTable;
    }

    public static void setAppResourceTable(ResourceTable appResourceTable) {
        RuntimeEnvironment.appResourceTable = appResourceTable;
    }

    public static ResourceTable getSystemResourceTable() {
        return systemResourceTable;
    }

    public static ResourceTable getAppResourceTable() {
        return appResourceTable;
    }

    public static void setCompileTimeResourceTable(ResourceTable compileTimeResourceTable) {
        RuntimeEnvironment.compileTimeResourceTable = compileTimeResourceTable;
    }

    public static ResourceTable getCompileTimeResourceTable() {
        return compileTimeResourceTable;
    }

    public static void setApplicationManifest(AndroidManifest appManifest) {
        RuntimeEnvironment.appManifest = appManifest;
    }

    @Deprecated
    public static AndroidManifest getAppManifest() {
        return appManifest;
    }

    public static void setTempDirectory(TempDirectory tempDirectory) {
        RuntimeEnvironment.tempDirectory = tempDirectory;
    }

    public static TempDirectory getTempDirectory() {
        return tempDirectory;
    }

    static {
        mainThread = Thread.currentThread();
        tempDirectory = new TempDirectory("no-test-yet");
    }
}

