/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Intent;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowPendingIntent;

@Implements(value=AlarmManager.class)
public class ShadowAlarmManager {
    private List<ScheduledAlarm> scheduledAlarms = new ArrayList<ScheduledAlarm>();

    @Implementation
    public void set(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation);
    }

    @Implementation(minSdk=19)
    public void setExact(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation);
    }

    @Implementation(minSdk=19)
    public void setWindow(int type, long windowStartMillis, long windowLengthMillis, PendingIntent operation) {
        this.internalSet(type, windowStartMillis, 0L, operation);
    }

    @Implementation(minSdk=23)
    public void setAndAllowWhileIdle(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation);
    }

    @Implementation(minSdk=23)
    public void setExactAndAllowWhileIdle(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation);
    }

    @Implementation
    public void setRepeating(int type, long triggerAtTime, long interval, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, interval, operation);
    }

    @Implementation
    public void setInexactRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.internalSet(type, triggerAtMillis, intervalMillis, operation);
    }

    private void internalSet(int type, long triggerAtTime, long interval, PendingIntent operation) {
        ShadowPendingIntent shadowPendingIntent = Shadows.shadowOf(operation);
        Intent intent = shadowPendingIntent.getSavedIntent();
        int requestCode = shadowPendingIntent.getRequestCode();
        for (ScheduledAlarm scheduledAlarm : this.scheduledAlarms) {
            ShadowPendingIntent shadowScheduledPendingIntent = Shadows.shadowOf(scheduledAlarm.operation);
            Intent scheduledIntent = shadowScheduledPendingIntent.getSavedIntent();
            int scheduledRequestCode = shadowScheduledPendingIntent.getRequestCode();
            if (!scheduledIntent.filterEquals(intent) || requestCode != scheduledRequestCode) continue;
            this.scheduledAlarms.remove(scheduledAlarm);
            break;
        }
        this.scheduledAlarms.add(new ScheduledAlarm(type, triggerAtTime, interval, operation));
    }

    public ScheduledAlarm getNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.remove(0);
    }

    public ScheduledAlarm peekNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.get(0);
    }

    public List<ScheduledAlarm> getScheduledAlarms() {
        return this.scheduledAlarms;
    }

    @Implementation
    public void cancel(PendingIntent pendingIntent) {
        ShadowPendingIntent shadowPendingIntent = Shadows.shadowOf(pendingIntent);
        Intent intentTypeToRemove = shadowPendingIntent.getSavedIntent();
        int requestCode = shadowPendingIntent.getRequestCode();
        for (ScheduledAlarm scheduledAlarm : new ArrayList<ScheduledAlarm>(this.scheduledAlarms)) {
            ShadowPendingIntent scheduledShadowPendingIntent = Shadows.shadowOf(scheduledAlarm.operation);
            Intent alarmIntent = scheduledShadowPendingIntent.getSavedIntent();
            int alarmRequestCode = scheduledShadowPendingIntent.getRequestCode();
            if (!intentTypeToRemove.filterEquals(alarmIntent) || requestCode != alarmRequestCode) continue;
            this.scheduledAlarms.remove(scheduledAlarm);
        }
    }

    public static class ScheduledAlarm {
        public int type;
        public long triggerAtTime;
        public long interval;
        public PendingIntent operation;

        public ScheduledAlarm(int type, long triggerAtTime, PendingIntent operation) {
            this(type, triggerAtTime, 0L, operation);
        }

        public ScheduledAlarm(int type, long triggerAtTime, long interval, PendingIntent operation) {
            this.type = type;
            this.triggerAtTime = triggerAtTime;
            this.operation = operation;
            this.interval = interval;
        }
    }
}

