/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ApplicationPackageManager;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageStats;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.VolumeInfo;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.manifest.ActivityData;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.manifest.ContentProviderData;
import org.robolectric.manifest.PackageItemData;
import org.robolectric.manifest.PermissionItemData;
import org.robolectric.manifest.ServiceData;
import org.robolectric.shadows.ShadowPackageManager;

@Implements(value=ApplicationPackageManager.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowApplicationPackageManager
extends ShadowPackageManager {
    @Override
    @Implementation
    public List<PackageInfo> getInstalledPackages(int flags) {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if ((Integer)this.applicationEnabledSettingMap.get(packageInfo.packageName) == 2 && (flags & 0x2000) != 8192) continue;
            result.add(packageInfo);
        }
        return result;
    }

    @Override
    @Implementation
    public ActivityInfo getActivityInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        String activityName;
        ActivityInfo activityInfo = new ActivityInfo();
        String packageName = component.getPackageName();
        activityInfo.name = activityName = component.getClassName();
        activityInfo.packageName = packageName;
        AndroidManifest androidManifest = (AndroidManifest)this.androidManifests.get(packageName);
        if (androidManifest == null) {
            return activityInfo;
        }
        ActivityData activityData = androidManifest.getActivityData(activityName);
        if (activityData != null) {
            activityInfo.configChanges = ShadowApplicationPackageManager.getConfigChanges(activityData);
            activityInfo.parentActivityName = activityData.getParentActivityName();
            activityInfo.metaData = ShadowApplicationPackageManager.metaDataToBundle(activityData.getMetaData().getValueMap());
            String themeRef = activityData.getThemeRef() != null ? activityData.getThemeRef() : androidManifest.getThemeRef();
            if (themeRef != null) {
                activityInfo.theme = RuntimeEnvironment.application.getResources().getIdentifier(themeRef.replace("@", ""), "style", packageName);
            }
        }
        activityInfo.applicationInfo = this.getApplicationInfo(packageName, flags);
        return activityInfo;
    }

    @Override
    @Implementation
    public boolean hasSystemFeature(String name) {
        return this.systemFeatureList.containsKey(name) ? (Boolean)this.systemFeatureList.get(name) : false;
    }

    @Implementation
    public int getComponentEnabledSetting(ComponentName componentName) {
        ShadowPackageManager.ComponentState state = (ShadowPackageManager.ComponentState)this.componentList.get(componentName);
        return state != null ? state.newState : 0;
    }

    @Implementation
    public String getNameForUid(int uid) {
        return (String)this.namesForUid.get(uid);
    }

    @Implementation
    public String[] getPackagesForUid(int uid) {
        String[] packageNames = (String[])this.packagesForUid.get(uid);
        if (packageNames != null) {
            return packageNames;
        }
        HashSet<String> results = new HashSet<String>();
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if (packageInfo.applicationInfo == null || packageInfo.applicationInfo.uid != uid) continue;
            results.add(packageInfo.packageName);
        }
        return results.isEmpty() ? null : results.toArray(new String[results.size()]);
    }

    @Implementation
    public int getApplicationEnabledSetting(String packageName) {
        try {
            this.getPackageInfo(packageName, -1);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return (Integer)this.applicationEnabledSettingMap.get(packageName);
    }

    @Implementation
    public ProviderInfo getProviderInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        String packageName = component.getPackageName();
        AndroidManifest androidManifest = (AndroidManifest)this.androidManifests.get(packageName);
        String classString = ShadowApplicationPackageManager.resolvePackageName(packageName, component);
        if (androidManifest != null) {
            for (ContentProviderData contentProviderData : androidManifest.getContentProviders()) {
                if (!contentProviderData.getClassName().equals(classString)) continue;
                ProviderInfo providerInfo = new ProviderInfo();
                providerInfo.packageName = packageName;
                providerInfo.name = contentProviderData.getClassName();
                providerInfo.authority = contentProviderData.getAuthorities();
                providerInfo.readPermission = contentProviderData.getReadPermission();
                providerInfo.writePermission = contentProviderData.getWritePermission();
                providerInfo.pathPermissions = ShadowApplicationPackageManager.createPathPermissions(contentProviderData.getPathPermissionDatas());
                providerInfo.metaData = ShadowApplicationPackageManager.metaDataToBundle(contentProviderData.getMetaData().getValueMap());
                if ((flags & 0x80) != 0) {
                    providerInfo.metaData = ShadowApplicationPackageManager.metaDataToBundle(contentProviderData.getMetaData().getValueMap());
                }
                return providerInfo;
            }
        }
        throw new PackageManager.NameNotFoundException("Package not found: " + packageName);
    }

    @Override
    @Implementation
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        this.componentList.put(componentName, new ShadowPackageManager.ComponentState(newState, flags));
    }

    @Override
    @Implementation
    public void setApplicationEnabledSetting(String packageName, int newState, int flags) {
        this.applicationEnabledSettingMap.put(packageName, newState);
    }

    @Override
    @Implementation
    public ResolveInfo resolveActivity(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentActivities(intent, flags);
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    @Implementation
    public ProviderInfo resolveContentProvider(String name, int flags) {
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if (packageInfo.providers == null) continue;
            for (ProviderInfo providerInfo : packageInfo.providers) {
                if (!name.equals(providerInfo.authority)) continue;
                return providerInfo;
            }
        }
        return null;
    }

    @Implementation
    public ProviderInfo resolveContentProviderAsUser(String name, int flags, int userId) {
        return null;
    }

    @Override
    @Implementation
    public PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        PackageInfo info = (PackageInfo)this.packageInfos.get(packageName);
        if (info != null) {
            if ((Integer)this.applicationEnabledSettingMap.get(packageName) == 2 && (flags & 0x2000) != 8192) {
                throw new PackageManager.NameNotFoundException("Package is disabled, can't find");
            }
            return info;
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Override
    @Implementation
    public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        List<ResolveInfo> resolveInfos = this.queryIntent(intent, flags);
        if (!resolveInfos.isEmpty()) {
            return resolveInfos;
        }
        resolveInfos = new ArrayList<ResolveInfo>();
        AndroidManifest applicationManifest = RuntimeEnvironment.getAppManifest();
        if (resolveInfos.isEmpty() && applicationManifest != null) {
            for (ServiceData service : applicationManifest.getServices()) {
                IntentFilter intentFilter = ShadowApplicationPackageManager.matchIntentFilter(intent, service.getIntentFilters());
                if (intentFilter == null) continue;
                resolveInfos.add(ShadowApplicationPackageManager.getResolveInfo(service, intentFilter, applicationManifest.getPackageName()));
            }
        }
        return resolveInfos;
    }

    @Override
    @Implementation
    public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        List<ResolveInfo> resolveInfoList = this.queryIntent(intent, flags);
        if (resolveInfoList.isEmpty() && this.queryIntentImplicitly) {
            resolveInfoList = this.queryImplicitIntent(intent, flags);
        }
        if ((flags & 0x20000) == 131072) {
            return resolveInfoList;
        }
        resolveInfoList = new ArrayList<ResolveInfo>(resolveInfoList);
        if ((flags & 0x100000) == 0x100000) {
            Iterator<ResolveInfo> iterator = resolveInfoList.iterator();
            while (iterator.hasNext()) {
                ResolveInfo resolveInfo = iterator.next();
                if (resolveInfo.activityInfo == null || resolveInfo.activityInfo.applicationInfo == null) {
                    iterator.remove();
                    continue;
                }
                int applicationFlags = resolveInfo.activityInfo.applicationInfo.flags;
                if ((applicationFlags & 1) == 1) continue;
                iterator.remove();
            }
        }
        return resolveInfoList;
    }

    private List<ResolveInfo> queryImplicitIntent(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
        for (Map.Entry androidManifest : this.androidManifests.entrySet()) {
            String packageName = (String)androidManifest.getKey();
            AndroidManifest appManifest = (AndroidManifest)androidManifest.getValue();
            for (Map.Entry activity : appManifest.getActivityDatas().entrySet()) {
                IntentFilter intentFilter;
                String activityName = (String)activity.getKey();
                ActivityData activityData = (ActivityData)activity.getValue();
                if (activityData.getTargetActivity() != null) {
                    activityName = activityData.getTargetActivityName();
                }
                if ((intentFilter = ShadowApplicationPackageManager.matchIntentFilter(intent, activityData.getIntentFilters())) == null) continue;
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.resolvePackageName = packageName;
                resolveInfo.activityInfo = new ActivityInfo();
                resolveInfo.activityInfo.targetActivity = activityName;
                resolveInfo.activityInfo.name = activityData.getName();
                resolveInfoList.add(resolveInfo);
            }
        }
        return resolveInfoList;
    }

    @Override
    @Implementation
    public int checkPermission(String permName, String pkgName) {
        PackageInfo permissionsInfo = (PackageInfo)this.packageInfos.get(pkgName);
        if (permissionsInfo == null || permissionsInfo.requestedPermissions == null) {
            return -1;
        }
        for (String permission2 : permissionsInfo.requestedPermissions) {
            if (permission2 == null || !permission2.equals(permName)) continue;
            return 0;
        }
        return -1;
    }

    @Override
    @Implementation
    public ActivityInfo getReceiverInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        String packageName = className.getPackageName();
        AndroidManifest androidManifest = (AndroidManifest)this.androidManifests.get(packageName);
        String classString = ShadowApplicationPackageManager.resolvePackageName(packageName, className);
        for (PackageItemData receiver : androidManifest.getBroadcastReceivers()) {
            if (!receiver.getClassName().equals(classString)) continue;
            ActivityInfo activityInfo = new ActivityInfo();
            activityInfo.packageName = packageName;
            activityInfo.name = classString;
            if ((flags & 0x80) != 0) {
                activityInfo.metaData = ShadowApplicationPackageManager.metaDataToBundle(receiver.getMetaData().getValueMap());
            }
            return activityInfo;
        }
        return null;
    }

    @Override
    @Implementation
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        return this.queryIntent(intent, flags);
    }

    @Override
    @Implementation
    public ResolveInfo resolveService(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentActivities(intent, flags);
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    @Override
    @Implementation
    public ServiceInfo getServiceInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        String packageName = className.getPackageName();
        AndroidManifest androidManifest = (AndroidManifest)this.androidManifests.get(packageName);
        if (androidManifest != null) {
            String serviceName = className.getClassName();
            ServiceData serviceData = androidManifest.getServiceData(serviceName);
            if (serviceData == null) {
                throw new PackageManager.NameNotFoundException(serviceName);
            }
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.packageName = packageName;
            serviceInfo.name = serviceName;
            serviceInfo.applicationInfo = this.getApplicationInfo(packageName, flags);
            serviceInfo.permission = serviceData.getPermission();
            if ((flags & 0x80) != 0) {
                serviceInfo.metaData = ShadowApplicationPackageManager.metaDataToBundle(serviceData.getMetaData().getValueMap());
            }
            return serviceInfo;
        }
        return null;
    }

    @Implementation
    public Resources getResourcesForApplication(ApplicationInfo applicationInfo) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(applicationInfo.packageName);
    }

    @Implementation
    public List<ApplicationInfo> getInstalledApplications(int flags) {
        LinkedList<ApplicationInfo> result = new LinkedList<ApplicationInfo>();
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            result.add(packageInfo.applicationInfo);
        }
        return result;
    }

    @Implementation
    public String getInstallerPackageName(String packageName) {
        return (String)this.packageInstallerMap.get(packageName);
    }

    @Implementation
    public PermissionInfo getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        PermissionInfo permissionInfo = (PermissionInfo)this.extraPermissions.get(name);
        if (permissionInfo != null) {
            return permissionInfo;
        }
        PermissionItemData permissionItemData = (PermissionItemData)RuntimeEnvironment.getAppManifest().getPermissions().get(name);
        if (permissionItemData == null) {
            throw new PackageManager.NameNotFoundException(name);
        }
        permissionInfo = ShadowApplicationPackageManager.createPermissionInfo(flags, permissionItemData);
        return permissionInfo;
    }

    @Implementation(minSdk=23)
    public boolean shouldShowRequestPermissionRationale(String permission2) {
        return this.permissionRationaleMap.containsKey(permission2) ? (Boolean)this.permissionRationaleMap.get(permission2) : false;
    }

    @Implementation
    public FeatureInfo[] getSystemAvailableFeatures() {
        return this.systemAvailableFeatures.isEmpty() ? null : this.systemAvailableFeatures.toArray(new FeatureInfo[this.systemAvailableFeatures.size()]);
    }

    @Implementation
    public void verifyPendingInstall(int id2, int verificationCode) {
        if (this.verificationResults.containsKey(id2)) {
            throw new IllegalStateException("Multiple verifications for id=" + id2);
        }
        this.verificationResults.put(id2, verificationCode);
    }

    @Implementation
    public void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        this.verificationTimeoutExtension.put(id2, millisecondsToDelay);
    }

    @Override
    @Implementation
    public void freeStorageAndNotify(long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    public void freeStorageAndNotify(String volumeUuid, long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    public void setInstallerPackageName(String targetPackage, String installerPackageName) {
        this.packageInstallerMap.put(targetPackage, installerPackageName);
    }

    @Implementation
    public List<ResolveInfo> queryIntentContentProviders(Intent intent, int flags) {
        return Collections.emptyList();
    }

    @Implementation
    public List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, int flags, int userId) {
        return Collections.emptyList();
    }

    @Implementation
    public String getPermissionControllerPackageName() {
        return null;
    }

    @Implementation(maxSdk=16)
    public void getPackageSizeInfo(String packageName, IPackageStatsObserver observer) {
        PackageStats packageStats = (PackageStats)this.packageStatsMap.get(packageName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                observer.onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation(minSdk=17, maxSdk=23)
    public void getPackageSizeInfo(String pkgName, int uid, IPackageStatsObserver callback) {
        PackageStats packageStats = (PackageStats)this.packageStatsMap.get(pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                callback.onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation(minSdk=24)
    public void getPackageSizeInfoAsUser(String pkgName, int uid, IPackageStatsObserver callback) {
        PackageStats packageStats = (PackageStats)this.packageStatsMap.get(pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                callback.onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation
    public void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        this.pendingDeleteCallbacks.put(packageName, observer);
    }

    @Implementation
    public String[] currentToCanonicalPackageNames(String[] names) {
        String[] out = new String[names.length];
        for (int i = names.length - 1; i >= 0; --i) {
            out[i] = this.currentToCanonicalNames.containsKey(names[i]) ? (String)this.currentToCanonicalNames.get(names[i]) : names[i];
        }
        return out;
    }

    @Implementation
    public boolean isSafeMode() {
        return false;
    }

    @Override
    @Implementation
    public Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
        return (Drawable)this.applicationIcons.get(packageName);
    }

    @Implementation
    public Drawable getApplicationIcon(ApplicationInfo info) {
        return null;
    }

    @Implementation
    public Drawable getUserBadgeForDensity(UserHandle userHandle, int i) {
        return null;
    }

    @Implementation
    public int checkSignatures(String pkg1, String pkg2) {
        try {
            PackageInfo packageInfo1 = this.getPackageInfo(pkg1, 64);
            PackageInfo packageInfo2 = this.getPackageInfo(pkg2, 64);
            return ShadowApplicationPackageManager.compareSignature(packageInfo1.signatures, packageInfo2.signatures);
        }
        catch (PackageManager.NameNotFoundException e) {
            return -4;
        }
    }

    @Implementation
    public int checkSignatures(int uid1, int uid2) {
        return 0;
    }

    @Implementation
    public List<PermissionInfo> queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
        LinkedList<PermissionInfo> result = new LinkedList<PermissionInfo>();
        for (PermissionInfo permissionInfo : this.extraPermissions.values()) {
            if (!Objects.equals(permissionInfo.group, group)) continue;
            result.add(permissionInfo);
        }
        for (PermissionItemData permissionItemData : RuntimeEnvironment.getAppManifest().getPermissions().values()) {
            if (!Objects.equals(permissionItemData.getPermissionGroup(), group)) continue;
            result.add(ShadowApplicationPackageManager.createPermissionInfo(flags, permissionItemData));
        }
        return result;
    }

    @Override
    public CharSequence getApplicationLabel(ApplicationInfo info) {
        return info.name;
    }

    @Override
    @Implementation
    public Intent getLaunchIntentForPackage(String packageName) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory("android.intent.category.INFO");
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, 0);
        if (ris == null || ris.isEmpty()) {
            intentToResolve.removeCategory("android.intent.category.INFO");
            intentToResolve.addCategory("android.intent.category.LAUNCHER");
            intentToResolve.setPackage(packageName);
            ris = this.queryIntentActivities(intentToResolve, 0);
        }
        if (ris == null || ris.isEmpty()) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(ris.get((int)0).activityInfo.packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    @Implementation
    public PackageInfo getPackageInfoAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public String[] canonicalToCurrentPackageNames(String[] names) {
        return new String[0];
    }

    @Implementation
    public Intent getLeanbackLaunchIntentForPackage(String packageName) {
        return null;
    }

    @Implementation
    public int[] getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
        return new int[0];
    }

    @Implementation
    public int[] getPackageGids(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public int getPackageUid(String packageName, int flags) throws PackageManager.NameNotFoundException {
        Integer uid = (Integer)this.uidForPackage.get(packageName);
        if (uid == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return uid;
    }

    @Implementation
    public int getPackageUidAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    public int getPackageUidAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        return null;
    }

    @Override
    @Implementation
    public ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        PackageInfo info = (PackageInfo)this.packageInfos.get(packageName);
        if (info != null) {
            try {
                PackageInfo packageInfo = this.getPackageInfo(packageName, -1);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            if ((Integer)this.applicationEnabledSettingMap.get(packageName) == 2 && (flags & 0x2000) != 8192) {
                throw new PackageManager.NameNotFoundException("Package is disabled, can't find");
            }
            return info.applicationInfo;
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Implementation
    public String[] getSystemSharedLibraryNames() {
        return new String[0];
    }

    @Implementation
    public String getServicesSystemSharedLibraryPackageName() {
        return null;
    }

    @Implementation
    public String getSharedSystemSharedLibraryPackageName() {
        return "";
    }

    @Implementation
    public boolean hasSystemFeature(String name, int version) {
        return false;
    }

    @Implementation
    public boolean isPermissionRevokedByPolicy(String permName, String pkgName) {
        return false;
    }

    @Implementation
    public boolean addPermission(PermissionInfo info) {
        return false;
    }

    @Implementation
    public boolean addPermissionAsync(PermissionInfo info) {
        return false;
    }

    @Implementation
    public void removePermission(String name) {
    }

    @Implementation
    public void grantRuntimePermission(String packageName, String permissionName, UserHandle user) {
    }

    @Implementation
    public void revokeRuntimePermission(String packageName, String permissionName, UserHandle user) {
    }

    @Implementation
    public int getPermissionFlags(String permissionName, String packageName, UserHandle user) {
        return 0;
    }

    @Implementation
    public void updatePermissionFlags(String permissionName, String packageName, int flagMask, int flagValues, UserHandle user) {
    }

    @Implementation
    public int getUidForSharedUser(String sharedUserName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    public List<PackageInfo> getInstalledPackagesAsUser(int flags, int userId) {
        return null;
    }

    @Implementation
    public List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags) {
        return null;
    }

    @Implementation
    public ResolveInfo resolveActivityAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    public List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
        return null;
    }

    @Implementation
    public List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    public List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        return null;
    }

    @Implementation
    public InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        return null;
    }

    @Override
    @Implementation
    public Drawable getDrawable(String packageName, int resId, ApplicationInfo appInfo) {
        return (Drawable)this.drawables.get(new Pair((Object)packageName, (Object)resId));
    }

    @Override
    @Implementation
    public Drawable getActivityIcon(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return (Drawable)this.drawableList.get(activityName);
    }

    @Override
    public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
        return (Drawable)this.drawableList.get(intent.getComponent());
    }

    @Implementation
    public Drawable getDefaultActivityIcon() {
        return Resources.getSystem().getDrawable(17301651);
    }

    @Implementation
    public Drawable getActivityBanner(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public Drawable getActivityBanner(Intent intent) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public Drawable getApplicationBanner(ApplicationInfo info) {
        return null;
    }

    @Implementation
    public Drawable getApplicationBanner(String packageName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public Drawable getActivityLogo(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public Drawable getApplicationLogo(ApplicationInfo info) {
        return null;
    }

    @Implementation
    public Drawable getApplicationLogo(String packageName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public Drawable getUserBadgedIcon(Drawable icon, UserHandle user) {
        return null;
    }

    @Implementation
    public Drawable getUserBadgedDrawableForDensity(Drawable drawable2, UserHandle user, Rect badgeLocation, int badgeDensity) {
        return null;
    }

    @Implementation
    public Drawable getUserBadgeForDensityNoBackground(UserHandle user, int density) {
        return null;
    }

    @Implementation
    public CharSequence getUserBadgedLabel(CharSequence label, UserHandle user) {
        return null;
    }

    @Implementation
    public Resources getResourcesForActivity(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
        if (RuntimeEnvironment.application.getPackageName().equals(appPackageName)) {
            return RuntimeEnvironment.application.getResources();
        }
        if (this.packageInfos.containsKey(appPackageName)) {
            Resources appResources = (Resources)this.resources.get(appPackageName);
            if (appResources == null) {
                appResources = new Resources(new AssetManager(), null, null);
                this.resources.put(appPackageName, appResources);
            }
            return appResources;
        }
        throw new PackageManager.NameNotFoundException(appPackageName);
    }

    @Implementation
    public Resources getResourcesForApplicationAsUser(String appPackageName, int userId) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    public void addOnPermissionsChangeListener(Object listener) {
    }

    @Implementation
    public void removeOnPermissionsChangeListener(Object listener) {
    }

    @Implementation
    public CharSequence getText(String packageName, int resid, ApplicationInfo appInfo) {
        return null;
    }

    @Implementation
    public void installPackage(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName) {
    }

    @Implementation
    public void installPackage(Object packageURI, Object observer, Object flags, Object installerPackageName) {
    }

    @Implementation
    public int installExistingPackage(String packageName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    public int installExistingPackageAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    public void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) {
    }

    @Implementation
    public int getIntentVerificationStatusAsUser(String packageName, int userId) {
        return 0;
    }

    @Implementation
    public boolean updateIntentVerificationStatusAsUser(String packageName, int status, int userId) {
        return false;
    }

    @Implementation
    public List<IntentFilterVerificationInfo> getIntentFilterVerifications(String packageName) {
        return null;
    }

    @Implementation
    public List<IntentFilter> getAllIntentFilters(String packageName) {
        return null;
    }

    @Implementation
    public String getDefaultBrowserPackageNameAsUser(int userId) {
        return null;
    }

    @Implementation
    public boolean setDefaultBrowserPackageNameAsUser(String packageName, int userId) {
        return false;
    }

    @Implementation
    public int getMoveStatus(int moveId) {
        return 0;
    }

    @Implementation
    public void registerMoveCallback(Object callback, Object handler) {
    }

    @Implementation
    public void unregisterMoveCallback(Object callback) {
    }

    @Implementation
    public Object movePackage(Object packageName, Object vol) {
        return 0;
    }

    @Implementation
    public Object getPackageCurrentVolume(Object app) {
        return null;
    }

    @Implementation
    public List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo app) {
        return null;
    }

    @Implementation
    public Object movePrimaryStorage(Object vol) {
        return 0;
    }

    @Implementation
    public Object getPrimaryStorageCurrentVolume() {
        return null;
    }

    @Implementation
    public List<VolumeInfo> getPrimaryStorageCandidateVolumes() {
        return null;
    }

    @Implementation
    public void deletePackageAsUser(String packageName, IPackageDeleteObserver observer, int flags, int userId) {
    }

    @Implementation
    public void clearApplicationUserData(String packageName, IPackageDataObserver observer) {
    }

    @Implementation
    public void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
    }

    @Implementation
    public void deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) {
    }

    @Implementation
    public void freeStorage(String volumeUuid, long freeStorageSize, IntentSender pi) {
    }

    @Implementation
    public String[] setPackagesSuspendedAsUser(String[] packageNames, boolean suspended, int userId) {
        return null;
    }

    @Implementation
    public boolean isPackageSuspendedForUser(String packageName, int userId) {
        return false;
    }

    @Implementation
    public void addPackageToPreferred(String packageName) {
    }

    @Implementation
    public void removePackageFromPreferred(String packageName) {
    }

    @Implementation
    public List<PackageInfo> getPreferredPackages(int flags) {
        return null;
    }

    @Override
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        this.preferredActivities.put(filter, activity);
    }

    @Implementation
    public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
    }

    @Implementation
    public void clearPackagePreferredActivities(String packageName) {
    }

    @Override
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        if (outFilters == null) {
            return 0;
        }
        Set filters = this.preferredActivities.keySet();
        for (IntentFilter filter : outFilters) {
            block1: for (IntentFilter testFilter : filters) {
                ComponentName name = (ComponentName)this.preferredActivities.get(testFilter);
                if (packageName != null && !name.getPackageName().equals(packageName)) continue;
                Iterator iterator = filter.actionsIterator();
                while (iterator.hasNext()) {
                    if (testFilter.matchAction((String)iterator.next())) continue;
                    continue block1;
                }
                iterator = filter.categoriesIterator();
                while (iterator.hasNext()) {
                    if (filter.hasCategory((String)iterator.next())) continue;
                    continue block1;
                }
                if (outActivities == null) {
                    outActivities = new ArrayList<ComponentName>();
                }
                outActivities.add(name);
            }
        }
        return 0;
    }

    @Implementation
    public ComponentName getHomeActivities(List<ResolveInfo> outActivities) {
        return null;
    }

    @Implementation
    public void flushPackageRestrictionsAsUser(int userId) {
    }

    @Implementation
    public boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, UserHandle user) {
        return false;
    }

    @Implementation
    public boolean getApplicationHiddenSettingAsUser(String packageName, UserHandle user) {
        return false;
    }

    @Implementation
    public Object getKeySetByAlias(String packageName, String alias) {
        return null;
    }

    @Implementation
    public Object getSigningKeySet(String packageName) {
        return null;
    }

    @Implementation
    public boolean isSignedBy(String packageName, Object ks) {
        return false;
    }

    @Implementation
    public boolean isSignedByExactly(String packageName, Object ks) {
        return false;
    }

    @Implementation
    public VerifierDeviceIdentity getVerifierDeviceIdentity() {
        return null;
    }

    @Implementation
    public boolean isUpgrade() {
        return false;
    }

    @Implementation
    public boolean isPackageAvailable(String packageName) {
        return false;
    }

    @Implementation
    public void addCrossProfileIntentFilter(IntentFilter filter, int sourceUserId, int targetUserId, int flags) {
    }

    @Implementation
    public void clearCrossProfileIntentFilters(int sourceUserId) {
    }

    @Implementation
    public Drawable loadItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        return null;
    }

    @Implementation
    public Drawable loadUnbadgedItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        return null;
    }
}

