/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.ParcelFileDescriptor;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=UsbManager.class)
public class ShadowUsbManager {
    private HashMap<UsbDevice, Boolean> usbDevicesPermissionMap = new HashMap();

    @Implementation
    public boolean hasPermission(UsbDevice device) {
        return this.usbDevicesPermissionMap.containsKey(device) ? this.usbDevicesPermissionMap.get(device) : false;
    }

    @Implementation
    public HashMap<String, UsbDevice> getDeviceList() {
        HashMap<String, UsbDevice> usbDeviceMap = new HashMap<String, UsbDevice>();
        for (UsbDevice usbDevice : this.usbDevicesPermissionMap.keySet()) {
            usbDeviceMap.put(usbDevice.getDeviceName(), usbDevice);
        }
        return usbDeviceMap;
    }

    public void reset() {
        this.usbDevicesPermissionMap.clear();
    }

    public void addOrUpdateUsbDevice(UsbDevice usbDevice, boolean hasPermission) {
        Preconditions.checkNotNull((Object)usbDevice);
        Preconditions.checkNotNull((Object)usbDevice.getDeviceName());
        this.usbDevicesPermissionMap.put(usbDevice, hasPermission);
    }

    public void removeUsbDevice(UsbDevice usbDevice) {
        Preconditions.checkNotNull((Object)usbDevice);
        this.usbDevicesPermissionMap.remove(usbDevice);
    }

    @Implementation
    public ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        try {
            File tmpUsbDir = RuntimeEnvironment.getTempDirectory().createIfNotExists("usb-accessory").toFile();
            return ParcelFileDescriptor.open((File)new File(tmpUsbDir, "usb-accessory-file"), (int)0x30000000);
        }
        catch (FileNotFoundException error) {
            throw new RuntimeException("Error shadowing openAccessory", error);
        }
    }
}

