/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ViewAnimator;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowFrameLayout;

@Implements(value=ViewAnimator.class)
public class ShadowViewAnimator
extends ShadowFrameLayout {
    private int currentChild = 0;

    @Implementation
    public int getDisplayedChild() {
        return this.currentChild;
    }

    @Implementation
    public void setDisplayedChild(int whichChild) {
        this.currentChild = whichChild;
        for (int i = ((ViewGroup)this.realView).getChildCount() - 1; i >= 0; --i) {
            View child = ((ViewGroup)this.realView).getChildAt(i);
            child.setVisibility(i == whichChild ? 0 : 8);
        }
    }

    @Implementation
    public View getCurrentView() {
        return ((ViewGroup)this.realView).getChildAt(this.getDisplayedChild());
    }

    @Implementation
    public void showNext() {
        this.setDisplayedChild((this.getDisplayedChild() + 1) % ((ViewGroup)this.realView).getChildCount());
    }

    @Implementation
    public void showPrevious() {
        this.setDisplayedChild(this.getDisplayedChild() == 0 ? ((ViewGroup)this.realView).getChildCount() - 1 : this.getDisplayedChild() - 1);
    }
}

