/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AccessibilityNodeInfo.class)
public class ShadowAccessibilityNodeInfo {
    private static final Map<StrictEqualityNodeWrapper, StackTraceElement[]> obtainedInstances = new HashMap<StrictEqualityNodeWrapper, StackTraceElement[]>();
    private static final SparseArray<StrictEqualityNodeWrapper> orderedInstances = new SparseArray();
    public static final int UNDEFINED_SELECTION_INDEX = -1;
    public static final Parcelable.Creator<AccessibilityNodeInfo> CREATOR = new Parcelable.Creator<AccessibilityNodeInfo>(){

        public AccessibilityNodeInfo createFromParcel(Parcel source) {
            return ShadowAccessibilityNodeInfo.obtain(((StrictEqualityNodeWrapper)orderedInstances.get((int)source.readInt())).mInfo);
        }

        public AccessibilityNodeInfo[] newArray(int size) {
            return new AccessibilityNodeInfo[size];
        }
    };
    private static int sAllocationCount = 0;
    private static final int CLICKABLE_MASK = 1;
    private static final int LONGCLICKABLE_MASK = 2;
    private static final int FOCUSABLE_MASK = 4;
    private static final int FOCUSED_MASK = 8;
    private static final int VISIBLE_TO_USER_MASK = 16;
    private static final int SCROLLABLE_MASK = 32;
    private static final int PASTEABLE_MASK = 64;
    private static final int EDITABLE_MASK = 128;
    private static final int TEXT_SELECTION_SETABLE_MASK = 256;
    private static final int CHECKABLE_MASK = 4096;
    private static final int CHECKED_MASK = 8192;
    private static final int ENABLED_MASK = 65536;
    private static final int PASSWORD_MASK = 262144;
    private static final int SELECTED_MASK = 524288;
    private static final int A11YFOCUSED_MASK = 2048;
    private static final int MULTILINE_MASK = 131072;
    private static final int CONTENT_INVALID_MASK = 16384;
    private static final int DISMISSABLE_MASK = 32768;
    private static final int CAN_OPEN_POPUP_MASK = 0x100000;
    private List<AccessibilityNodeInfo> children;
    private Rect boundsInScreen = new Rect();
    private Rect boundsInParent = new Rect();
    private List<Pair<Integer, Bundle>> performedActionAndArgsList;
    private ArrayList<AccessibilityNodeInfo.AccessibilityAction> actionsArray;
    private int actionsMask;
    private int propertyFlags;
    private AccessibilityNodeInfo parent;
    private AccessibilityNodeInfo labelFor;
    private AccessibilityNodeInfo labeledBy;
    private View view;
    private CharSequence contentDescription;
    private CharSequence text;
    private CharSequence className;
    private int textSelectionStart = -1;
    private int textSelectionEnd = -1;
    private boolean refreshReturnValue = true;
    private int movementGranularities;
    private CharSequence packageName;
    private String viewIdResourceName;
    private AccessibilityNodeInfo.CollectionInfo collectionInfo;
    private AccessibilityNodeInfo.CollectionItemInfo collectionItemInfo;
    private int inputType;
    private int liveRegion;
    private AccessibilityNodeInfo.RangeInfo rangeInfo;
    private int maxTextLength;
    private CharSequence error;
    private AccessibilityWindowInfo accessibilityWindowInfo;
    private AccessibilityNodeInfo traversalAfter;
    private AccessibilityNodeInfo traversalBefore;
    private OnPerformActionListener actionListener;
    private boolean visitedWhenCheckingChildren = false;
    @RealObject
    private AccessibilityNodeInfo realAccessibilityNodeInfo;

    @Implementation
    public void __constructor__() {
        ReflectionHelpers.setStaticField(AccessibilityNodeInfo.class, (String)"CREATOR", CREATOR);
    }

    @Implementation
    public static AccessibilityNodeInfo obtain(AccessibilityNodeInfo info) {
        ShadowAccessibilityNodeInfo shadowInfo = Shadows.shadowOf(info);
        AccessibilityNodeInfo obtainedInstance = shadowInfo.getClone();
        StrictEqualityNodeWrapper wrapper = new StrictEqualityNodeWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        orderedInstances.put(++sAllocationCount, (Object)wrapper);
        return obtainedInstance;
    }

    @Implementation
    public static AccessibilityNodeInfo obtain(View view) {
        AccessibilityNodeInfo obtainedInstance = (AccessibilityNodeInfo)ReflectionHelpers.callConstructor(AccessibilityNodeInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowAccessibilityNodeInfo shadowObtained = Shadows.shadowOf(obtainedInstance);
        shadowObtained.performedActionAndArgsList = new LinkedList<Pair<Integer, Bundle>>();
        shadowObtained.view = view;
        StrictEqualityNodeWrapper wrapper = new StrictEqualityNodeWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        orderedInstances.put(++sAllocationCount, (Object)wrapper);
        return obtainedInstance;
    }

    @Implementation
    public static AccessibilityNodeInfo obtain() {
        return ShadowAccessibilityNodeInfo.obtain(new View(RuntimeEnvironment.application.getApplicationContext()));
    }

    @Implementation
    public static AccessibilityNodeInfo obtain(View root, int virtualDescendantId) {
        AccessibilityNodeInfo node = ShadowAccessibilityNodeInfo.obtain(root);
        return node;
    }

    public static boolean areThereUnrecycledNodes(boolean printUnrecycledNodesToSystemErr) {
        if (printUnrecycledNodesToSystemErr) {
            for (StrictEqualityNodeWrapper wrapper : obtainedInstances.keySet()) {
                ShadowAccessibilityNodeInfo shadow = Shadows.shadowOf(wrapper.mInfo);
                System.err.println(String.format("Leaked contentDescription = %s. Stack trace:", shadow.getContentDescription()));
                for (StackTraceElement stackTraceElement : obtainedInstances.get(wrapper)) {
                    System.err.println(stackTraceElement.toString());
                }
            }
        }
        return obtainedInstances.size() != 0;
    }

    public static void resetObtainedInstances() {
        obtainedInstances.clear();
        orderedInstances.clear();
    }

    @Implementation
    public void recycle() {
        StrictEqualityNodeWrapper wrapper = new StrictEqualityNodeWrapper(this.realAccessibilityNodeInfo);
        if (!obtainedInstances.containsKey(wrapper)) {
            throw new IllegalStateException();
        }
        if (this.labelFor != null) {
            this.labelFor.recycle();
        }
        if (this.labeledBy != null) {
            this.labeledBy.recycle();
        }
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            if (this.traversalAfter != null) {
                this.traversalAfter.recycle();
            }
            if (this.traversalBefore != null) {
                this.traversalBefore.recycle();
            }
        }
        obtainedInstances.remove(wrapper);
        int keyOfWrapper = -1;
        for (int i = 0; i < orderedInstances.size(); ++i) {
            int key = orderedInstances.keyAt(i);
            if (!((StrictEqualityNodeWrapper)orderedInstances.get(key)).equals(wrapper)) continue;
            keyOfWrapper = key;
            break;
        }
        orderedInstances.remove(keyOfWrapper);
    }

    @Implementation
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Implementation
    public AccessibilityNodeInfo getChild(int index) {
        if (this.children == null) {
            return null;
        }
        AccessibilityNodeInfo child = this.children.get(index);
        if (child == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(child);
    }

    @Implementation
    public AccessibilityNodeInfo getParent() {
        if (this.parent == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.parent);
    }

    @Implementation
    public boolean refresh() {
        return this.refreshReturnValue;
    }

    public void setRefreshReturnValue(boolean refreshReturnValue) {
        this.refreshReturnValue = refreshReturnValue;
    }

    @Implementation
    public boolean isClickable() {
        return (this.propertyFlags & 1) != 0;
    }

    @Implementation
    public boolean isLongClickable() {
        return (this.propertyFlags & 2) != 0;
    }

    @Implementation
    public boolean isFocusable() {
        return (this.propertyFlags & 4) != 0;
    }

    @Implementation
    public boolean isFocused() {
        return (this.propertyFlags & 8) != 0;
    }

    @Implementation
    public boolean isVisibleToUser() {
        return (this.propertyFlags & 0x10) != 0;
    }

    @Implementation
    public boolean isScrollable() {
        return (this.propertyFlags & 0x20) != 0;
    }

    public boolean isPasteable() {
        return (this.propertyFlags & 0x40) != 0;
    }

    @Implementation
    public boolean isEditable() {
        return (this.propertyFlags & 0x80) != 0;
    }

    public boolean isTextSelectionSetable() {
        return (this.propertyFlags & 0x100) != 0;
    }

    @Implementation
    public boolean isCheckable() {
        return (this.propertyFlags & 0x1000) != 0;
    }

    @Implementation
    public void setCheckable(boolean checkable) {
        this.propertyFlags = this.propertyFlags & 0xFFFFEFFF | (checkable ? 4096 : 0);
    }

    @Implementation
    public void setChecked(boolean checked) {
        this.propertyFlags = this.propertyFlags & 0xFFFFDFFF | (checked ? 8192 : 0);
    }

    @Implementation
    public boolean isChecked() {
        return (this.propertyFlags & 0x2000) != 0;
    }

    @Implementation
    public void setEnabled(boolean enabled) {
        this.propertyFlags = this.propertyFlags & 0xFFFEFFFF | (enabled ? 65536 : 0);
    }

    @Implementation
    public boolean isEnabled() {
        return (this.propertyFlags & 0x10000) != 0;
    }

    @Implementation
    public void setPassword(boolean password) {
        this.propertyFlags = this.propertyFlags & 0xFFFBFFFF | (password ? 262144 : 0);
    }

    @Implementation
    public boolean isPassword() {
        return (this.propertyFlags & 0x40000) != 0;
    }

    @Implementation
    public void setSelected(boolean selected) {
        this.propertyFlags = this.propertyFlags & 0xFFF7FFFF | (selected ? 524288 : 0);
    }

    @Implementation
    public boolean isSelected() {
        return (this.propertyFlags & 0x80000) != 0;
    }

    @Implementation
    public void setAccessibilityFocused(boolean focused) {
        this.propertyFlags = this.propertyFlags & 0xFFFFF7FF | (focused ? 2048 : 0);
    }

    @Implementation
    public boolean isAccessibilityFocused() {
        return (this.propertyFlags & 0x800) != 0;
    }

    @Implementation(minSdk=21)
    public void setMultiLine(boolean multiLine) {
        this.propertyFlags = this.propertyFlags & 0xFFFDFFFF | (multiLine ? 131072 : 0);
    }

    @Implementation(minSdk=21)
    public boolean isMultiLine() {
        return (this.propertyFlags & 0x20000) != 0;
    }

    @Implementation(minSdk=21)
    public void setContentInvalid(boolean contentInvalid) {
        this.propertyFlags = this.propertyFlags & 0xFFFFBFFF | (contentInvalid ? 16384 : 0);
    }

    @Implementation(minSdk=21)
    public boolean isContentInvalid() {
        return (this.propertyFlags & 0x4000) != 0;
    }

    @Implementation(minSdk=21)
    public void setDismissable(boolean dismissable) {
        this.propertyFlags = this.propertyFlags & 0xFFFF7FFF | (dismissable ? 32768 : 0);
    }

    @Implementation(minSdk=21)
    public boolean isDismissable() {
        return (this.propertyFlags & 0x8000) != 0;
    }

    @Implementation(minSdk=21)
    public void setCanOpenPopup(boolean opensPopup) {
        this.propertyFlags = this.propertyFlags & 0xFFEFFFFF | (opensPopup ? 0x100000 : 0);
    }

    @Implementation(minSdk=21)
    public boolean canOpenPopup() {
        return (this.propertyFlags & 0x100000) != 0;
    }

    public void setTextSelectionSetable(boolean isTextSelectionSetable) {
        this.propertyFlags = this.propertyFlags & 0xFFFFFEFF | (isTextSelectionSetable ? 256 : 0);
    }

    @Implementation
    public void setClickable(boolean isClickable) {
        this.propertyFlags = this.propertyFlags & 0xFFFFFFFE | (isClickable ? 1 : 0);
    }

    @Implementation
    public void setLongClickable(boolean isLongClickable) {
        this.propertyFlags = this.propertyFlags & 0xFFFFFFFD | (isLongClickable ? 2 : 0);
    }

    @Implementation
    public void setFocusable(boolean isFocusable) {
        this.propertyFlags = this.propertyFlags & 0xFFFFFFFB | (isFocusable ? 4 : 0);
    }

    @Implementation
    public void setFocused(boolean isFocused) {
        this.propertyFlags = this.propertyFlags & 0xFFFFFFF7 | (isFocused ? 8 : 0);
    }

    @Implementation
    public void setScrollable(boolean isScrollable) {
        this.propertyFlags = this.propertyFlags & 0xFFFFFFDF | (isScrollable ? 32 : 0);
    }

    public void setPasteable(boolean isPasteable) {
        this.propertyFlags = this.propertyFlags & 0xFFFFFFBF | (isPasteable ? 64 : 0);
    }

    @Implementation
    public void setEditable(boolean isEditable) {
        this.propertyFlags = this.propertyFlags & 0xFFFFFF7F | (isEditable ? 128 : 0);
    }

    @Implementation
    public void setVisibleToUser(boolean isVisibleToUser) {
        this.propertyFlags = this.propertyFlags & 0xFFFFFFEF | (isVisibleToUser ? 16 : 0);
    }

    @Implementation
    public void setContentDescription(CharSequence description) {
        this.contentDescription = description;
    }

    @Implementation
    public CharSequence getContentDescription() {
        return this.contentDescription;
    }

    @Implementation
    public void setClassName(CharSequence name) {
        this.className = name;
    }

    @Implementation
    public CharSequence getClassName() {
        return this.className;
    }

    @Implementation
    public void setText(CharSequence t) {
        this.text = t;
    }

    @Implementation
    public CharSequence getText() {
        return this.text;
    }

    @Implementation
    public void setTextSelection(int start, int end) {
        this.textSelectionStart = start;
        this.textSelectionEnd = end;
    }

    @Implementation
    public int getTextSelectionStart() {
        return this.textSelectionStart;
    }

    @Implementation
    public int getTextSelectionEnd() {
        return this.textSelectionEnd;
    }

    @Implementation
    public AccessibilityNodeInfo getLabelFor() {
        if (this.labelFor == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.labelFor);
    }

    public void setLabelFor(AccessibilityNodeInfo info) {
        if (this.labelFor != null) {
            this.labelFor.recycle();
        }
        this.labelFor = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation
    public AccessibilityNodeInfo getLabeledBy() {
        if (this.labeledBy == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.labeledBy);
    }

    public void setLabeledBy(AccessibilityNodeInfo info) {
        if (this.labeledBy != null) {
            this.labeledBy.recycle();
        }
        this.labeledBy = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation
    public int getMovementGranularities() {
        return this.movementGranularities;
    }

    @Implementation
    public void setMovementGranularities(int movementGranularities) {
        this.movementGranularities = movementGranularities;
    }

    @Implementation
    public CharSequence getPackageName() {
        return this.packageName;
    }

    @Implementation
    public void setPackageName(CharSequence packageName) {
        this.packageName = packageName;
    }

    @Implementation(minSdk=18)
    public String getViewIdResourceName() {
        return this.viewIdResourceName;
    }

    @Implementation(minSdk=18)
    public void setViewIdResourceName(String viewIdResourceName) {
        this.viewIdResourceName = viewIdResourceName;
    }

    @Implementation(minSdk=19)
    public AccessibilityNodeInfo.CollectionInfo getCollectionInfo() {
        return this.collectionInfo;
    }

    @Implementation(minSdk=19)
    public void setCollectionInfo(AccessibilityNodeInfo.CollectionInfo collectionInfo) {
        this.collectionInfo = collectionInfo;
    }

    @Implementation(minSdk=19)
    public AccessibilityNodeInfo.CollectionItemInfo getCollectionItemInfo() {
        return this.collectionItemInfo;
    }

    @Implementation(minSdk=19)
    public void setCollectionItemInfo(AccessibilityNodeInfo.CollectionItemInfo collectionItemInfo) {
        this.collectionItemInfo = collectionItemInfo;
    }

    @Implementation(minSdk=19)
    public int getInputType() {
        return this.inputType;
    }

    @Implementation(minSdk=19)
    public void setInputType(int inputType) {
        this.inputType = inputType;
    }

    @Implementation(minSdk=19)
    public int getLiveRegion() {
        return this.liveRegion;
    }

    @Implementation(minSdk=19)
    public void setLiveRegion(int liveRegion) {
        this.liveRegion = liveRegion;
    }

    @Implementation(minSdk=19)
    public AccessibilityNodeInfo.RangeInfo getRangeInfo() {
        return this.rangeInfo;
    }

    @Implementation(minSdk=19)
    public void setRangeInfo(AccessibilityNodeInfo.RangeInfo rangeInfo) {
        this.rangeInfo = rangeInfo;
    }

    @Implementation(minSdk=21)
    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    @Implementation(minSdk=21)
    public void setMaxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
    }

    @Implementation(minSdk=21)
    public CharSequence getError() {
        return this.error;
    }

    @Implementation(minSdk=21)
    public void setError(CharSequence error) {
        this.error = error;
    }

    @Implementation(minSdk=22)
    public AccessibilityNodeInfo getTraversalAfter() {
        if (this.traversalAfter == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.traversalAfter);
    }

    @Implementation(minSdk=22)
    public void setTraversalAfter(AccessibilityNodeInfo info) {
        if (this.traversalAfter != null) {
            this.traversalAfter.recycle();
        }
        this.traversalAfter = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation(minSdk=22)
    public AccessibilityNodeInfo getTraversalBefore() {
        if (this.traversalBefore == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.traversalBefore);
    }

    @Implementation(minSdk=22)
    public void setTraversalBefore(AccessibilityNodeInfo info) {
        if (this.traversalBefore != null) {
            this.traversalBefore.recycle();
        }
        this.traversalBefore = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation
    public void setSource(View source) {
        this.view = source;
    }

    @Implementation
    public void setSource(View root, int virtualDescendantId) {
        this.view = root;
    }

    @Implementation
    public void getBoundsInScreen(Rect outBounds) {
        if (this.boundsInScreen == null) {
            this.boundsInScreen = new Rect();
        }
        outBounds.set(this.boundsInScreen);
    }

    @Implementation
    public void getBoundsInParent(Rect outBounds) {
        if (this.boundsInParent == null) {
            this.boundsInParent = new Rect();
        }
        outBounds.set(this.boundsInParent);
    }

    @Implementation
    public void setBoundsInScreen(Rect b) {
        if (this.boundsInScreen == null) {
            this.boundsInScreen = new Rect(b);
        } else {
            this.boundsInScreen.set(b);
        }
    }

    @Implementation
    public void setBoundsInParent(Rect b) {
        if (this.boundsInParent == null) {
            this.boundsInParent = new Rect(b);
        } else {
            this.boundsInParent.set(b);
        }
    }

    @Implementation
    public void addAction(int action) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            int id2;
            if ((action & ShadowAccessibilityNodeInfo.getActionTypeMaskFromFramework()) != 0) {
                throw new IllegalArgumentException("Action is not a combination of the standard actions: " + action);
            }
            for (int remainingIds = action; remainingIds > 0; remainingIds &= ~id2) {
                id2 = 1 << Integer.numberOfTrailingZeros(remainingIds);
                AccessibilityNodeInfo.AccessibilityAction convertedAction = ShadowAccessibilityNodeInfo.getActionFromIdFromFrameWork(id2);
                this.addAction(convertedAction);
            }
        } else {
            this.actionsMask |= action;
        }
    }

    @Implementation(minSdk=21)
    public void addAction(AccessibilityNodeInfo.AccessibilityAction action) {
        if (action == null) {
            return;
        }
        if (this.actionsArray == null) {
            this.actionsArray = new ArrayList();
        }
        this.actionsArray.remove(action);
        this.actionsArray.add(action);
    }

    @Implementation(minSdk=21)
    public void removeAction(int action) {
        AccessibilityNodeInfo.AccessibilityAction convertedAction = ShadowAccessibilityNodeInfo.getActionFromIdFromFrameWork(action);
        this.removeAction(convertedAction);
    }

    @Implementation(minSdk=21)
    public boolean removeAction(AccessibilityNodeInfo.AccessibilityAction action) {
        if (action == null || this.actionsArray == null) {
            return false;
        }
        return this.actionsArray.remove(action);
    }

    @Implementation
    public int getActions() {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            int returnValue = 0;
            if (this.actionsArray == null) {
                return returnValue;
            }
            int actionSize = this.actionsArray.size();
            for (int i = 0; i < actionSize; ++i) {
                int actionId = this.actionsArray.get(i).getId();
                if (actionId > ShadowAccessibilityNodeInfo.getLastLegacyActionFromFrameWork()) continue;
                returnValue |= actionId;
            }
            return returnValue;
        }
        return this.actionsMask;
    }

    @Implementation(minSdk=21)
    public AccessibilityWindowInfo getWindow() {
        return this.accessibilityWindowInfo;
    }

    public void setAccessibilityWindowInfo(AccessibilityWindowInfo info) {
        this.accessibilityWindowInfo = info;
    }

    @Implementation(minSdk=21)
    public List<AccessibilityNodeInfo.AccessibilityAction> getActionList() {
        if (this.actionsArray == null) {
            return Collections.emptyList();
        }
        return this.actionsArray;
    }

    @Implementation
    public boolean performAction(int action) {
        return this.performAction(action, null);
    }

    @Implementation
    public boolean performAction(int action, Bundle arguments) {
        if (this.performedActionAndArgsList == null) {
            this.performedActionAndArgsList = new LinkedList<Pair<Integer, Bundle>>();
        }
        this.performedActionAndArgsList.add((Pair<Integer, Bundle>)new Pair((Object)action, (Object)arguments));
        return this.actionListener == null || this.actionListener.onPerformAccessibilityAction(action, arguments);
    }

    private boolean childrenEqualityCheck(ShadowAccessibilityNodeInfo otherShadow, LinkedList<ShadowAccessibilityNodeInfo> visitedNodes) {
        if (this.children == null) {
            return otherShadow.getChildCount() == 0;
        }
        if (this.getChildCount() != otherShadow.getChildCount()) {
            return false;
        }
        boolean childrenEquality = true;
        for (int i = 0; i < this.children.size(); ++i) {
            AccessibilityNodeInfo child = this.children.get(i);
            ShadowAccessibilityNodeInfo childShadow = Shadows.shadowOf(child);
            if (childShadow.visitedWhenCheckingChildren) continue;
            AccessibilityNodeInfo otherChild = otherShadow.children.get(i);
            visitedNodes.add(childShadow);
            childShadow.visitedWhenCheckingChildren = true;
            if (!child.equals((Object)otherChild)) {
                childrenEquality = false;
                break;
            }
            childrenEquality = childShadow.childrenEqualityCheck(Shadows.shadowOf(otherChild), visitedNodes);
        }
        return childrenEquality;
    }

    @Implementation
    public boolean equals(Object object) {
        if (!(object instanceof AccessibilityNodeInfo)) {
            return false;
        }
        AccessibilityNodeInfo info = (AccessibilityNodeInfo)object;
        ShadowAccessibilityNodeInfo otherShadow = Shadows.shadowOf(info);
        boolean areEqual = true;
        if (this.children == null) {
            areEqual &= otherShadow.children == null;
        } else {
            LinkedList<ShadowAccessibilityNodeInfo> visitedNodes = new LinkedList<ShadowAccessibilityNodeInfo>();
            areEqual &= otherShadow.children != null && this.childrenEqualityCheck(otherShadow, visitedNodes);
            if (this.parent == null) {
                areEqual &= otherShadow.parent == null;
            } else if (!Shadows.shadowOf((AccessibilityNodeInfo)this.parent).visitedWhenCheckingChildren) {
                areEqual &= otherShadow.parent != null && Shadows.shadowOf(this.parent).equals(Shadows.shadowOf(otherShadow.parent));
            }
            while (!visitedNodes.isEmpty()) {
                ShadowAccessibilityNodeInfo visitedNode = visitedNodes.remove();
                visitedNode.visitedWhenCheckingChildren = false;
            }
        }
        areEqual &= this.propertyFlags == otherShadow.propertyFlags;
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            boolean actionsArrayEquality = false;
            actionsArrayEquality = this.actionsArray == null && otherShadow.actionsArray == null ? true : (this.actionsArray == null || otherShadow.actionsArray == null ? false : this.actionsArray.equals(otherShadow.actionsArray));
            areEqual &= actionsArrayEquality;
            areEqual = this.accessibilityWindowInfo == null ? (areEqual &= otherShadow.accessibilityWindowInfo == null) : (areEqual &= otherShadow.accessibilityWindowInfo != null && this.accessibilityWindowInfo.equals((Object)otherShadow.accessibilityWindowInfo));
        } else {
            areEqual &= this.actionsMask == otherShadow.actionsMask;
        }
        areEqual = this.labelFor == null ? (areEqual &= otherShadow.labelFor == null) : (areEqual &= this.labelFor.equals((Object)otherShadow.labelFor));
        areEqual = this.labeledBy == null ? (areEqual &= otherShadow.labeledBy == null) : (areEqual &= this.labeledBy.equals((Object)otherShadow.labeledBy));
        areEqual &= this.boundsInScreen.equals((Object)otherShadow.boundsInScreen);
        areEqual &= TextUtils.equals((CharSequence)this.contentDescription, (CharSequence)otherShadow.contentDescription);
        areEqual &= TextUtils.equals((CharSequence)this.text, (CharSequence)otherShadow.text);
        areEqual &= TextUtils.equals((CharSequence)this.className, (CharSequence)otherShadow.className);
        areEqual &= this.view == otherShadow.view;
        areEqual &= this.textSelectionStart == otherShadow.textSelectionStart;
        areEqual &= this.textSelectionEnd == otherShadow.textSelectionEnd;
        areEqual &= this.refreshReturnValue == otherShadow.refreshReturnValue;
        areEqual &= this.movementGranularities == otherShadow.movementGranularities;
        areEqual &= TextUtils.isEmpty((CharSequence)this.packageName) == TextUtils.isEmpty((CharSequence)otherShadow.packageName);
        if (!TextUtils.isEmpty((CharSequence)this.packageName)) {
            areEqual &= this.packageName.toString().equals(otherShadow.packageName.toString());
        }
        if (RuntimeEnvironment.getApiLevel() >= 18) {
            areEqual &= TextUtils.equals((CharSequence)this.viewIdResourceName, (CharSequence)otherShadow.viewIdResourceName);
        }
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            areEqual = this.collectionInfo == null ? (areEqual &= otherShadow.collectionInfo == null) : (areEqual &= this.collectionInfo.equals(otherShadow.collectionInfo));
            areEqual = this.collectionItemInfo == null ? (areEqual &= otherShadow.collectionItemInfo == null) : (areEqual &= this.collectionItemInfo.equals(otherShadow.collectionItemInfo));
            areEqual &= this.inputType == otherShadow.inputType;
            areEqual &= this.liveRegion == otherShadow.liveRegion;
            areEqual = this.rangeInfo == null ? (areEqual &= otherShadow.rangeInfo == null) : (areEqual &= this.rangeInfo.equals(otherShadow.rangeInfo));
        }
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            areEqual &= this.maxTextLength == otherShadow.maxTextLength;
            areEqual &= TextUtils.equals((CharSequence)this.error, (CharSequence)otherShadow.error);
        }
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            areEqual = this.traversalAfter == null ? (areEqual &= otherShadow.traversalAfter == null) : (areEqual &= this.traversalAfter.equals((Object)otherShadow.traversalAfter));
            areEqual = this.traversalBefore == null ? (areEqual &= otherShadow.traversalBefore == null) : (areEqual &= this.traversalBefore.equals((Object)otherShadow.traversalBefore));
        }
        return areEqual;
    }

    @Implementation
    public int hashCode() {
        return 0;
    }

    public void addChild(AccessibilityNodeInfo child) {
        if (this.children == null) {
            this.children = new LinkedList<AccessibilityNodeInfo>();
        }
        this.children.add(child);
        Shadows.shadowOf((AccessibilityNodeInfo)child).parent = this.realAccessibilityNodeInfo;
    }

    @Implementation
    public void addChild(View child) {
        AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain((View)child);
        this.addChild(node);
    }

    @Implementation
    public void addChild(View root, int virtualDescendantId) {
        AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain((View)root, (int)virtualDescendantId);
        this.addChild(node);
    }

    public List<Integer> getPerformedActions() {
        if (this.performedActionAndArgsList == null) {
            this.performedActionAndArgsList = new LinkedList<Pair<Integer, Bundle>>();
        }
        LinkedList<Integer> actionsOnly = new LinkedList<Integer>();
        Iterator<Pair<Integer, Bundle>> iter = this.performedActionAndArgsList.iterator();
        while (iter.hasNext()) {
            actionsOnly.add((Integer)iter.next().first);
        }
        return Collections.unmodifiableList(actionsOnly);
    }

    public List<Pair<Integer, Bundle>> getPerformedActionsWithArgs() {
        if (this.performedActionAndArgsList == null) {
            this.performedActionAndArgsList = new LinkedList<Pair<Integer, Bundle>>();
        }
        return Collections.unmodifiableList(this.performedActionAndArgsList);
    }

    private AccessibilityNodeInfo getClone() {
        AccessibilityNodeInfo newInfo = (AccessibilityNodeInfo)ReflectionHelpers.callConstructor(AccessibilityNodeInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowAccessibilityNodeInfo newShadow = Shadows.shadowOf(newInfo);
        newShadow.boundsInScreen = new Rect(this.boundsInScreen);
        newShadow.propertyFlags = this.propertyFlags;
        newShadow.contentDescription = this.contentDescription;
        newShadow.text = this.text;
        newShadow.performedActionAndArgsList = this.performedActionAndArgsList;
        newShadow.parent = this.parent;
        newShadow.className = this.className;
        newShadow.labeledBy = this.labeledBy;
        newShadow.view = this.view;
        newShadow.textSelectionStart = this.textSelectionStart;
        newShadow.textSelectionEnd = this.textSelectionEnd;
        newShadow.actionListener = this.actionListener;
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            if (this.actionsArray != null) {
                newShadow.actionsArray = new ArrayList();
                newShadow.actionsArray.addAll(this.actionsArray);
            } else {
                newShadow.actionsArray = null;
            }
        } else {
            newShadow.actionsMask = this.actionsMask;
        }
        if (this.children != null) {
            newShadow.children = new LinkedList<AccessibilityNodeInfo>();
            newShadow.children.addAll(this.children);
        } else {
            newShadow.children = null;
        }
        newShadow.refreshReturnValue = this.refreshReturnValue;
        newShadow.movementGranularities = this.movementGranularities;
        newShadow.packageName = this.packageName;
        if (RuntimeEnvironment.getApiLevel() >= 18) {
            newShadow.viewIdResourceName = this.viewIdResourceName;
        }
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            newShadow.collectionInfo = this.collectionInfo;
            newShadow.collectionItemInfo = this.collectionItemInfo;
            newShadow.inputType = this.inputType;
            newShadow.liveRegion = this.liveRegion;
            newShadow.rangeInfo = this.rangeInfo;
        }
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            newShadow.maxTextLength = this.maxTextLength;
            newShadow.error = this.error;
        }
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            newShadow.traversalAfter = this.traversalAfter == null ? null : ShadowAccessibilityNodeInfo.obtain(this.traversalAfter);
            newShadow.traversalBefore = this.traversalBefore == null ? null : ShadowAccessibilityNodeInfo.obtain(this.traversalBefore);
        }
        return newInfo;
    }

    @Implementation
    public int describeContents() {
        return 0;
    }

    @Implementation
    public void writeToParcel(Parcel dest, int flags) {
        StrictEqualityNodeWrapper wrapper = new StrictEqualityNodeWrapper(this.realAccessibilityNodeInfo);
        int keyOfWrapper = -1;
        for (int i = 0; i < orderedInstances.size(); ++i) {
            if (!((StrictEqualityNodeWrapper)orderedInstances.valueAt(i)).equals(wrapper)) continue;
            keyOfWrapper = orderedInstances.keyAt(i);
            break;
        }
        dest.writeInt(keyOfWrapper);
    }

    private static int getActionTypeMaskFromFramework() {
        return (Integer)ReflectionHelpers.getStaticField(AccessibilityNodeInfo.class, (String)"ACTION_TYPE_MASK");
    }

    private static AccessibilityNodeInfo.AccessibilityAction getActionFromIdFromFrameWork(int id2) {
        return (AccessibilityNodeInfo.AccessibilityAction)ReflectionHelpers.callStaticMethod(AccessibilityNodeInfo.class, (String)"getActionSingleton", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2)});
    }

    private static int getLastLegacyActionFromFrameWork() {
        return (Integer)ReflectionHelpers.getStaticField(AccessibilityNodeInfo.class, (String)"LAST_LEGACY_STANDARD_ACTION");
    }

    public void setOnPerformActionListener(OnPerformActionListener listener) {
        this.actionListener = listener;
    }

    public static interface OnPerformActionListener {
        public boolean onPerformAccessibilityAction(int var1, Bundle var2);
    }

    @Implements(value=AccessibilityNodeInfo.AccessibilityAction.class, minSdk=21)
    public static final class ShadowAccessibilityAction {
        private int id;
        private CharSequence label;

        @Implementation
        public void __constructor__(int id2, CharSequence label) {
            if ((id2 & (Integer)ReflectionHelpers.getStaticField(AccessibilityNodeInfo.class, (String)"ACTION_TYPE_MASK")) == 0 && Integer.bitCount(id2) != 1) {
                throw new IllegalArgumentException("Invalid standard action id");
            }
            this.id = id2;
            this.label = label;
        }

        @Implementation
        public int getId() {
            return this.id;
        }

        @Implementation
        public CharSequence getLabel() {
            return this.label;
        }

        @Implementation
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != AccessibilityNodeInfo.AccessibilityAction.class) {
                return false;
            }
            return this.id == ((AccessibilityNodeInfo.AccessibilityAction)other).getId();
        }

        public String toString() {
            String actionSybolicName = (String)ReflectionHelpers.callStaticMethod(AccessibilityNodeInfo.class, (String)"getActionSymbolicName", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.id)});
            return "AccessibilityAction: " + actionSybolicName + " - " + this.label;
        }
    }

    private static class StrictEqualityNodeWrapper {
        public final AccessibilityNodeInfo mInfo;

        public StrictEqualityNodeWrapper(AccessibilityNodeInfo info) {
            this.mInfo = info;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            StrictEqualityNodeWrapper wrapper = (StrictEqualityNodeWrapper)object;
            return this.mInfo == wrapper.mInfo;
        }

        public int hashCode() {
            return this.mInfo.hashCode();
        }
    }
}

