/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=TelecomManager.class, minSdk=21)
public class ShadowTelecomManager {
    @RealObject
    private TelecomManager realObject;
    private PhoneAccountHandle simCallManager;
    private LinkedHashMap<PhoneAccountHandle, PhoneAccount> accounts = new LinkedHashMap();
    private List<CallRecord> incomingCalls = new LinkedList<CallRecord>();
    private List<CallRecord> unknownCalls = new LinkedList<CallRecord>();
    private String defaultDialerPackageName;

    @Implementation
    public PhoneAccountHandle getDefaultOutgoingPhoneAccount(String uriScheme) {
        return null;
    }

    @Implementation
    public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount() {
        return null;
    }

    @Implementation
    public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle accountHandle) {
    }

    @Implementation
    public PhoneAccountHandle getSimCallManager() {
        return this.simCallManager;
    }

    @Implementation
    public PhoneAccountHandle getSimCallManager(int userId) {
        return null;
    }

    @Implementation
    public PhoneAccountHandle getConnectionManager() {
        return this.getSimCallManager();
    }

    @Implementation
    public List<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String uriScheme) {
        LinkedList<PhoneAccountHandle> result = new LinkedList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            PhoneAccount phoneAccount = this.accounts.get(handle);
            if (!phoneAccount.getSupportedUriSchemes().contains(uriScheme)) continue;
            result.add(handle);
        }
        return result;
    }

    @Implementation(minSdk=23)
    public List<PhoneAccountHandle> getCallCapablePhoneAccounts() {
        return this.getCallCapablePhoneAccounts(false);
    }

    @Implementation(minSdk=23)
    public List<PhoneAccountHandle> getCallCapablePhoneAccounts(boolean includeDisabledAccounts) {
        LinkedList<PhoneAccountHandle> result = new LinkedList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            PhoneAccount phoneAccount = this.accounts.get(handle);
            if (!phoneAccount.isEnabled() && !includeDisabledAccounts) continue;
            result.add(handle);
        }
        return result;
    }

    @Implementation
    public List<PhoneAccountHandle> getPhoneAccountsForPackage() {
        Context context = (Context)ReflectionHelpers.getField((Object)this.realObject, (String)"mContext");
        LinkedList<PhoneAccountHandle> results = new LinkedList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            if (!handle.getComponentName().getPackageName().equals(context.getPackageName())) continue;
            results.add(handle);
        }
        return results;
    }

    @Implementation
    public PhoneAccount getPhoneAccount(PhoneAccountHandle account) {
        return this.accounts.get(account);
    }

    @Implementation
    public int getAllPhoneAccountsCount() {
        return this.accounts.size();
    }

    @Implementation
    public List<PhoneAccount> getAllPhoneAccounts() {
        return ImmutableList.copyOf(this.accounts.values());
    }

    @Implementation
    public List<PhoneAccountHandle> getAllPhoneAccountHandles() {
        return ImmutableList.copyOf(this.accounts.keySet());
    }

    @Implementation
    public void registerPhoneAccount(PhoneAccount account) {
        this.accounts.put(account.getAccountHandle(), account);
    }

    @Implementation
    public void unregisterPhoneAccount(PhoneAccountHandle accountHandle) {
        this.accounts.remove(accountHandle);
    }

    @Deprecated
    @Implementation
    public void clearAccounts() {
        this.accounts.clear();
    }

    @Implementation(minSdk=22)
    public void clearAccountsForPackage(String packageName) {
        HashSet<PhoneAccountHandle> phoneAccountHandlesInPackage = new HashSet<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            if (!handle.getComponentName().getPackageName().equals(packageName)) continue;
            phoneAccountHandlesInPackage.add(handle);
        }
        for (PhoneAccountHandle handle : phoneAccountHandlesInPackage) {
            this.accounts.remove(handle);
        }
    }

    @Deprecated
    @Implementation
    public ComponentName getDefaultPhoneApp() {
        return null;
    }

    @Implementation(minSdk=23)
    public String getDefaultDialerPackage() {
        return this.defaultDialerPackageName;
    }

    @Implementation(minSdk=23)
    public boolean setDefaultDialer(String packageName) {
        this.defaultDialerPackageName = packageName;
        return true;
    }

    @Implementation
    public String getSystemDialerPackage() {
        return null;
    }

    @Implementation
    public boolean isVoiceMailNumber(PhoneAccountHandle accountHandle, String number) {
        return false;
    }

    @Implementation
    public String getVoiceMailNumber(PhoneAccountHandle accountHandle) {
        return null;
    }

    @Implementation
    public String getLine1Number(PhoneAccountHandle accountHandle) {
        return null;
    }

    @Implementation
    public boolean isInCall() {
        return false;
    }

    @Implementation
    public int getCallState() {
        return 0;
    }

    @Implementation
    public boolean isRinging() {
        return false;
    }

    @Implementation
    public boolean endCall() {
        return false;
    }

    @Implementation
    public void acceptRingingCall() {
    }

    @Implementation
    public void silenceRinger() {
    }

    @Implementation
    public boolean isTtySupported() {
        return false;
    }

    @Implementation
    public int getCurrentTtyMode() {
        return 0;
    }

    @Implementation
    public void addNewIncomingCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        this.incomingCalls.add(new CallRecord(phoneAccount, extras));
    }

    public List<CallRecord> getAllIncomingCalls() {
        return this.incomingCalls;
    }

    @Implementation
    public void addNewUnknownCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        this.unknownCalls.add(new CallRecord(phoneAccount, extras));
    }

    public List<CallRecord> getAllUnknownCalls() {
        return this.unknownCalls;
    }

    @Implementation
    public boolean handleMmi(String dialString) {
        return false;
    }

    @Implementation
    public boolean handleMmi(String dialString, PhoneAccountHandle accountHandle) {
        return false;
    }

    @Implementation
    public Uri getAdnUriForPhoneAccount(PhoneAccountHandle accountHandle) {
        return Uri.parse((String)"content://icc/adn");
    }

    @Implementation
    public void cancelMissedCallsNotification() {
    }

    @Implementation
    public void showInCallScreen(boolean showDialpad) {
    }

    @Implementation
    public void placeCall(Uri address, Bundle extras) {
    }

    @Implementation
    public void enablePhoneAccount(PhoneAccountHandle handle, boolean isEnabled) {
    }

    public void setSimCallManager(PhoneAccountHandle simCallManager) {
        this.simCallManager = simCallManager;
    }

    public static class CallRecord {
        public final PhoneAccountHandle phoneAccount;
        public final Bundle bundle;

        public CallRecord(PhoneAccountHandle phoneAccount, Bundle extras) {
            this.phoneAccount = phoneAccount;
            this.bundle = extras;
        }
    }
}

