/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Resources;
import android.content.res.TypedArray;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=TypedArray.class)
public class ShadowTypedArray {
    @RealObject
    private TypedArray realTypedArray;
    private CharSequence[] stringData;
    public String positionDescription;
    private static final ImmutableMap<Integer, String> TYPE_MAP = ImmutableMap.builder().put((Object)0, (Object)"TYPE_NULL").put((Object)1, (Object)"TYPE_REFERENCE").put((Object)2, (Object)"TYPE_ATTRIBUTE").put((Object)3, (Object)"TYPE_STRING").put((Object)4, (Object)"TYPE_FLOAT").put((Object)5, (Object)"TYPE_DIMENSION").put((Object)6, (Object)"TYPE_FRACTION").put((Object)16, (Object)"TYPE_INT_DEC").put((Object)17, (Object)"TYPE_INT_HEX").put((Object)18, (Object)"TYPE_INT_BOOLEAN").put((Object)28, (Object)"TYPE_INT_COLOR_ARGB8").put((Object)29, (Object)"TYPE_INT_COLOR_RGB8").put((Object)30, (Object)"TYPE_INT_COLOR_ARGB4").put((Object)31, (Object)"TYPE_INT_COLOR_RGB4").build();

    public static TypedArray create(Resources realResources, int[] attrs, int[] data, int[] indices, int len, CharSequence[] stringData) {
        TypedArray typedArray;
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            typedArray = (TypedArray)ReflectionHelpers.callConstructor(TypedArray.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Resources.class, (Object)realResources)});
            ReflectionHelpers.setField((Object)typedArray, (String)"mData", (Object)data);
            ReflectionHelpers.setField((Object)typedArray, (String)"mLength", (Object)len);
            ReflectionHelpers.setField((Object)typedArray, (String)"mIndices", (Object)indices);
        } else {
            typedArray = (TypedArray)ReflectionHelpers.callConstructor(TypedArray.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Resources.class, (Object)realResources), ReflectionHelpers.ClassParameter.from(int[].class, (Object)data), ReflectionHelpers.ClassParameter.from(int[].class, (Object)indices), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)len)});
        }
        Shadows.shadowOf((TypedArray)typedArray).stringData = stringData;
        return typedArray;
    }

    @HiddenApi
    @Implementation
    public CharSequence loadStringValueAt(int index) {
        return this.stringData[index / 6];
    }

    @Implementation
    public String getPositionDescription() {
        return this.positionDescription;
    }

    public static void dump(TypedArray typedArray) {
        int[] data = (int[])ReflectionHelpers.getField((Object)typedArray, (String)"mData");
        StringBuilder result = new StringBuilder();
        for (int index = 0; index < data.length; index += 6) {
            int type = data[index + 0];
            result.append("Index: ").append(index / 6).append(System.lineSeparator());
            result.append(Strings.padEnd((String)"Type: ", (int)25, (char)' ')).append((String)TYPE_MAP.get((Object)type)).append(System.lineSeparator());
            if (type != 0) {
                result.append(Strings.padEnd((String)"Style data: ", (int)25, (char)' ')).append(data[index + 1]).append(System.lineSeparator());
                result.append(Strings.padEnd((String)"Asset cookie ", (int)25, (char)' ')).append(data[index + 2]).append(System.lineSeparator());
                result.append(Strings.padEnd((String)"Style resourceId: ", (int)25, (char)' ')).append(data[index + 3]).append(System.lineSeparator());
                result.append(Strings.padEnd((String)"Changing configurations ", (int)25, (char)' ')).append(data[index + 4]).append(System.lineSeparator());
                result.append(Strings.padEnd((String)"Style density: ", (int)25, (char)' ')).append(data[index + 5]).append(System.lineSeparator());
                if (type == 3) {
                    result.append(Strings.padEnd((String)"Style value: ", (int)25, (char)' ')).append(Shadows.shadowOf(typedArray).loadStringValueAt(index)).append(System.lineSeparator());
                }
            }
            result.append(System.lineSeparator());
        }
        System.out.println(result.toString());
    }
}

