/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Environment;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Environment.class)
public class ShadowEnvironment {
    private static String externalStorageState = "removed";
    private static final Map<File, Boolean> STORAGE_EMULATED = new HashMap<File, Boolean>();
    private static final Map<File, Boolean> STORAGE_REMOVABLE = new HashMap<File, Boolean>();
    private static boolean sIsExternalStorageEmulated;
    private static Path tmpExternalFilesDirBase;
    private static final List<File> externalDirs;
    private static Map<Path, String> storageState;
    static Path EXTERNAL_CACHE_DIR;
    static Path EXTERNAL_FILES_DIR;

    @Implementation
    public static String getExternalStorageState() {
        return externalStorageState;
    }

    public static void setExternalStorageState(String externalStorageState) {
        ShadowEnvironment.externalStorageState = externalStorageState;
    }

    public static void setIsExternalStorageEmulated(boolean emulated) {
        sIsExternalStorageEmulated = emulated;
    }

    @Implementation
    public static File getExternalStorageDirectory() {
        if (!ShadowEnvironment.exists(EXTERNAL_CACHE_DIR)) {
            EXTERNAL_CACHE_DIR = RuntimeEnvironment.getTempDirectory().create("external-cache");
        }
        return EXTERNAL_CACHE_DIR.toFile();
    }

    @Implementation
    public static File getExternalStoragePublicDirectory(String type) {
        if (!ShadowEnvironment.exists(EXTERNAL_FILES_DIR)) {
            EXTERNAL_FILES_DIR = RuntimeEnvironment.getTempDirectory().create("external-files");
        }
        if (type == null) {
            return EXTERNAL_FILES_DIR.toFile();
        }
        Path path = EXTERNAL_FILES_DIR.resolve(type);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path.toFile();
    }

    @Resetter
    public static void reset() {
        EXTERNAL_CACHE_DIR = null;
        EXTERNAL_FILES_DIR = null;
        STORAGE_EMULATED.clear();
        STORAGE_REMOVABLE.clear();
        storageState = new HashMap<Path, String>();
        externalDirs.clear();
        sIsExternalStorageEmulated = false;
    }

    private static boolean exists(Path path) {
        return path != null && Files.exists(path, new LinkOption[0]);
    }

    @Implementation
    public static boolean isExternalStorageRemovable() {
        Boolean exists = STORAGE_REMOVABLE.get(ShadowEnvironment.getExternalStorageDirectory());
        return exists != null ? exists : false;
    }

    @Implementation(minSdk=19)
    public static String getStorageState(File directory) {
        Path directoryPath = directory.toPath();
        for (Map.Entry<Path, String> entry : storageState.entrySet()) {
            if (!directoryPath.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Implementation(minSdk=21)
    public static String getExternalStorageState(File directory) {
        Path directoryPath = directory.toPath();
        for (Map.Entry<Path, String> entry : storageState.entrySet()) {
            if (!directoryPath.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Implementation(minSdk=21)
    public static boolean isExternalStorageRemovable(File path) {
        Boolean exists = STORAGE_REMOVABLE.get(path);
        return exists != null ? exists : false;
    }

    @Implementation(minSdk=21)
    public static boolean isExternalStorageEmulated(File path) {
        Boolean emulated = STORAGE_EMULATED.get(path);
        return emulated != null ? emulated : false;
    }

    @Implementation
    public static boolean isExternalStorageEmulated() {
        return sIsExternalStorageEmulated;
    }

    public static void setExternalStorageRemovable(File file, boolean isRemovable) {
        STORAGE_REMOVABLE.put(file, isRemovable);
    }

    public static void setExternalStorageEmulated(File file, boolean isEmulated) {
        STORAGE_EMULATED.put(file, isEmulated);
    }

    public static File addExternalDir(String path) {
        Path externalFileDir;
        if (path == null) {
            externalFileDir = null;
        } else {
            try {
                if (tmpExternalFilesDirBase == null) {
                    tmpExternalFilesDirBase = RuntimeEnvironment.getTempDirectory().create("external-files-base");
                }
                externalFileDir = tmpExternalFilesDirBase.resolve(path);
                Files.createDirectories(externalFileDir, new FileAttribute[0]);
                externalDirs.add(externalFileDir.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create external files dir", e);
            }
        }
        if (RuntimeEnvironment.getApiLevel() >= 17 && RuntimeEnvironment.getApiLevel() < 19) {
            if (externalDirs.size() == 1 && externalFileDir != null) {
                Environment.UserEnvironment userEnvironment = (Environment.UserEnvironment)ReflectionHelpers.getStaticField(Environment.class, (String)"sCurrentUser");
                ReflectionHelpers.setField((Object)userEnvironment, (String)"mExternalStorageAndroidData", (Object)externalFileDir.toFile());
            }
        } else if (RuntimeEnvironment.getApiLevel() >= 19 && RuntimeEnvironment.getApiLevel() < 23) {
            Environment.UserEnvironment userEnvironment = (Environment.UserEnvironment)ReflectionHelpers.getStaticField(Environment.class, (String)"sCurrentUser");
            ReflectionHelpers.setField((Object)userEnvironment, (String)"mExternalDirsForApp", (Object)externalDirs.toArray(new File[externalDirs.size()]));
        }
        if (externalFileDir == null) {
            return null;
        }
        return externalFileDir.toFile();
    }

    public static void setExternalStorageState(File directory, String state) {
        storageState.put(directory.toPath(), state);
    }

    static {
        externalDirs = new ArrayList<File>();
        storageState = new HashMap<Path, String>();
    }

    @Implements(className="android.os.Environment$UserEnvironment", isInAndroidSdk=false)
    public static class ShadowUserEnvironment {
        @Implementation
        public File[] getExternalDirs() {
            return externalDirs.toArray(new File[externalDirs.size()]);
        }
    }
}

