/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.Account;
import android.annotation.SuppressLint;
import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.UriPermission;
import android.content.pm.ProviderInfo;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import com.google.common.base.Splitter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.fakes.BaseCursor;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowContentProviderClient;
import org.robolectric.util.NamedStream;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ContentResolver.class)
@SuppressLint(value={"NewApi"})
public class ShadowContentResolver {
    private int nextDatabaseIdForInserts;
    @RealObject
    ContentResolver realContentResolver;
    private BaseCursor cursor;
    private static final List<Statement> statements = new CopyOnWriteArrayList<Statement>();
    private static final List<InsertStatement> insertStatements = new CopyOnWriteArrayList<InsertStatement>();
    private static final List<UpdateStatement> updateStatements = new CopyOnWriteArrayList<UpdateStatement>();
    private static final List<DeleteStatement> deleteStatements = new CopyOnWriteArrayList<DeleteStatement>();
    private static final List<NotifiedUri> notifiedUris = new ArrayList<NotifiedUri>();
    private static final Map<Uri, BaseCursor> uriCursorMap = new HashMap<Uri, BaseCursor>();
    private static final Map<Uri, Supplier<InputStream>> inputStreamMap = new HashMap<Uri, Supplier<InputStream>>();
    private static final Map<Uri, Supplier<OutputStream>> outputStreamMap = new HashMap<Uri, Supplier<OutputStream>>();
    private static final Map<String, List<ContentProviderOperation>> contentProviderOperations = new HashMap<String, List<ContentProviderOperation>>();
    private static ContentProviderResult[] contentProviderResults;
    private static final List<UriPermission> uriPermissions;
    private static final CopyOnWriteArrayList<ContentObserverEntry> contentObservers;
    private static final Map<String, Map<Account, Status>> syncableAccounts;
    private static final Map<String, ContentProvider> providers;
    private static boolean masterSyncAutomatically;
    private static SyncAdapterType[] syncAdapterTypes;
    private final Map<Uri, RuntimeException> registerContentProviderExceptions = new HashMap<Uri, RuntimeException>();

    @Resetter
    public static void reset() {
        statements.clear();
        insertStatements.clear();
        updateStatements.clear();
        deleteStatements.clear();
        notifiedUris.clear();
        uriCursorMap.clear();
        inputStreamMap.clear();
        outputStreamMap.clear();
        contentProviderOperations.clear();
        contentProviderResults = null;
        uriPermissions.clear();
        contentObservers.clear();
        syncableAccounts.clear();
        providers.clear();
        masterSyncAutomatically = false;
    }

    public void registerInputStream(Uri uri, InputStream inputStream) {
        inputStreamMap.put(uri, () -> inputStream);
    }

    public void registerInputStreamSupplier(Uri uri, Supplier<InputStream> supplier) {
        inputStreamMap.put(uri, supplier);
    }

    public void registerOutputStream(Uri uri, OutputStream outputStream) {
        outputStreamMap.put(uri, () -> outputStream);
    }

    public void registerOutputStreamSupplier(Uri uri, Supplier<OutputStream> supplier) {
        outputStreamMap.put(uri, supplier);
    }

    @Implementation
    protected final InputStream openInputStream(Uri uri) throws FileNotFoundException {
        InputStream inputStream;
        Supplier<InputStream> supplier = inputStreamMap.get(uri);
        if (supplier != null && (inputStream = supplier.get()) != null) {
            return inputStream;
        }
        String scheme = uri.getScheme();
        if ("android.resource".equals(scheme) || "file".equals(scheme) || "content".equals(scheme) && ShadowContentResolver.getProvider(uri, this.getContext()) != null) {
            return ((ContentResolverReflector)Reflector.reflector(ContentResolverReflector.class, (Object)this.realContentResolver)).openInputStream(uri);
        }
        return new UnregisteredInputStream(uri);
    }

    @Implementation
    protected final OutputStream openOutputStream(final Uri uri) throws FileNotFoundException {
        try {
            return this.openOutputStream(uri, "w");
        }
        catch (FileNotFoundException | SecurityException e) {
            return new OutputStream(){

                @Override
                public void write(int arg0) throws IOException {
                }

                public String toString() {
                    return "outputstream for " + uri;
                }
            };
        }
    }

    @Implementation
    protected final OutputStream openOutputStream(Uri uri, String mode) throws FileNotFoundException {
        OutputStream outputStream;
        Supplier<OutputStream> supplier = outputStreamMap.get(uri);
        if (supplier != null && (outputStream = supplier.get()) != null) {
            return outputStream;
        }
        return ((ContentResolverReflector)Reflector.reflector(ContentResolverReflector.class, (Object)this.realContentResolver)).openOutputStream(uri, mode);
    }

    @Implementation
    protected final Uri insert(Uri url, ContentValues values) {
        ContentProvider provider = ShadowContentResolver.getProvider(url, this.getContext());
        ContentValues valuesCopy = values == null ? null : new ContentValues(values);
        InsertStatement insertStatement = new InsertStatement(url, provider, valuesCopy);
        statements.add(insertStatement);
        insertStatements.add(insertStatement);
        if (provider != null) {
            return provider.insert(url, values);
        }
        return Uri.parse((String)(url.toString() + "/" + ++this.nextDatabaseIdForInserts));
    }

    private Context getContext() {
        return ((ContentResolverReflector)Reflector.reflector(ContentResolverReflector.class, (Object)this.realContentResolver)).getContext();
    }

    @Implementation
    protected int update(Uri uri, ContentValues values, String where, String[] selectionArgs) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri, this.getContext());
        ContentValues valuesCopy = values == null ? null : new ContentValues(values);
        UpdateStatement updateStatement = new UpdateStatement(uri, provider, valuesCopy, where, selectionArgs);
        statements.add(updateStatement);
        updateStatements.add(updateStatement);
        if (provider != null) {
            return provider.update(uri, values, where, selectionArgs);
        }
        return 1;
    }

    @Implementation(minSdk=26)
    protected final Cursor query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri, this.getContext());
        if (provider != null) {
            return provider.query(uri, projection, queryArgs, cancellationSignal);
        }
        BaseCursor returnCursor = this.getCursor(uri);
        if (returnCursor == null) {
            return null;
        }
        String selection = queryArgs.getString("android:query-arg-sql-selection");
        String[] selectionArgs = queryArgs.getStringArray("android:query-arg-sql-selection-args");
        String sortOrder = queryArgs.getString("android:query-arg-sql-sort-order");
        returnCursor.setQuery(uri, projection, selection, selectionArgs, sortOrder);
        return returnCursor;
    }

    @Implementation
    protected final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri, this.getContext());
        if (provider != null) {
            return provider.query(uri, projection, selection, selectionArgs, sortOrder);
        }
        BaseCursor returnCursor = this.getCursor(uri);
        if (returnCursor == null) {
            return null;
        }
        returnCursor.setQuery(uri, projection, selection, selectionArgs, sortOrder);
        return returnCursor;
    }

    @Implementation
    protected Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri, this.getContext());
        if (provider != null) {
            return provider.query(uri, projection, selection, selectionArgs, sortOrder, cancellationSignal);
        }
        BaseCursor returnCursor = this.getCursor(uri);
        if (returnCursor == null) {
            return null;
        }
        returnCursor.setQuery(uri, projection, selection, selectionArgs, sortOrder);
        return returnCursor;
    }

    @Implementation
    protected String getType(Uri uri) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri, this.getContext());
        if (provider != null) {
            return provider.getType(uri);
        }
        return null;
    }

    @Implementation
    protected Bundle call(Uri uri, String method, String arg, Bundle extras) {
        ContentProvider cp = ShadowContentResolver.getProvider(uri, this.getContext());
        if (cp != null) {
            return cp.call(method, arg, extras);
        }
        return null;
    }

    @Implementation
    protected final ContentProviderClient acquireContentProviderClient(String name) {
        ContentProvider provider = ShadowContentResolver.getProvider(name, this.getContext());
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, true);
    }

    @Implementation
    protected final ContentProviderClient acquireContentProviderClient(Uri uri) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri, this.getContext());
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, true);
    }

    @Implementation
    protected final ContentProviderClient acquireUnstableContentProviderClient(String name) {
        ContentProvider provider = ShadowContentResolver.getProvider(name, this.getContext());
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, false);
    }

    @Implementation
    protected final ContentProviderClient acquireUnstableContentProviderClient(Uri uri) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri, this.getContext());
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, false);
    }

    private ContentProviderClient getContentProviderClient(ContentProvider provider, boolean stable) {
        ContentProviderClient client = (ContentProviderClient)ReflectionHelpers.callConstructor(ContentProviderClient.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ContentResolver.class, (Object)this.realContentResolver), ReflectionHelpers.ClassParameter.from(IContentProvider.class, (Object)provider.getIContentProvider()), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)stable)});
        ShadowContentProviderClient shadowContentProviderClient = (ShadowContentProviderClient)Shadow.extract((Object)client);
        shadowContentProviderClient.setContentProvider(provider);
        return client;
    }

    @Implementation
    protected final IContentProvider acquireProvider(String name) {
        return this.acquireUnstableProvider(name);
    }

    @Implementation
    protected final IContentProvider acquireProvider(Uri uri) {
        return this.acquireUnstableProvider(uri);
    }

    @Implementation
    protected final IContentProvider acquireUnstableProvider(String name) {
        ContentProvider cp = ShadowContentResolver.getProvider(name, this.getContext());
        if (cp != null) {
            return cp.getIContentProvider();
        }
        return null;
    }

    @Implementation
    protected final IContentProvider acquireUnstableProvider(Uri uri) {
        ContentProvider cp = ShadowContentResolver.getProvider(uri, this.getContext());
        if (cp != null) {
            return cp.getIContentProvider();
        }
        return null;
    }

    @Implementation
    protected final int delete(Uri url, String where, String[] selectionArgs) {
        ContentProvider provider = ShadowContentResolver.getProvider(url, this.getContext());
        DeleteStatement deleteStatement = new DeleteStatement(url, provider, where, selectionArgs);
        statements.add(deleteStatement);
        deleteStatements.add(deleteStatement);
        if (provider != null) {
            return provider.delete(url, where, selectionArgs);
        }
        return 1;
    }

    @Implementation
    protected final int bulkInsert(Uri url, ContentValues[] values) {
        ContentProvider provider = ShadowContentResolver.getProvider(url, this.getContext());
        InsertStatement insertStatement = new InsertStatement(url, provider, values);
        statements.add(insertStatement);
        insertStatements.add(insertStatement);
        if (provider != null) {
            return provider.bulkInsert(url, values);
        }
        return values.length;
    }

    @Implementation
    protected void notifyChange(Uri uri, ContentObserver observer, boolean syncToNetwork) {
        notifiedUris.add(new NotifiedUri(uri, observer, syncToNetwork));
        for (ContentObserverEntry entry : contentObservers) {
            if (!entry.matches(uri) || entry.observer == observer) continue;
            entry.observer.dispatchChange(false, uri);
        }
        if (observer != null && observer.deliverSelfNotifications()) {
            observer.dispatchChange(true, uri);
        }
    }

    @Implementation
    protected void notifyChange(Uri uri, ContentObserver observer) {
        this.notifyChange(uri, observer, false);
    }

    @Implementation
    protected ContentProviderResult[] applyBatch(String authority, ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        ContentProvider provider = ShadowContentResolver.getProvider(authority, this.getContext());
        if (provider != null) {
            return provider.applyBatch(operations);
        }
        contentProviderOperations.put(authority, operations);
        return contentProviderResults;
    }

    @Implementation
    protected static void requestSync(Account account, String authority, Bundle extras) {
        ShadowContentResolver.validateSyncExtrasBundle(extras);
        Status status = ShadowContentResolver.getStatus(account, authority, true);
        ++status.syncRequests;
        status.syncExtras = extras;
    }

    @Implementation
    protected static void cancelSync(Account account, String authority) {
        Status status = ShadowContentResolver.getStatus(account, authority);
        if (status != null) {
            status.syncRequests = 0;
            if (status.syncExtras != null) {
                status.syncExtras.clear();
            }
            if (status.syncs != null) {
                status.syncs.clear();
            }
        }
    }

    @Implementation
    protected static boolean isSyncActive(Account account, String authority) {
        Status status = ShadowContentResolver.getStatus(account, authority);
        return status != null && status.syncRequests > 0;
    }

    @Implementation
    protected static List<SyncInfo> getCurrentSyncs() {
        ArrayList<SyncInfo> list = new ArrayList<SyncInfo>();
        for (Map.Entry<String, Map<Account, Status>> map : syncableAccounts.entrySet()) {
            if (map.getValue() == null) continue;
            for (Map.Entry<Account, Status> mp : map.getValue().entrySet()) {
                if (!ShadowContentResolver.isSyncActive(mp.getKey(), map.getKey())) continue;
                SyncInfo si = ShadowContentResolver.newSyncInfo(0, mp.getKey(), map.getKey(), 0L);
                list.add(si);
            }
        }
        return list;
    }

    private static SyncInfo newSyncInfo(int authorityId, Account account, String authority, long startTime) {
        if (RuntimeEnvironment.getApiLevel() >= 18) {
            return new SyncInfo(authorityId, account, authority, startTime);
        }
        return (SyncInfo)ReflectionHelpers.callConstructor(SyncInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)authorityId), ReflectionHelpers.ClassParameter.from(Account.class, (Object)account), ReflectionHelpers.ClassParameter.from(String.class, (Object)authority), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)startTime)});
    }

    @Implementation
    protected static void setIsSyncable(Account account, String authority, int syncable) {
        ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).state = syncable;
    }

    @Implementation
    protected static int getIsSyncable(Account account, String authority) {
        return ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).state;
    }

    @Implementation
    protected static boolean getSyncAutomatically(Account account, String authority) {
        return ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncAutomatically;
    }

    @Implementation
    protected static void setSyncAutomatically(Account account, String authority, boolean sync) {
        ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncAutomatically = sync;
    }

    @Implementation
    protected static void addPeriodicSync(Account account, String authority, Bundle extras, long pollFrequency) {
        ShadowContentResolver.validateSyncExtrasBundle(extras);
        ShadowContentResolver.removePeriodicSync(account, authority, extras);
        ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncs.add(new PeriodicSync(account, authority, extras, pollFrequency));
    }

    @Implementation
    protected static void removePeriodicSync(Account account, String authority, Bundle extras) {
        ShadowContentResolver.validateSyncExtrasBundle(extras);
        Status status = ShadowContentResolver.getStatus(account, authority);
        if (status != null) {
            for (int i = 0; i < status.syncs.size(); ++i) {
                if (!ShadowContentResolver.isBundleEqual(extras, status.syncs.get((int)i).extras)) continue;
                status.syncs.remove(i);
                break;
            }
        }
    }

    @Implementation
    protected static List<PeriodicSync> getPeriodicSyncs(Account account, String authority) {
        return ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncs;
    }

    @Implementation
    protected static void validateSyncExtrasBundle(Bundle extras) {
        for (String key : extras.keySet()) {
            Object value = extras.get(key);
            if (value == null || value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Account) continue;
            throw new IllegalArgumentException("unexpected value type: " + value.getClass().getName());
        }
    }

    @Implementation
    protected static void setMasterSyncAutomatically(boolean sync) {
        masterSyncAutomatically = sync;
    }

    @Implementation
    protected static boolean getMasterSyncAutomatically() {
        return masterSyncAutomatically;
    }

    @Implementation(minSdk=19)
    protected void takePersistableUriPermission(Uri uri, int modeFlags) {
        Objects.requireNonNull(uri, "uri may not be null");
        if ((modeFlags &= 3) == 0) {
            return;
        }
        Iterator<UriPermission> i = uriPermissions.iterator();
        while (i.hasNext()) {
            UriPermission perm = i.next();
            if (!uri.equals((Object)perm.getUri())) continue;
            if (perm.isReadPermission()) {
                modeFlags |= 1;
            }
            if (perm.isWritePermission()) {
                modeFlags |= 2;
            }
            i.remove();
            break;
        }
        this.addUriPermission(uri, modeFlags);
    }

    @Implementation(minSdk=19)
    protected void releasePersistableUriPermission(Uri uri, int modeFlags) {
        Objects.requireNonNull(uri, "uri may not be null");
        if ((modeFlags &= 3) == 0) {
            return;
        }
        Iterator<UriPermission> i = uriPermissions.iterator();
        while (i.hasNext()) {
            UriPermission perm = i.next();
            if (!uri.equals((Object)perm.getUri())) continue;
            int oldModeFlags = (perm.isReadPermission() ? 1 : 0) | (perm.isWritePermission() ? 2 : 0);
            int newModeFlags = oldModeFlags & ~modeFlags;
            if (newModeFlags == oldModeFlags) break;
            i.remove();
            if (newModeFlags == 0) break;
            this.addUriPermission(uri, newModeFlags);
            break;
        }
    }

    @Implementation(minSdk=19)
    protected List<UriPermission> getPersistedUriPermissions() {
        return uriPermissions;
    }

    private void addUriPermission(Uri uri, int modeFlags) {
        UriPermission perm = (UriPermission)ReflectionHelpers.callConstructor(UriPermission.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Uri.class, (Object)uri), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)modeFlags), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)System.currentTimeMillis())});
        uriPermissions.add(perm);
    }

    public static ContentProvider getProvider(Uri uri) {
        return ShadowContentResolver.getProvider(uri, (Context)RuntimeEnvironment.getApplication());
    }

    private static ContentProvider getProvider(Uri uri, Context context) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return null;
        }
        return ShadowContentResolver.getProvider(uri.getAuthority(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContentProvider getProvider(String authority, Context context) {
        Map<String, ContentProvider> map = providers;
        synchronized (map) {
            ProviderInfo providerInfo;
            if (!providers.containsKey(authority) && (providerInfo = context.getPackageManager().resolveContentProvider(authority, 0)) != null) {
                ContentProvider contentProvider = ShadowContentResolver.createAndInitialize(providerInfo);
                for (String auth : Splitter.on((char)';').split((CharSequence)providerInfo.authority)) {
                    providers.put(auth, contentProvider);
                }
            }
            return providers.get(authority);
        }
    }

    public static void registerProviderInternal(String authority, ContentProvider provider) {
        providers.put(authority, provider);
    }

    public static Status getStatus(Account account, String authority) {
        return ShadowContentResolver.getStatus(account, authority, false);
    }

    public static Status getStatus(Account account, String authority, boolean create) {
        Status status;
        Map<Account, Status> map = syncableAccounts.get(authority);
        if (map == null) {
            map = new HashMap<Account, Status>();
            syncableAccounts.put(authority, map);
        }
        if ((status = map.get(account)) == null && create) {
            status = new Status();
            map.put(account, status);
        }
        return status;
    }

    @Deprecated
    public void setCursor(BaseCursor cursor) {
        this.cursor = cursor;
    }

    @Deprecated
    public void setCursor(Uri uri, BaseCursor cursorForUri) {
        uriCursorMap.put(uri, cursorForUri);
    }

    @Deprecated
    public void setNextDatabaseIdForInserts(int nextId) {
        this.nextDatabaseIdForInserts = nextId;
    }

    @Deprecated
    public List<Statement> getStatements() {
        return statements;
    }

    @Deprecated
    public List<InsertStatement> getInsertStatements() {
        return insertStatements;
    }

    @Deprecated
    public List<UpdateStatement> getUpdateStatements() {
        return updateStatements;
    }

    @Deprecated
    public List<Uri> getDeletedUris() {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        for (DeleteStatement deleteStatement : deleteStatements) {
            uris.add(deleteStatement.getUri());
        }
        return uris;
    }

    @Deprecated
    public List<DeleteStatement> getDeleteStatements() {
        return deleteStatements;
    }

    @Deprecated
    public List<NotifiedUri> getNotifiedUris() {
        return notifiedUris;
    }

    @Deprecated
    public List<ContentProviderOperation> getContentProviderOperations(String authority) {
        List<ContentProviderOperation> operations = contentProviderOperations.get(authority);
        if (operations == null) {
            return new ArrayList<ContentProviderOperation>();
        }
        return operations;
    }

    @Deprecated
    public void setContentProviderResult(ContentProviderResult[] contentProviderResults) {
        ShadowContentResolver.contentProviderResults = contentProviderResults;
    }

    public void setRegisterContentProviderException(Uri uri, RuntimeException exception) {
        this.registerContentProviderExceptions.put(uri, exception);
    }

    public void clearRegisterContentProviderException(Uri uri) {
        this.registerContentProviderExceptions.remove(uri);
    }

    @Implementation
    protected void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer) {
        if (uri == null || observer == null) {
            throw new NullPointerException();
        }
        if (this.registerContentProviderExceptions.containsKey(uri)) {
            throw this.registerContentProviderExceptions.get(uri);
        }
        contentObservers.add(new ContentObserverEntry(uri, notifyForDescendents, observer));
    }

    @Implementation(minSdk=17)
    protected void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer, int userHandle) {
        this.registerContentObserver(uri, notifyForDescendents, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void unregisterContentObserver(ContentObserver observer) {
        CopyOnWriteArrayList<ContentObserverEntry> copyOnWriteArrayList = contentObservers;
        synchronized (copyOnWriteArrayList) {
            for (ContentObserverEntry entry : contentObservers) {
                if (entry.observer != observer) continue;
                contentObservers.remove(entry);
            }
        }
    }

    @Implementation
    protected static SyncAdapterType[] getSyncAdapterTypes() {
        return syncAdapterTypes;
    }

    public static void setSyncAdapterTypes(SyncAdapterType[] syncAdapterTypes) {
        ShadowContentResolver.syncAdapterTypes = syncAdapterTypes;
    }

    public Collection<ContentObserver> getContentObservers(Uri uri) {
        ArrayList<ContentObserver> observers = new ArrayList<ContentObserver>(1);
        for (ContentObserverEntry entry : contentObservers) {
            if (!entry.matches(uri)) continue;
            observers.add(entry.observer);
        }
        return observers;
    }

    @Implementation(minSdk=29)
    protected static void onDbCorruption(String tag, String message, Throwable stacktrace) {
    }

    private static ContentProvider createAndInitialize(ProviderInfo providerInfo) {
        try {
            ContentProvider provider = (ContentProvider)Class.forName(providerInfo.name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            provider.attachInfo((Context)RuntimeEnvironment.application, providerInfo);
            return provider;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error instantiating class " + providerInfo.name, e);
        }
    }

    private BaseCursor getCursor(Uri uri) {
        if (uriCursorMap.get(uri) != null) {
            return uriCursorMap.get(uri);
        }
        if (this.cursor != null) {
            return this.cursor;
        }
        return null;
    }

    private static boolean isBundleEqual(Bundle bundle1, Bundle bundle2) {
        if (bundle1 == null || bundle2 == null) {
            return false;
        }
        if (bundle1.size() != bundle2.size()) {
            return false;
        }
        for (String key : bundle1.keySet()) {
            if (bundle1.get(key).equals(bundle2.get(key))) continue;
            return false;
        }
        return true;
    }

    static {
        uriPermissions = new ArrayList<UriPermission>();
        contentObservers = new CopyOnWriteArrayList();
        syncableAccounts = new HashMap<String, Map<Account, Status>>();
        providers = Collections.synchronizedMap(new HashMap());
    }

    @ForType(value=ContentResolver.class)
    static interface ContentResolverReflector {
        @Accessor(value="mContext")
        public Context getContext();

        @Direct
        public InputStream openInputStream(Uri var1) throws FileNotFoundException;

        @Direct
        public OutputStream openOutputStream(Uri var1, String var2) throws FileNotFoundException;
    }

    private static class UnregisteredInputStream
    extends InputStream
    implements NamedStream {
        private final Uri uri;

        UnregisteredInputStream(Uri uri) {
            this.uri = uri;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("You must use ShadowContentResolver.registerInputStream() in order to call read()");
        }

        @Override
        public int read(byte[] b) throws IOException {
            throw new UnsupportedOperationException("You must use ShadowContentResolver.registerInputStream() in order to call read()");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("You must use ShadowContentResolver.registerInputStream() in order to call read()");
        }

        public String toString() {
            return "stream for " + this.uri;
        }
    }

    public static class DeleteStatement
    extends Statement {
        private final String where;
        private final String[] selectionArgs;

        DeleteStatement(Uri uri, ContentProvider contentProvider, String where, String[] selectionArgs) {
            super(uri, contentProvider);
            this.where = where;
            this.selectionArgs = selectionArgs;
        }

        public String getWhere() {
            return this.where;
        }

        public String[] getSelectionArgs() {
            return this.selectionArgs;
        }
    }

    public static class UpdateStatement
    extends Statement {
        private final ContentValues values;
        private final String where;
        private final String[] selectionArgs;

        UpdateStatement(Uri uri, ContentProvider contentProvider, ContentValues values, String where, String[] selectionArgs) {
            super(uri, contentProvider);
            this.values = values;
            this.where = where;
            this.selectionArgs = selectionArgs;
        }

        public ContentValues getContentValues() {
            return this.values;
        }

        public String getWhere() {
            return this.where;
        }

        public String[] getSelectionArgs() {
            return this.selectionArgs;
        }
    }

    public static class InsertStatement
    extends Statement {
        private final ContentValues[] bulkContentValues;

        InsertStatement(Uri uri, ContentProvider contentProvider, ContentValues contentValues) {
            super(uri, contentProvider);
            this.bulkContentValues = new ContentValues[]{contentValues};
        }

        InsertStatement(Uri uri, ContentProvider contentProvider, ContentValues[] bulkContentValues) {
            super(uri, contentProvider);
            this.bulkContentValues = bulkContentValues;
        }

        public ContentValues getContentValues() {
            if (this.bulkContentValues.length != 1) {
                throw new ArrayIndexOutOfBoundsException("bulk insert, use getBulkContentValues() instead");
            }
            return this.bulkContentValues[0];
        }

        public ContentValues[] getBulkContentValues() {
            return this.bulkContentValues;
        }
    }

    public static class Statement {
        private final Uri uri;
        private final ContentProvider contentProvider;

        Statement(Uri uri, ContentProvider contentProvider) {
            this.uri = uri;
            this.contentProvider = contentProvider;
        }

        public Uri getUri() {
            return this.uri;
        }

        public ContentProvider getContentProvider() {
            return this.contentProvider;
        }
    }

    public static class Status {
        public int syncRequests;
        public int state = -1;
        public boolean syncAutomatically;
        public Bundle syncExtras;
        public List<PeriodicSync> syncs = new ArrayList<PeriodicSync>();
    }

    public static class NotifiedUri {
        public final Uri uri;
        public final boolean syncToNetwork;
        public final ContentObserver observer;

        public NotifiedUri(Uri uri, ContentObserver observer, boolean syncToNetwork) {
            this.uri = uri;
            this.syncToNetwork = syncToNetwork;
            this.observer = observer;
        }
    }

    private static class ContentObserverEntry {
        public final Uri uri;
        public final boolean notifyForDescendents;
        public final ContentObserver observer;

        private ContentObserverEntry(Uri uri, boolean notifyForDescendents, ContentObserver observer) {
            this.uri = uri;
            this.notifyForDescendents = notifyForDescendents;
            this.observer = observer;
            if (uri == null || observer == null) {
                throw new NullPointerException();
            }
        }

        public boolean matches(Uri test) {
            String testPath;
            if (!Objects.equals(this.uri.getScheme(), test.getScheme())) {
                return false;
            }
            if (!Objects.equals(this.uri.getAuthority(), test.getAuthority())) {
                return false;
            }
            String uriPath = this.uri.getPath();
            return Objects.equals(uriPath, testPath = test.getPath()) || this.notifyForDescendents && testPath != null && testPath.startsWith(uriPath);
        }
    }
}

