/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.LocaleManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.LocaleList;
import androidx.annotation.RequiresApi;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=LocaleManager.class, minSdk=33, isInAndroidSdk=false)
public class ShadowLocaleManager {
    private final Map<String, LocaleList> appLocales = new HashMap<String, LocaleList>();
    private final Set<String> packagesInstalledByCaller = new HashSet<String>();
    private boolean enforceInstallerCheck;

    @Implementation
    @RequiresApi(api=24)
    protected LocaleList getApplicationLocales(String packageName) {
        if (this.enforceInstallerCheck && !this.packagesInstalledByCaller.contains(packageName)) {
            throw new SecurityException("Caller does not have permission to query locales for package " + packageName);
        }
        return this.appLocales.getOrDefault(packageName, LocaleList.getEmptyLocaleList());
    }

    @Implementation
    protected void setApplicationLocales(String packageName, LocaleList locales) {
        this.appLocales.put(packageName, locales);
    }

    @Implementation
    @RequiresApi(api=24)
    protected LocaleList getSystemLocales() {
        Configuration configuration = Resources.getSystem().getConfiguration();
        if (configuration != null) {
            return configuration.getLocales();
        }
        return LocaleList.getEmptyLocaleList();
    }

    public void enforceInstallerCheck(boolean value) {
        this.enforceInstallerCheck = value;
    }

    public void setCallerAsInstallerForPackage(String packageName) {
        this.packagesInstalledByCaller.add(packageName);
    }
}

